/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "knative.dev/networking/pkg/apis/networking/v1alpha1"
)

// FakeRealms implements RealmInterface
type FakeRealms struct {
	Fake *FakeNetworkingV1alpha1
}

var realmsResource = v1alpha1.SchemeGroupVersion.WithResource("realms")

var realmsKind = v1alpha1.SchemeGroupVersion.WithKind("Realm")

// Get takes name of the realm, and returns the corresponding realm object, and an error if there is any.
func (c *FakeRealms) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Realm, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(realmsResource, name), &v1alpha1.Realm{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Realm), err
}

// List takes label and field selectors, and returns the list of Realms that match those selectors.
func (c *FakeRealms) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.RealmList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(realmsResource, realmsKind, opts), &v1alpha1.RealmList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.RealmList{ListMeta: obj.(*v1alpha1.RealmList).ListMeta}
	for _, item := range obj.(*v1alpha1.RealmList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested realms.
func (c *FakeRealms) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(realmsResource, opts))
}

// Create takes the representation of a realm and creates it.  Returns the server's representation of the realm, and an error, if there is any.
func (c *FakeRealms) Create(ctx context.Context, realm *v1alpha1.Realm, opts v1.CreateOptions) (result *v1alpha1.Realm, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(realmsResource, realm), &v1alpha1.Realm{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Realm), err
}

// Update takes the representation of a realm and updates it. Returns the server's representation of the realm, and an error, if there is any.
func (c *FakeRealms) Update(ctx context.Context, realm *v1alpha1.Realm, opts v1.UpdateOptions) (result *v1alpha1.Realm, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(realmsResource, realm), &v1alpha1.Realm{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Realm), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeRealms) UpdateStatus(ctx context.Context, realm *v1alpha1.Realm, opts v1.UpdateOptions) (*v1alpha1.Realm, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(realmsResource, "status", realm), &v1alpha1.Realm{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Realm), err
}

// Delete takes name of the realm and deletes it. Returns an error if one occurs.
func (c *FakeRealms) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(realmsResource, name, opts), &v1alpha1.Realm{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeRealms) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(realmsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.RealmList{})
	return err
}

// Patch applies the patch and returns the patched realm.
func (c *FakeRealms) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Realm, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(realmsResource, name, pt, data, subresources...), &v1alpha1.Realm{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Realm), err
}
