/*	$Id: context.h,v 1.4 2010/01/17 15:07:52 steve Exp $	*/

/*-
 * Copyright (c) 2001 Steve C. Woodford.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by Steve C. Woodford.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __context_h
#define __context_h

#include <sys/types.h>
#include <sys/poll.h>

#include "client.h"

struct context {
	TAILQ_ENTRY(context)	c_qent;
	char			*c_name;
	struct client_ctx	*c_server;
	struct client_qhead	c_clients;
	struct client_qhead	c_exclusive;
	int			c_client_count;
	int			c_total_clients;
};
TAILQ_HEAD(context_qhead, context);


extern int	context_init(struct context **, const char *);
extern void	context_destroy(struct context *);
extern int	context_set_server(struct context *, struct client_ctx *);
extern int	context_add_client(struct context *, struct client_ctx *);
extern int	context_del_client(struct context *, struct client_ctx *);
extern int	context_setup_pollfds(struct context *, struct pollfd *);
extern int	context_client_output(struct context *, const char *, size_t,
		    struct client_ctx *);
extern int	context_client_ioctl(struct context *, int, void *,
		    struct client_ctx *);
extern int	context_server_output(struct context *, const char *, size_t,
		    struct client_ctx *);

#define context_server_ioctl(c,i,a,s)   client_ioctl((c)->c_server,(i),(a),(s))

extern const char *cf_context_init(void *, char **, int, int, void *);

#define	CONTEXT_IOCTL_NEW_SERVER	TITS_IOCODE(TITS_SUBSYS_CONTEXT, 0)
#define	CONTEXT_IOCTL_ADD_CLIENT	TITS_IOCODE(TITS_SUBSYS_CONTEXT, 1)
#define	CONTEXT_IOCTL_DEL_CLIENT	TITS_IOCODE(TITS_SUBSYS_CONTEXT, 2)

#endif /* __context_h */
