/*	$Id: server.c,v 1.4 2006/10/06 23:38:24 steve Exp $	*/

/*-
 * Copyright (c) 2001 Steve C. Woodford.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by Steve C. Woodford.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>

#include "context.h"
#include "config.h"
#include "server.h"
#include "tty.h"
#include "rtelnet.h"


static struct client_ops *server_types[] = {
	&tty_ops,
	&rtelnet_ops,
	NULL
};


/* ARGSUSED */
const char *
cf_server_init(void *cs, char **argv, int argc, int is_compound, void *arg)
{
	struct context *ctx = arg;
	struct client_ops **co;
	struct client_ctx *server;
	void *server_arg;
	const char *errstr;

	for (co = server_types; *co; co++)
		if (strcasecmp((*co)->co_name, argv[1]) == 0)
			break;

	if (*co == NULL)
		return (config_err(cs, "Unknown server type `%s'", argv[1]));

	errstr = ((*co)->co_cf_init)(cs, argv, argc, 1, &server_arg);
	if (errstr)
		return (errstr);

	if (client_init(&server, NULL, *co, NULL, server_arg) < 0)
		return (config_err(cs, "Failed to start server `%s'", argv[1]));

	if (context_set_server(ctx, server) < 0) {
		client_destroy(server);
		return (config_err(cs, "Failed to link server `%s'", argv[1]));
	}

	return (NULL);
}
