#include <tcwdb.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>

int main(int argc, char **argv){
  TCWDB *wdb;
  int ecode, rnum, i;
  uint64_t *result;

  /* create the object */
  wdb = tcwdbnew();

  /* open the database */
  if(!tcwdbopen(wdb, "casket", WDBOWRITER | WDBOCREAT)){
    ecode = tcwdbecode(wdb);
    fprintf(stderr, "open error: %s\n", tcwdberrmsg(ecode));
  }

  /* store records */
  if(!tcwdbput2(wdb, 1, "George Washington", NULL) ||
     !tcwdbput2(wdb, 2, "John Adams", NULL) ||
     !tcwdbput2(wdb, 3, "Thomas Jefferson", NULL)){
    ecode = tcwdbecode(wdb);
    fprintf(stderr, "put error: %s\n", tcwdberrmsg(ecode));
  }

  /* search records */
  result = tcwdbsearch(wdb, "John", &rnum);
  if(result){
    for(i = 0; i < rnum; i++){
      printf("%d\n", (int)result[i]);
    }
    free(result);
  } else {
    ecode = tcwdbecode(wdb);
    fprintf(stderr, "search error: %s\n", tcwdberrmsg(ecode));
  }

  /* close the database */
  if(!tcwdbclose(wdb)){
    ecode = tcwdbecode(wdb);
    fprintf(stderr, "close error: %s\n", tcwdberrmsg(ecode));
  }

  /* delete the object */
  tcwdbdel(wdb);

  return 0;
}
