// SPDX-License-Identifier: BSD-3-Clause
/*
 * Intel Arria 10 SoCFPGA configuration
 */

#ifndef __SOCFPGA_ARRIA10_CONFIG_H__
#define __SOCFPGA_ARRIA10_CONFIG_H__

/* Clocks */
#define CB_INTOSC_LS_CLK_HZ 60000000
#define EMAC0_CLK_HZ 250000000
#define EMAC1_CLK_HZ 250000000
#define EMAC2_CLK_HZ 250000000
#define EOSC1_CLK_HZ 33330000
#define F2H_FREE_CLK_HZ 200000000
#define H2F_USER0_CLK_HZ 200000000
#define H2F_USER1_CLK_HZ 100000000
#define L3_MAIN_FREE_CLK_HZ 200000000
#define SDMMC_CLK_HZ 200000000
#define TPIU_CLK_HZ 100000000
#define MAINPLLGRP_CNTR15CLK_CNT 900
#define MAINPLLGRP_CNTR2CLK_CNT 900
#define MAINPLLGRP_CNTR3CLK_CNT 900
#define MAINPLLGRP_CNTR4CLK_CNT 900
#define MAINPLLGRP_CNTR5CLK_CNT 900
#define MAINPLLGRP_CNTR6CLK_CNT 7
#define MAINPLLGRP_CNTR7CLK_CNT 7
#define MAINPLLGRP_CNTR7CLK_SRC 0
#define MAINPLLGRP_CNTR8CLK_CNT 15
#define MAINPLLGRP_CNTR9CLK_CNT 900
#define MAINPLLGRP_CNTR9CLK_SRC 0
#define MAINPLLGRP_MPUCLK_CNT 0
#define MAINPLLGRP_MPUCLK_SRC 0
#define MAINPLLGRP_NOCCLK_CNT 0
#define MAINPLLGRP_NOCCLK_SRC 0
#define MAINPLLGRP_NOCDIV_CSATCLK 0
#define MAINPLLGRP_NOCDIV_CSPDBGCLK 1
#define MAINPLLGRP_NOCDIV_CSTRACECLK 0
#define MAINPLLGRP_NOCDIV_L4MAINCLK 0
#define MAINPLLGRP_NOCDIV_L4MPCLK 1
#define MAINPLLGRP_NOCDIV_L4SPCLK 2
#define MAINPLLGRP_VCO0_PSRC 0
#define MAINPLLGRP_VCO1_DENOM 32
#define MAINPLLGRP_VCO1_NUMER 1584
#define PERPLLGRP_CNTR2CLK_CNT 5
#define PERPLLGRP_CNTR2CLK_SRC 1
#define PERPLLGRP_CNTR3CLK_CNT 900
#define PERPLLGRP_CNTR3CLK_SRC 1
#define PERPLLGRP_CNTR4CLK_CNT 14
#define PERPLLGRP_CNTR4CLK_SRC 1
#define PERPLLGRP_CNTR5CLK_CNT 374
#define PERPLLGRP_CNTR5CLK_SRC 1
#define PERPLLGRP_CNTR6CLK_CNT 900
#define PERPLLGRP_CNTR6CLK_SRC 0
#define PERPLLGRP_CNTR7CLK_CNT 900
#define PERPLLGRP_CNTR8CLK_CNT 900
#define PERPLLGRP_CNTR8CLK_SRC 0
#define PERPLLGRP_CNTR9CLK_CNT 900
#define PERPLLGRP_EMACCTL_EMAC0SEL 0
#define PERPLLGRP_EMACCTL_EMAC1SEL 0
#define PERPLLGRP_EMACCTL_EMAC2SEL 0
#define PERPLLGRP_GPIODIV_GPIODBCLK 32000
#define PERPLLGRP_VCO0_PSRC 0
#define PERPLLGRP_VCO1_DENOM 32
#define PERPLLGRP_VCO1_NUMER 1485
#define CLKMGR_TESTIOCTRL_DEBUGCLKSEL 16
#define CLKMGR_TESTIOCTRL_MAINCLKSEL 8
#define CLKMGR_TESTIOCTRL_PERICLKSEL 8
#define ALTERAGRP_MPUCLK_MAINCNT 1
#define ALTERAGRP_MPUCLK_PERICNT 900
#define ALTERAGRP_NOCCLK_MAINCNT 7
#define ALTERAGRP_NOCCLK_PERICNT 900
#define ALTERAGRP_MPUCLK ((ALTERAGRP_MPUCLK_PERICNT << 16) | \
	(ALTERAGRP_MPUCLK_MAINCNT))
#define ALTERAGRP_NOCCLK ((ALTERAGRP_NOCCLK_PERICNT << 16) | \
	(ALTERAGRP_NOCCLK_MAINCNT))

/* Pin Mux Configuration */
#define CONFIG_IO_10_INPUT_BUF_EN 1
#define CONFIG_IO_10_PD_DRV_STRG 10
#define CONFIG_IO_10_PD_SLW_RT 1
#define CONFIG_IO_10_PU_DRV_STRG 8
#define CONFIG_IO_10_PU_SLW_RT 1
#define CONFIG_IO_10_RTRIM 1
#define CONFIG_IO_10_WK_PU_EN 0
#define CONFIG_IO_11_INPUT_BUF_EN 1
#define CONFIG_IO_11_PD_DRV_STRG 10
#define CONFIG_IO_11_PD_SLW_RT 1
#define CONFIG_IO_11_PU_DRV_STRG 8
#define CONFIG_IO_11_PU_SLW_RT 1
#define CONFIG_IO_11_RTRIM 1
#define CONFIG_IO_11_WK_PU_EN 0
#define CONFIG_IO_12_INPUT_BUF_EN 0
#define CONFIG_IO_12_PD_DRV_STRG 0
#define CONFIG_IO_12_PD_SLW_RT 0
#define CONFIG_IO_12_PU_DRV_STRG 0
#define CONFIG_IO_12_PU_SLW_RT 0
#define CONFIG_IO_12_RTRIM 1
#define CONFIG_IO_12_WK_PU_EN 1
#define CONFIG_IO_13_INPUT_BUF_EN 0
#define CONFIG_IO_13_PD_DRV_STRG 0
#define CONFIG_IO_13_PD_SLW_RT 0
#define CONFIG_IO_13_PU_DRV_STRG 0
#define CONFIG_IO_13_PU_SLW_RT 0
#define CONFIG_IO_13_RTRIM 1
#define CONFIG_IO_13_WK_PU_EN 1
#define CONFIG_IO_14_INPUT_BUF_EN 0
#define CONFIG_IO_14_PD_DRV_STRG 0
#define CONFIG_IO_14_PD_SLW_RT 0
#define CONFIG_IO_14_PU_DRV_STRG 0
#define CONFIG_IO_14_PU_SLW_RT 0
#define CONFIG_IO_14_RTRIM 1
#define CONFIG_IO_14_WK_PU_EN 1
#define CONFIG_IO_15_INPUT_BUF_EN 0
#define CONFIG_IO_15_PD_DRV_STRG 0
#define CONFIG_IO_15_PD_SLW_RT 0
#define CONFIG_IO_15_PU_DRV_STRG 0
#define CONFIG_IO_15_PU_SLW_RT 0
#define CONFIG_IO_15_RTRIM 1
#define CONFIG_IO_15_WK_PU_EN 1
#define CONFIG_IO_16_INPUT_BUF_EN 0
#define CONFIG_IO_16_PD_DRV_STRG 10
#define CONFIG_IO_16_PD_SLW_RT 1
#define CONFIG_IO_16_PU_DRV_STRG 8
#define CONFIG_IO_16_PU_SLW_RT 1
#define CONFIG_IO_16_RTRIM 1
#define CONFIG_IO_16_WK_PU_EN 0
#define CONFIG_IO_17_INPUT_BUF_EN 1
#define CONFIG_IO_17_PD_DRV_STRG 10
#define CONFIG_IO_17_PD_SLW_RT 1
#define CONFIG_IO_17_PU_DRV_STRG 8
#define CONFIG_IO_17_PU_SLW_RT 1
#define CONFIG_IO_17_RTRIM 1
#define CONFIG_IO_17_WK_PU_EN 0
#define CONFIG_IO_1_INPUT_BUF_EN 1
#define CONFIG_IO_1_PD_DRV_STRG 10
#define CONFIG_IO_1_PD_SLW_RT 0
#define CONFIG_IO_1_PU_DRV_STRG 8
#define CONFIG_IO_1_PU_SLW_RT 0
#define CONFIG_IO_1_RTRIM 1
#define CONFIG_IO_1_WK_PU_EN 1
#define CONFIG_IO_2_INPUT_BUF_EN 1
#define CONFIG_IO_2_PD_DRV_STRG 10
#define CONFIG_IO_2_PD_SLW_RT 0
#define CONFIG_IO_2_PU_DRV_STRG 8
#define CONFIG_IO_2_PU_SLW_RT 0
#define CONFIG_IO_2_RTRIM 1
#define CONFIG_IO_2_WK_PU_EN 1
#define CONFIG_IO_3_INPUT_BUF_EN 1
#define CONFIG_IO_3_PD_DRV_STRG 10
#define CONFIG_IO_3_PD_SLW_RT 0
#define CONFIG_IO_3_PU_DRV_STRG 8
#define CONFIG_IO_3_PU_SLW_RT 0
#define CONFIG_IO_3_RTRIM 1
#define CONFIG_IO_3_WK_PU_EN 1
#define CONFIG_IO_4_INPUT_BUF_EN 1
#define CONFIG_IO_4_PD_DRV_STRG 10
#define CONFIG_IO_4_PD_SLW_RT 1
#define CONFIG_IO_4_PU_DRV_STRG 8
#define CONFIG_IO_4_PU_SLW_RT 1
#define CONFIG_IO_4_RTRIM 1
#define CONFIG_IO_4_WK_PU_EN 0
#define CONFIG_IO_5_INPUT_BUF_EN 1
#define CONFIG_IO_5_PD_DRV_STRG 10
#define CONFIG_IO_5_PD_SLW_RT 1
#define CONFIG_IO_5_PU_DRV_STRG 8
#define CONFIG_IO_5_PU_SLW_RT 1
#define CONFIG_IO_5_RTRIM 1
#define CONFIG_IO_5_WK_PU_EN 0
#define CONFIG_IO_6_INPUT_BUF_EN 0
#define CONFIG_IO_6_PD_DRV_STRG 10
#define CONFIG_IO_6_PD_SLW_RT 1
#define CONFIG_IO_6_PU_DRV_STRG 8
#define CONFIG_IO_6_PU_SLW_RT 1
#define CONFIG_IO_6_RTRIM 1
#define CONFIG_IO_6_WK_PU_EN 0
#define CONFIG_IO_7_INPUT_BUF_EN 1
#define CONFIG_IO_7_PD_DRV_STRG 10
#define CONFIG_IO_7_PD_SLW_RT 1
#define CONFIG_IO_7_PU_DRV_STRG 8
#define CONFIG_IO_7_PU_SLW_RT 1
#define CONFIG_IO_7_RTRIM 1
#define CONFIG_IO_7_WK_PU_EN 0
#define CONFIG_IO_8_INPUT_BUF_EN 1
#define CONFIG_IO_8_PD_DRV_STRG 10
#define CONFIG_IO_8_PD_SLW_RT 1
#define CONFIG_IO_8_PU_DRV_STRG 8
#define CONFIG_IO_8_PU_SLW_RT 1
#define CONFIG_IO_8_RTRIM 1
#define CONFIG_IO_8_WK_PU_EN 0
#define CONFIG_IO_9_INPUT_BUF_EN 1
#define CONFIG_IO_9_PD_DRV_STRG 10
#define CONFIG_IO_9_PD_SLW_RT 1
#define CONFIG_IO_9_PU_DRV_STRG 8
#define CONFIG_IO_9_PU_SLW_RT 1
#define CONFIG_IO_9_RTRIM 1
#define CONFIG_IO_9_WK_PU_EN 0
#define CONFIG_IO_BANK_VOLTAGE_SEL_CLKRST_IO 1
#define CONFIG_IO_BANK_VOLTAGE_SEL_PERI_IO 1
#define PINMUX_DEDICATED_IO_10_SEL 15
#define PINMUX_DEDICATED_IO_11_SEL 15
#define PINMUX_DEDICATED_IO_12_SEL 1
#define PINMUX_DEDICATED_IO_13_SEL 1
#define PINMUX_DEDICATED_IO_14_SEL 10
#define PINMUX_DEDICATED_IO_15_SEL 10
#define PINMUX_DEDICATED_IO_16_SEL 13
#define PINMUX_DEDICATED_IO_17_SEL 13
#define PINMUX_DEDICATED_IO_4_SEL 8
#define PINMUX_DEDICATED_IO_5_SEL 8
#define PINMUX_DEDICATED_IO_6_SEL 8
#define PINMUX_DEDICATED_IO_7_SEL 8
#define PINMUX_DEDICATED_IO_8_SEL 8
#define PINMUX_DEDICATED_IO_9_SEL 8
#define PINMUX_I2C0_USEFPGA_SEL 1
#define PINMUX_I2C1_USEFPGA_SEL 0
#define PINMUX_I2CEMAC0_USEFPGA_SEL 0
#define PINMUX_I2CEMAC1_USEFPGA_SEL 0
#define PINMUX_I2CEMAC2_USEFPGA_SEL 0
#define PINMUX_NAND_USEFPGA_SEL 0
#define PINMUX_PLL_CLOCK_OUT_USEFPGA_SEL 0
#define PINMUX_QSPI_USEFPGA_SEL 0
#define PINMUX_RGMII0_USEFPGA_SEL 0
#define PINMUX_RGMII1_USEFPGA_SEL 0
#define PINMUX_RGMII2_USEFPGA_SEL 0
#define PINMUX_SDMMC_USEFPGA_SEL 0
#define PINMUX_SHARED_IO_Q1_10_SEL 8
#define PINMUX_SHARED_IO_Q1_11_SEL 8
#define PINMUX_SHARED_IO_Q1_12_SEL 8
#define PINMUX_SHARED_IO_Q1_1_SEL 8
#define PINMUX_SHARED_IO_Q1_2_SEL 8
#define PINMUX_SHARED_IO_Q1_3_SEL 8
#define PINMUX_SHARED_IO_Q1_4_SEL 8
#define PINMUX_SHARED_IO_Q1_5_SEL 8
#define PINMUX_SHARED_IO_Q1_6_SEL 8
#define PINMUX_SHARED_IO_Q1_7_SEL 8
#define PINMUX_SHARED_IO_Q1_8_SEL 8
#define PINMUX_SHARED_IO_Q1_9_SEL 8
#define PINMUX_SHARED_IO_Q2_10_SEL 4
#define PINMUX_SHARED_IO_Q2_11_SEL 4
#define PINMUX_SHARED_IO_Q2_12_SEL 4
#define PINMUX_SHARED_IO_Q2_1_SEL 4
#define PINMUX_SHARED_IO_Q2_2_SEL 4
#define PINMUX_SHARED_IO_Q2_3_SEL 4
#define PINMUX_SHARED_IO_Q2_4_SEL 4
#define PINMUX_SHARED_IO_Q2_5_SEL 4
#define PINMUX_SHARED_IO_Q2_6_SEL 4
#define PINMUX_SHARED_IO_Q2_7_SEL 4
#define PINMUX_SHARED_IO_Q2_8_SEL 4
#define PINMUX_SHARED_IO_Q2_9_SEL 4
#define PINMUX_SHARED_IO_Q3_10_SEL 15
#define PINMUX_SHARED_IO_Q3_11_SEL 1
#define PINMUX_SHARED_IO_Q3_12_SEL 1
#define PINMUX_SHARED_IO_Q3_1_SEL 15
#define PINMUX_SHARED_IO_Q3_2_SEL 15
#define PINMUX_SHARED_IO_Q3_3_SEL 15
#define PINMUX_SHARED_IO_Q3_4_SEL 15
#define PINMUX_SHARED_IO_Q3_5_SEL 15
#define PINMUX_SHARED_IO_Q3_6_SEL 15
#define PINMUX_SHARED_IO_Q3_7_SEL 0
#define PINMUX_SHARED_IO_Q3_8_SEL 0
#define PINMUX_SHARED_IO_Q3_9_SEL 15
#define PINMUX_SHARED_IO_Q4_10_SEL 10
#define PINMUX_SHARED_IO_Q4_11_SEL 10
#define PINMUX_SHARED_IO_Q4_12_SEL 10
#define PINMUX_SHARED_IO_Q4_1_SEL 10
#define PINMUX_SHARED_IO_Q4_2_SEL 10
#define PINMUX_SHARED_IO_Q4_3_SEL 10
#define PINMUX_SHARED_IO_Q4_4_SEL 10
#define PINMUX_SHARED_IO_Q4_5_SEL 10
#define PINMUX_SHARED_IO_Q4_6_SEL 10
#define PINMUX_SHARED_IO_Q4_7_SEL 10
#define PINMUX_SHARED_IO_Q4_8_SEL 10
#define PINMUX_SHARED_IO_Q4_9_SEL 10
#define PINMUX_SPIM0_USEFPGA_SEL 0
#define PINMUX_SPIM1_USEFPGA_SEL 0
#define PINMUX_SPIS0_USEFPGA_SEL 0
#define PINMUX_SPIS1_USEFPGA_SEL 0
#define PINMUX_UART0_USEFPGA_SEL 1
#define PINMUX_UART1_USEFPGA_SEL 0
#define PINMUX_USB0_USEFPGA_SEL 0
#define PINMUX_USB1_USEFPGA_SEL 0

/* Bridge Configuration */
#define F2H_AXI_SLAVE 1
#define F2SDRAM0_AXI_SLAVE 1
#define F2SDRAM1_AXI_SLAVE 1
#define F2SDRAM2_AXI_SLAVE 1
#define H2F_AXI_MASTER 1
#define LWH2F_AXI_MASTER 1

/* Voltage Select for Config IO */
#define CONFIG_IO_BANK_VSEL \
	(((CONFIG_IO_BANK_VOLTAGE_SEL_CLKRST_IO & 0x3) << 8) | \
	(CONFIG_IO_BANK_VOLTAGE_SEL_PERI_IO & 0x3))

/* Macro for Config IO bit mapping */
#define CONFIG_IO_MACRO(NAME) (((NAME ## _RTRIM & 0xff) << 19) | \
	((NAME ## _INPUT_BUF_EN & 0x3) << 17) | \
	((NAME ## _WK_PU_EN & 0x1) << 16) | \
	((NAME ## _PU_SLW_RT & 0x1) << 13) | \
	((NAME ## _PU_DRV_STRG & 0xf) << 8) | \
	((NAME ## _PD_SLW_RT & 0x1) << 5) | \
	(NAME ## _PD_DRV_STRG & 0x1f))

#endif /* __SOCFPGA_ARRIA10_CONFIG_H__ */
