;;************************************************************************
;; graphelp.lsp 
;; contains help methods for the welcome message, the listener,
;; for spreadplots, printing, and reports, and for the basic set of plots
;; copyright (c) 1991-98 by Forrest W. Young
;;************************************************************************

(defmeth graph-window-proto :plot-help ()
  (plot-help-window (strcat "Help for " (send self :title)))
  (paste-plot-help (format nil "No help is available for this window."))
  (show-plot-help))

(defun listener-help () 
  (plot-help-window (strcat "Help: Listener Window"))
#-macintosh(paste-plot-help (format nil "The Listener Window presents reports produced by the SUMMARIZE DATA and REPORT MODEL menu items. The Listener also displays messages about ViSta's operation and provides a place for entering programs in the underlying Lisp language, and its Lisp-Stat and ViDAL extensions.~2%"))
#+macintosh(paste-plot-help (format nil "The Listener Window displays messages about ViSta's operation and provides a place for typing statements in the underlying Lisp language, and its Lisp-Stat and ViDAL extensions.~2%"))
  (paste-plot-help (format nil "To save the information written to the Listener, use the Command Menu's RECORD LISTENER item. This item is a toggle which turns recording on and off. All information that appears in the window while the item is checkmarked (e.g., AFTER you use the item the first time and before you use it again) will be recorded in the file you specify in the file dialog.~2%"))
  (paste-plot-help (format nil "For more information about using the Listener for programming, see Luke Tierney's book on Lisp-Stat, and Forrest Young's forthcoming book on ViSta."))
  (show-plot-help))

(defun print-output ()
  (plot-help-window (strcat "Help: Printing"))
  (paste-plot-help (format nil "You can print ViSta results --- but not with ViSta. Instead, you use ViSta to save a copy of your results, and then you use another program to print them. Here's how you do it:~2%"))
#-macintosh (paste-plot-help (format nil "PRINTING ALL WINDOWS EXCEPT THE LISTENER:~%"))
#+macintosh (paste-plot-help (format nil "PRINTING ALL WINDOWS EXCEPT THE LISTENER, REPORT AND SUMMARY WINDOWS~%"))
(paste-plot-help (format nil "1) Open and select the window with the information you wish to print.~%2) Use the EDIT menu's COPY item to copy the contents of the window to the clipboard.~%3) Use a word processing or graphics program to read the clipboard and then print the window.~2%"))
#+macintosh(paste-plot-help (format nil "PRINTING REPORTS AND SUMMARIES:~%"))
#+macintosh(paste-plot-help (format nil "1) Open the window with the information you wish to print.~%2) Use the FILE menu's SAVE EDIT item to save the contents of the window to a file.~%3) Use SIMPLETEXT to print the information, using the MONACO 9-point font.~2%"))
(paste-plot-help (format nil "PRINTING THE LISTENER:~%To print the information in the Listener, you must specify that you wish to record the information to a file, BEFORE the information is generated. This is done by using the Command Menu's RECORD LISTENER item. This item is a toggle which turns recording on and off. All information that appears in the window while the item is checkmarked (e.g., AFTER you use the item the first time and before you use it again) will be recorded in the file you specify in the file dialog. The file can then be printed with "))
#+macintosh(paste-plot-help (format nil "SIMPLETEXT, using the MONACO 9-point font."))
#-macintosh(paste-plot-help (format nil "a text or word processor."))
  (show-plot-help))

(defmeth histogram-proto :plot-help (&key (flush t)) 
  (let ((overlay (first (send self :slot-value (quote overlays))))
        (w (plot-help-window 
            (strcat "Help for " (send self :title)) :flush flush))) 
    (paste-plot-help (format nil 
"The Histogram is designed to show you the shape of a variable's distribution. It does this by breaking the range of the variable's values into equal-sized intervals called BINS. It then displays the number of observations that fall into the interval (are in the BIN) as a bar whose height is proportional to the frequency in the interval. The higher the bar, the greater the frequency in the bin.~2%") w)
    (when (send overlay :density)
          (paste-plot-help
           (format nil
                   "The CURVES button can be used to add or remove several different distribution curves, including the normal distribution and several curves called \"kernel density distribution curves\". The kernel density distribution curves provide several alternate ways of approximating the shape of the population distribution. If the kernel density curves roughly approximate the normal distribution curve, then the variable's distribution approximates normality.~2%")))
    (when (send overlay :normal)
          (paste-plot-help 
           (format nil 
                   "The NORMAL button can be used to add or remove a normal distribution with the variable's mean and variance. If the histogram roughly approximates the normal distribution, then the variable's distribution approximates normality.~2%")))
(paste-plot-help (format nil 
"Unfortunately, the Histogram is notorious for presenting an impression of the shape of the variable's distribution that is very dependent on the number of bins choosen. Changing the number of bins may radically change the apparent shape of the distribution. Even more unfortunately, there is no entirely satisfactory way to solve this problem.~2%") w)
    (when (send overlay :bins)
          (paste-plot-help 
           (format nil
                   "For this reason, the BINS button at the top of the graph allows you to dynamically change the number of bins and watch the graph change in an animated way. You should always you this button to get a better impression of the distribution's shape, and to choose a good number of bins that adequately portrays the shape.~2%") w))
(when (send overlay :new-x)
(paste-plot-help  (format nil "When you click on the NEW X button at the top of the graph you will be presented with a list of variables to display. Clicking on a variable will change the plot to display that variable's Histogram.") w))
(show-plot-help)
    ))

(defmeth scatterplot-proto :plot-help (&key (flush t))
  (let ((overlay (first (send self :slot-value (quote overlays))))
        (w (plot-help-window (strcat "Help for " (send self :title))
                              :flush flush)))
    (paste-plot-help (format nil 
"The scatterplot is designed to display the relationship between two variables. The variables are represented by the X-axis and Y-axis.  The observed values on the two varibles are represented by points in the scatterplot. Each point  represents the values for (usually) one observation on two variables. The value can be approximately determined by seeing what value the point is above on the X-axis, and to the right of on the Y-axis.~2%") w)
(paste-plot-help (format nil 
"Two normally distributed variables will have a scatterplot which has the greatest density in the middle, is roughly eliptical in shape, and has no obvious outliers.~2%") w)
(when (send overlay :new-x)
(paste-plot-help  (format nil "When you click on the NEW X or NEW Y button at the top of the graph you will be presented with a list of variables. Clicking on a variable will change the plot to display a scatterplot of the new variables.") w))
(show-plot-help)
))

(defmeth spin-proto :plot-help (&key (flush t))
  (let ((w (plot-help-window (strcat "Help for " (send self :title))
                              :flush flush)))
    (paste-plot-help (format nil 
"The Spin plot presents a three-dimensional scatterplot which you can spin to observe the distribution of your data in three dimensions.~2%") w)
#|(paste-plot-help (format nil 
"The PITCH, ROLL, YAW and SPEED buttons at the bottom of the window control spinning (PITCH is up and down, ROLL is clockwise and counterclockwise, and YAW is left and right). ~2%") w)|#
(paste-plot-help (format nil 
"The Up/Dn, C/CC, and L/R buttons at the bottom of the window control spinning direction(the button names mean Up/Down, Clockwise/Counterclockwise and Left/Right). Click on a button to change direction. The SPEED buttons control the speed of spinning. Hold down a button to gradually increase or decrease the speed.~2%") w)
(paste-plot-help (format nil
"The SPIN button starts and stops rotation. You can also spin the space by using the HAND ROTATE tool (whose cursor is a hand) and dragging your cursor around the space. If your cursor is not a hand, you can get this tool by clicking on the MOUSE button at the top of the window. ") w)
(paste-plot-help (format nil "Finally, you can spin the space by holding down the shift key while you click on the rotate buttons, or while you use the HAND ROTATE tool: The spinning will continue by itself until you click on the SPIN button.~2%") w)
(paste-plot-help (format nil
"The HOME button returns the space to its original orientation and stops rotation.  The ROCK button reverses the direction of rotation: Repeatedly clicking on this button rocks the space back and forth, giving you a better view of the detailed location of points in the space. The CLIP button clips off garbage that sometimes appears at the edges of the window. Holding down a ZOOM button will gradually zoom the space in or out.~2%") w)
(when (send self :depth-cuing)
      (paste-plot-help (format nil
"Notice that the points in the space change in size as the space spins. This is to show whether they are close to you (larger) or far away (smaller).~2%") w))
(paste-plot-help (format nil
"At the top of the window are buttons that give you this help message, turn color on and off, and allow you to change the mouse-mode."))
(mapcar 
 #'(lambda (i)          
     (let ((overlay 
            (select (send self :slot-value 'overlays) i)))
       (when (send overlay :has-slot 'box)
             (when (send overlay :box)
                   (paste-plot-help  (format nil 
"In addition, the BOX button allows you to add or remove a three-dimensional box that encompasses the data points."))))))
 (iseq (length (send self :slot-value 'overlays))))
(mapcar #'(lambda (i)
               (let ((overlay (select (send self :slot-value 'overlays) i)))
                 (when (send overlay :has-slot 'new-x)
                       (when (send overlay :new-x)
                             (paste-plot-help  (format nil 
"The X, Y and Z buttons allow you to change which variable is shown on the X, Y, or Z axis."))))))
           (iseq (length (send self :slot-value 'overlays))))
    (show-plot-help))
  )

(defmeth scatmat-proto :plot-help (&key (flush t))
  (let ((overlay (first (send self :slot-value (quote overlays))))
        (w (plot-help-window (strcat "Help for " (send self :title))
                              :flush flush)))
    (paste-plot-help (format nil 
"The scatterplot matrix is designed to display the relationship between all pairs of several variables. The plot matrix consists of plotcells containing little scatterplots formed from a pair of variables. The variables are represented by the X-axis and Y-axis of each plotcell.  The observed values on the two varibles are represented by points in the little scatterplot. Each point  represents the values for (usually) one observation on two variables.~2%") w)
(paste-plot-help (format nil 
"Normally distributed variables will have scatterplots which have the greatest density in the middle, are roughly eliptical in shape, and have no obvious outliers. ~2%") w)
(paste-plot-help  (format nil "The scatterplot matrix can be used as a control panel for selecting variables, pairs of variables and triples of variables. When you click on a plotcell, that pair of variables is selected. When you click on a diagonal cell, a single variable is selected. Shift-clicking will select up to three variables.~2%") w)
(paste-plot-help  (format nil "When you use the scatterplot matrix to select one, two or three variables, various changes will appear in some of the other plots. The specific changes depend on the nature of the SpreadPlot."))
(show-plot-help)
))


(defmeth NAME-LIST-PROTO :plot-help (&key (flush t)) 
  (let ((title (send self :title)))
    (plot-help-window (strcat "Help: " title)  :flush flush)
    (paste-plot-help (format nil "The ~s window is a Name List Window. It provides a window for displaying and interacting with lists of names. In many situations you can select items in this window and thereby select corresponding items in other windows. You can select items in this window by clicking on an item, by shift-clicking on several items, or by dragging your cursor over the items." title))
    (when (or (equal title "Vars") 
              (equal title "Var") 
              (equal title "Variables"))
          (paste-plot-help (format nil "This window lists variable names.")))
    (when (or (equal title "Obs") (equal title "Observations"))
          (paste-plot-help (format nil "This window lists observation labels.")))
    (when (or (equal self *obs-window*) (equal self *var-window*))
          (paste-plot-help (format nil "~2%The OBS and VARS windows can be used for creating subsets of your data. There are two steps in doing this:"))
          (paste-plot-help (format nil "~2%FIRST: Use the OBS and VARS windows to select the observations and variables that you want to be included in the subset. Note that the OBS and VARS menus help you with the selection process.")) 
          (paste-plot-help (format nil "~2%SECOND: Use the DATA menu's CREATE DATA menu item to create a new data object. The new data object will contain only those observations and variables that you selected in the OBS and VARS windows."))
          (paste-plot-help (format nil "~2%NOTE: Selected variables or observations are those that which appear in the windows (i.e., those that are not removed by the REMOVE menu item). If any of these are highlighted, then the selection is only the highlighted ones."))
          )
    (show-plot-help)))

(defun report-header-help (title)
  (plot-help-window title)
  (paste-plot-help (format nil "The report appears in the Listener window. If the Listener is not visible, use the WINDOW menu's LISTENER item to display it. You will then have to scroll up to the top of the report.~2%"))
  (paste-plot-help (format nil "Occasionally, the top portion of long reports will be lost, or the Listener will run out of memory and fail to finish printing the report. In these situations, ask for the report again. If the problem persists, try restarting ViSta and use the COMMAND menu's RECORD LISTENER item to record the report in a file. You can then use a text editor or word processor to view the report."))
  (show-plot-help))

(defmeth graph-window-proto :spreadplot-help (&key (flush t))
  (plot-help-window (strcat "SpreadPlot Help") :flush flush)
  (paste-plot-help (format nil 
"A SpreadPlot is a group of plot windows. Usually these windows are linked together and interact with each other. When you make a change in one of the plot windows, the linkages cause changes to appear in other plot windows. The details of the linkages determine which plots change, and how they change.~2%"))
(paste-plot-help (format nil 
"Generally, the plot windows are linked through corresponding observations and/or variables: For example, when you change the color of a point in one window, the  color of corresponding points in other windows may change as well.~2%"))
  (paste-plot-help (format nil 
"Sometimes the plot windows are linked through equations: When you change the position of a point in one window, then for a particular model, this may imply that some of the parameter estimates have been changed. These new parameter estimates are entered into the model and changes in the model are shown in other windows.~2%"))
  (paste-plot-help (format nil
"There are numerous SpreadPlots in ViSta. Each SpreadPlot has additional help that is taylored to the specific way in which it works. When you have a SpreadPlot showing, use the help menu to get help about that particular SpreadPlot."))
  (show-plot-help))

(defun welcome-message ()
  (let* ((w (display-window (format nil "~%WELCOME!~2%")
            :location '(100 100) :size '(475 280)
            :show nil
            :title "Welcome to ViSta - The Visual Statistics System")))
    (send w :has-v-scroll t)
    (send w :paste-string (format nil "ViSta, the Visual Statistics System, is ready to help you \"see what your data seem to say\"."))
    (send w :paste-string (format nil " But first, you may want to take time to personalize ViSta.~2%"))
    (send w :paste-string 
          (format nil "The COMMAND menu lets you change ViSta's colors~a window layout~a" 
                  (if *change-profiles* "," " and") 
                  (if *change-profiles* " and startup options (including whether you see this message)." ".")))
    #+msdos (when *change-profiles*
                  (send w :paste-string (format nil " You can also change the fonts and directories that ViSta uses.")))
    (when *change-profiles* 
          (send w :paste-string (format nil " Your changes are saved and will be in effect when you use ViSta again.")))
    (send w :paste-string (format nil "~2%COLORS:~%Use the CHANGE COLORS item of ViSta's COMMAND menu to change the colors of windows, of tool and button bars,  and of icons and graph elements. You can set the maximum number of colors to correspond with your hardware's capabilities. You can also turn all colors off, if you wish."))
    (send w :paste-string (format nil "~2%DESKTOP SIZE AND LAYOUT:~%Use the RESIZE DESKTOP item of ViSta's COMMAND menu to change the overall size of the desktop which is used for ViSta's WorkMap, Listener, Help, Observations and Variables windows. The windows are optimally shaped to fit within the area you specify. Initially, the entire desktop is used.~2%"))
    (when *change-profiles*
          (send w :paste-string (format nil "STARTUP OPTIONS:~%Use the STARTUP PREFERENCES item of ViSta's COMMAND menu to change the way that ViSta appears when it first starts running, including details about which windows initially appear, whether this message is presented, whether initial help is presented, whether you wish to have the option to run LispStat without ViSta, and whether you wish to see an initial dialog to open a datafile.~2%")))
   (when *configure*
         #+msdos(send w :paste-string (format nil "FONTS:~%Use the CONFIGURE item of ViSta's COMMAND menu to change fonts and font sizes. Initially, fonts and font sizes are set so that they are appropriate for most systems. However, they may not be appropriate for certain specific configurations.~2%"))
         #+msdos(send w :paste-string (format nil "DIRECTORIES:~%Use the CONFIGURE item of ViSta's COMMAND menu to change the directories in which ViSta expects to find its program, data and help files. Initially, these directories are expected to be found in subdirectories of the directory containing the ViSta executable.~2%"))
         (send w :paste-string (format nil "MENU ITEMS:~%Use the CONFIGURE item of ViSta's COMMAND menu to change the specific items which appear in the COMMAND menu. The menu may be set to be appropriate for use by~%  1: NETWORKED USERS by preventing their ability to change profiles and configurations.~%  2: INDIVIDUAL USERS by permitting profile changes, but preventing re-configuration.~%  3: ADVANCED INIDIVIDUAL USERS by permitting profile changes and re-configuration, but prohibiting authoring.~%  4: GUIDEMAP AUTHORS by permitting all options.~2%")))
    (when *author*
          (send w :paste-string (format nil "AUTHORING NEW GUIDEMAPS:~%Use the AUTHOR GUIDEMAPS item of ViSta's COMMAND menu to create new GuideMaps using ViSta's graphical interface. NOTE: This feature is for use by course designers. It is experimental and requires expert knowledge of ViSta and of the subject for which guidance is being created.")))
    (show-display-window w)
    ))