/*
 * Primitive.c -- Implementation of Scheme Primitives
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: Primitive.c,v 2.9 1994/11/12 22:17:24 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: Primitive.c,v 2.9 1994/11/12 22:17:24 blume Exp $")

# include <stdio.h>

# include "storext.h"
# include "Primitive.h"
# include "identifier.h"
# include "type.h"
# include "except.h"

/*
 * See file "builtins.tab" where each built-in function
 * is registered using entries of the form
 *      BUILTIN (name-of-function, name-string, arity, domain)
 * or
 *	BUILTIN_CONT (name-of-function, name-of-cont-func,
 *                    name-string, arity, domain)
 */

# include "builtins.tab"

enum {

# define BUILTIN_CONT(f,c,n,a,d) f ## _idx,
# define BUILTIN(f,n,a,d) f ## _idx,
# include "builtins.tab"
# undef BUILTIN
# undef BUILTIN_CONT

  N_PRIMITIVES
};

const unsigned ScmPrimitive_num = N_PRIMITIVES;

ScmPrimitive ScmPrimitive_array [] = {

# define BUILTIN_CONT(f,c,n,a,d) { ScmType (Primitive), \
				     f, c, f ## _idx, n, a },
# define BUILTIN(f,n,a,d) { ScmType (Primitive), \
			    f, NULL, f ## _idx, n, a },
# include "builtins.tab"
# undef BUILTIN
# undef BUILTIN_CONT

};

static void dumper (void *vprim, FILE *file)
{
  MEM_dump_ul ((ScmPrimitive *)vprim - ScmPrimitive_array, file);
}

static void *excavator (FILE *file)
{
  unsigned num;

  num = MEM_restore_ul (file);
  return (void *) (ScmPrimitive_array + num);
}

static void display (void *vprim, putc_proc pp, void *cd)
{
  ScmPrimitive *prim = vprim;

  putc_string ("#<Primitive ", pp, cd);
  putc_string (prim->name, pp, cd);
  (* pp) ('>', cd);
}

MEM_VECTOR (Primitive,
	    0, MEM_NULL_measure,
	    MEM_NULL_iterator, dumper, excavator, MEM_NULL_revisor,
	    MEM_NULL_task, MEM_NULL_task, MEM_NULL_task,
	    EXT (SCM_NO_NUMBER,
		 cannot_cvt_real, display, display, NULL_eq, NULL_eq));
