(define (error-functor names-mod show-mod)

  (module error-sig ()

    (use scheme-sig)
    (use names-mod names-sig)
    (use show-mod show-sig)

    (define error-type 'runtime)

    (define (reset-error-type!)
      (set! error-type 'runtime))

    (define (print x)
      (show (remove-wrappers x)))

    ;; message... alternating sequence of messages and data
    (define (message head . l)
      (with-output-to-port
	  (standard-port 2)
	(lambda ()
	  (define (loop l now then)
	    (if (pair? l)
		(begin
		  (now (car l))
		  (loop (cdr l) then now))))
	  (display head)
	  (loop l display print)
	  (newline))))

    ;; syntax error message:
    (define ((syntax-error fname) . l)
      (apply message (string-append fname ": ") l)
      (set! error-type 'syntax)
      (error "syntax error"))

    ;; semantic error message:
    (define ((semantic-error fname) . l)
      (apply message (string-append fname ": ") l)
      (set! error-type 'semantic)
      (error "semantic error"))

    ;; compiler bug:
    (define (bug . l)
      (apply message "compiler-bug: " l)
      (set! error-type 'compiler-bug)
      (error "compiler bug"))))
