(define (sa-functor lgi-mod error-mod)

  (module sa-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use lgi-mod lgi-sig)
    (use error-mod error-sig)

;;; Traverse output of macro-expander...
;;;
;;;  - eliminate local assignments (by introducing explicit reference cells)
;;;  - complain about all remaining ``definitions'' and ``transformer''
;;;    expressions
;;;
;;; dropped from the output language:
;;;
;;; definitions:...
;;; transformer:...
;;; set!:... (general case)
;;;
;;; new expression types in the output language: <type>:<body>
;;;
;;; global assignment:		set!:(<global> <expr>)
;;; make reference cell:	app:(integrable:ref <expr>)
;;; dereference:		app:(integrable:deref <expr>)
;;; assign through reference:	app:(integrable:assign <expr> <expr>)

    (define i-ref (integrable 'ref))
    (define i-deref (integrable 'deref))
    (define i-assign (integrable 'assign))

    (define (traverse exp fname)

      (define (trv exp)

	(define (rename l c)
	  (define (loop l n m)
	    (cond ((null? l) (c (reverse n) m))
		  ((local-update? (car l))
		   (let ((x (new-local (local-symbol (car l)))))
		     (loop (cdr l)
			   (cons x n)
			   (cons (list (car l)
				       (ee 'app (list i-ref x)))
				 m))))
		  (else (loop (cdr l) (cons (car l) n) m))))
	  (loop l '() '()))

	(case (ee-type exp)
	  ((quote global integrable) exp)
	  ((local)
	   (if (local-update? exp)
	       (ee 'app (list i-deref exp))
	       exp))
	  ((set!)
	   (let* ((body (ee-body exp))
		  (lhs (car body))
		  (rhs (trv (cadr body))))
	     (if (global? lhs)
		 (ee 'set! (list lhs rhs))
		 (ee 'app
		     (list i-assign lhs rhs)))))
	  ((if app)
	   (ee (ee-type exp) (map trv (ee-body exp))))
	  ((letrec)
	   (let ((body (ee-body exp)))
	     (ee 'letrec
		 (list (map (lambda (b)
			      (let ((v (car b))
				    (e (trv (cadr b))))
				(list v
				      (if (local-update? v)
					  (ee 'app (list i-ref e))
					  e))))
			    (car body))
		       (trv (cadr body))))))
	  ((lambda)
	   (let* ((body (ee-body exp))
		  (fname (car body))
		  (gsl (cadr body))
		  (e (trv (caddr body))))
	     (rename
	      gsl
	      (lambda (rgsl m)
		(if (null? m)
		    (ee 'lambda (list fname gsl e))
		    (ee 'lambda
			(list fname rgsl
			      (ee 'letrec (list m e)))))))))
	  ((vlambda)
	   (let* ((body (ee-body exp))
		  (fname (car body))
		  (ngsl (cadr body))
		  (rgs (caddr body))
		  (e (trv (cadddr body))))
	     (rename
	      (cons rgs ngsl)
	      (lambda (rgsl m)
		(if (null? m)
		    (ee 'vlambda (list fname ngsl rgs e))
		    (ee 'vlambda
			(list fname (cdr rgsl) (car rgsl)
			      (ee 'letrec (list m e)))))))))
	  ((delay)
	   (let* ((body (ee-body exp))
		  (fname (car body))
		  (tmp (traverse (cadr body) fname)))
	     (ee 'delay (list fname tmp))))
	  ((definitions)
	   ((syntax-error fname) "definition(s) in wrong context"))
	  ((transformer)
	   ((syntax-error fname) "macro transformer in wrong context"))
	  (else
	   (bug "(msam.traverse) unexpected expression type: "
		(ee-type exp)))))
    
      ;; body of traverse
      (trv exp))

    (define (sa exp)
      (traverse exp "[TOP]"))))
