(define (show-functor)

  (module show-sig ()

    (use system-sig)

    (define max-depth 3)
    (define max-length 10)
    (define too-deep "[...]")
    (define too-long "...")
    (define null-pointer "[NULL]")

    (define (show x)

      (define (item x d l)
	(cond ((negative? d)
	       (display too-deep)
	       (- l 1))
	      ((null-pointer? x)
	       (display null-pointer)
	       (- l 1))
	      ((pair? x)
	       (case (car x)
		 ((quote) (rmac "'" x d l))
		 ((quasiquote) (rmac "`" x d l))
		 ((unquote) (rmac "," x d l))
		 ((unquote-splicing) (rmac ",@" x d l))
		 (else
		  (display "(")
		  (seq x (- d 1) l))))
	      ((vector? x)
	       (display "#(")
	       (seq (vector->list x) (- d 1) l))
	      (else
	       (write x)
	       (- l 1))))

      (define (rmac s x d l)
	(if (and (pair? (cdr x))
		 (null? (cddr x)))
	    (begin
	      (display s)
	      (item (cadr x) d l))
	    (begin
	      (display "(")
	      (seq x (- d 1) l))))

      (define (seq x d l)
	(cond ((null? x)
	       (display ")")
	       (- l 1))
	      (else
	       (let ((l (item (car x) d l)))
		 (restlist (cdr x) d l)))))

      (define (restlist x d l)
	(cond ((null? x)
	       (display ")")
	       (- l 1))
	      ((not (pair? x))
	       (display " . ")
	       (item x d l))
	      ((negative? l)
	       (display " ")
	       (display too-long)
	       (display ")")
	       l)
	      (else
	       (display " ")
	       (let ((l (item (car x) d l)))
		 (restlist (cdr x) d l)))))

      (item x max-depth max-length))))
