/*
 * storext.h -- Declarations for the Scheme type extension hook
 *
 * (C) m.b (Matthias Blume); Apr 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: storext.h,v 2.6 1994/09/01 20:11:00 blume Exp $
 */

# ifndef STOREXT_H_
# define STOREXT_H_

/*
 * General Scheme stuff
 */

typedef
void   (* putc_proc) (int c, void *client_data);
typedef
void   (* write_proc) (void *obj, putc_proc pp, void *client_data);
typedef
int    (* equal_proc) (void *self, void *other);

/*
 * Stuff, needed for generic Scheme numbers
 */

enum number_category {
  SCM_NO_NUMBER,		/* everything that's not a number */
  SCM_SINTEGER,			/* small integers */
  SCM_INTEGER,			/* integers */
  SCM_FRACTION,			/* fractions */
  SCM_REAL,			/* reals */
  SCM_COMPLEX,			/* complex numbers */
  N_NUMBER_CATEGORIES		/* just to count them... */
};

# define BIN_PRED(op,txt) op,
enum binary_pred {
# include "numops.tab"
  N_BINARY_PREDS
};
# undef BIN_PRED

# define BIN_OP(op,txt) op,
enum binary_op {
# include "numops.tab"
  N_BINARY_OPS			/* count them */
};
# undef BIN_OP

# define U_PRED(op,txt) op,
enum unary_pred {
# include "numops.tab"
  N_UNARY_PREDS			/* count them */
};
# undef U_PRED

# define U_OP(op,txt) op,
enum unary_op {
# include "numops.tab"
  N_UNARY_OPS			/* count them */
};
# undef U_OP

typedef int (* binary_pred) (void *, void *, const char *);
typedef void *(* binary_op) (void *, void *, const char *);
typedef int (* unary_pred) (void *, const char *);
typedef void *(* unary_op) (void *, const char *);
typedef double (* to_real_proc) (void *);
typedef void (* qr_proc) (void *, void *, void **, void **, const char *);

# define NULL_eq ((equal_proc) 0)

typedef
struct SCM_extension {
  enum number_category  numcat;
  to_real_proc          to_real;
  write_proc		display;
  write_proc		write;
  equal_proc		equal;
  equal_proc		eqv;
} MEM_extension;

# define EXT(n,tr,d,w,eq,ev) { n, tr, d, w, eq, ev }

extern void display_object (void *obj, putc_proc pp, void *cd);
extern void write_object (void *obj, putc_proc pp, void *cd);
extern int equal_object (void *obj1, void *obj2);
extern int eqv_object (void *obj1, void *obj2);
extern void putc_string (const char *str, putc_proc pp, void *cd);

extern int ScmBinPred (enum binary_pred, void *, void *);
extern void *ScmBinOp (enum binary_op, void *, void *);
extern int ScmUPred (enum unary_pred, void *);
extern void *ScmUOp (enum unary_op, void *);
extern double ScmGetReal (void *);

/*
 * quotient, remainder, divide --
 * uses same dispatch mechanism but needs its own table because
 * its type
 */
extern void ScmQuotRem (void *, void *, void **, void **, const char *s);

extern double cannot_cvt_real (void *);

# endif
