/*
 * Copyright (c) 2004
 *      iMil <imil@gcu.info>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by iMil.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY iMil AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL iMil OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: sigsound.c,v 1.4 2004/07/13 11:51:17 imil Exp $
 */

#include "common.h"
#include <fcntl.h>
#include <sys/ioccom.h>
#ifdef __OpenBSD__
#include <soundcard.h>
#else
#include <sys/soundcard.h>
#endif
#include <math.h>

#ifdef __FreeBSD__
#define AUDIO_DEV "/dev/dsp"
#else
#define AUDIO_DEV "/dev/audio"

#endif
#define CHANNELS 1
#define RATE 11025
#define AUDIO_BITS 8

#define SOUND_SIZE 314 /* sounds familiar heh ? */

static int blocksize, audiodev;

void free_sound(void);
void get_audio_device(void);

void
get_audio_device()
{
	int channels = CHANNELS, bits = AUDIO_BITS, rate = RATE;

	audiodev = open(AUDIO_DEV, O_WRONLY);
	if (audiodev < 0) {
	        perror("Unable to open AUDIO DEV.\n");
		exit(1);
	}

	if (ioctl(audiodev, SOUND_PCM_WRITE_BITS, &bits) < 0)
		err(1, "SOUND_PCM_WRITE_BITS");
	if (ioctl(audiodev, SOUND_PCM_WRITE_CHANNELS, &channels) < 0)
		err(1, "SOUND_PCM_WRITE_CHANNELS");
	if (ioctl(audiodev, SOUND_PCM_WRITE_RATE, &rate) < 0)
		err(1, "SOUND_PCM_WRITE_RATE");
	if (ioctl(audiodev, SNDCTL_DSP_GETBLKSIZE, &blocksize) < 0)
		err(1, "SNDCTL_DSP_GETBLKSIZE");

}

void *
do_noise(void *blah)
{
	int i;
	float pow;
	extern int wi_signal;
	unsigned char sound[SOUND_SIZE];

	get_audio_device();

	while (1) {
		if (wi_signal < 0)
			free_sound();

		pow = 1.5;
		memset(sound, 0, SOUND_SIZE);
		/* 200 is to fill only partialy the sound so we have a 
		   sort of "effect" ;) */
		for(i = 0; i < (SOUND_SIZE - 200); i++) {
			/* 
			 * as I'm such a loser on maths, this formula comes 
			 * from various contributors, and among them 
			 * oliv3, aki and ic
			 */
			sound[i] = (unsigned char)
				(pow * 
				 (cos((sqrt(wi_signal)*(float)i/100)*4)));
		}

		write(audiodev, sound, SOUND_SIZE);
	}

	return (NULL);
}

void
free_sound()
{
	close(audiodev);

	pthread_exit(NULL);
}
