/*
 * Copyright (c) 2002 pancake <pancake@phreaker.net>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStumbler2 package.
 *
 * $Id: guiabout.c,v 1.0 2003/11/15 15:54:29 pancake Exp $
 */

#if USE_GTK
#ifndef PREFIX
#error PREFIX not defined
#endif

#include <gtk/gtk.h>
#include "guimenu.h"
#include "main.h"
#define ABOUT_MSG \
"WiStumbler2 (" VERSION ") - pancake <pancake@phreaker.net>\n\n"\
"Fork of the original WiStumbler for NetBSD coded by iseki.\n\n"\
"http://www.nopcode.org/?t=wistumbler2\n"

gboolean about_isopen=FALSE;

void wistumbler_gui_closeabout(void*v)
{
	about_isopen=FALSE;
}

void wistumbler_gui_about(parent)
	GtkWidget *parent;
{
	GtkWidget *w,*msg,*img,*ok;
	GtkWidget *hb,*vb;

	if (NO_X||about_isopen==TRUE) return;
	about_isopen=TRUE;

	w=gtk_window_new(GTK_WINDOW_TOPLEVEL); /* TODO parent */
	gtk_window_set_position(GTK_WINDOW(w), GTK_WIN_POS_CENTER);
	//	  gtk_widget_set_parent(w,parent);
	gtk_window_set_title(GTK_WINDOW(w), "About wistumbler2");
	gtk_window_set_resizable(GTK_WINDOW(w),FALSE);
	gtk_widget_set_usize(GTK_WIDGET(w), 500,150);
	gtk_signal_connect(GTK_OBJECT(w), "destroy",
			GTK_SIGNAL_FUNC(wistumbler_gui_closeabout), NULL);

	hb=gtk_hbox_new(FALSE,5);
	gtk_container_set_border_width(GTK_CONTAINER(hb), 5);
	gtk_container_add(GTK_CONTAINER(w),hb);

	/* TODO correct path */
	img=gtk_image_new_from_file(PREFIX "/share/wistumbler2/wist2.png");
	gtk_box_pack_start(GTK_BOX(hb),img,TRUE,TRUE,5);

	vb=gtk_vbox_new(FALSE,10);
	gtk_container_add(GTK_CONTAINER(hb),vb);

	msg=gtk_label_new(ABOUT_MSG);
	gtk_box_pack_start(GTK_BOX(vb),msg,TRUE,TRUE,5);

	ok=gtk_button_new_from_stock(GTK_STOCK_OK);
	gtk_box_pack_start(GTK_BOX(vb),ok,TRUE,TRUE,5);
	gtk_signal_connect_object(
			GTK_OBJECT(ok),"clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy),(gpointer)w);

	gtk_widget_show_all(w);
}
#endif
