/*
 * Copyright (c) 2004 pancake <pancake@phreaker.net>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStumbler2 package.
 *
 * $Id: guiconfig.c,v 1.0 2004/04/11 16:17:38 pancake Exp $
 */

#include "main.h"
#if USE_GTK
gboolean guiconfig_isopen=FALSE;

void wistumbler_gui_closeconfig(void* v)
{
	guiconfig_isopen=FALSE;
}

GtkWidget *usex_enable,
	  *signalmeter_enable,
	  *speaker_enable,
	  *speaker_delay,
	  *gps_device,
	  *gps_enable,
	  *wifi_device;

void guiconf_ok(void *v)
{
	char *entry;
	GtkWidget *wifi_label;

	// CHANGE VARIABLES //
	App.signalmeter=
		gtk_toggle_button_get_active(
		(GtkToggleButton*)signalmeter_enable);
	if (App.signalmeter)
		gtk_widget_show_all(popup_w);
	else    gtk_widget_hide_all(popup_w);

	Cfg.beep_delay=atoi(gtk_entry_get_text((GtkEntry*)speaker_delay));
	if (Cfg.beep_delay<1)Cfg.beep_delay=1;
	Cfg.beep_enable=
		gtk_toggle_button_get_active((GtkToggleButton*)speaker_enable);

	App.usex=gtk_toggle_button_get_active((GtkToggleButton*)usex_enable);

	Cfg.gps=gtk_toggle_button_get_active((GtkToggleButton*)gps_enable);
	Cfg.gpsdev=(gchar*)gtk_entry_get_text((GtkEntry *)gps_device);

	// iface //
	entry=(gchar*)gtk_entry_get_text((GtkEntry *)wifi_device);

	if (strcmp(Cfg.iface,entry)) {
		wi_finish(Cfg.iface);
		Cfg.iface=entry;

		if ( wi_init(entry) < 0 ) {
			dev_init();
			App.working=0;
		} else {
			App.working=1;
		}
	}
	gtk_label_set_text(GTK_LABEL(wifi_label),Cfg.iface);

	// SAVE CHANGES //
	if (! user_conf_save() )
		return;

	// RELOAD CHANGES //
	user_conf_load(true);

	gtk_widget_destroy(v);
}

/*
   void
   clearlogs_callback(void*v)
   {
   if (!gui_init)return;
   if (logbody) free(logbody);
   logbody=0;
   gtk_label_set_text(msg_label,"");
   truncate(logsfile,0);
   viewlogs_height=VIEWLOGS_HEIGHT;
   }
 */

void wistumbler_gui_config()
{
	GtkWidget   *w,
		    *nb,*fr1,*fr2,*fr3,*fr4,*fr5,/* tabs */
		    *label, /* labels */
		    *vbox,*hbox,*hbbox, /* boxes */
		    *ok,*cancel; /* buttons */
	char cfgfile[1024];
	char buf[1024]; // default buffer for temp operations

	if (NO_X||guiconfig_isopen) {
		gtk_entry_set_text(GTK_ENTRY(wifi_device),Cfg.iface);
		gtk_entry_set_text(GTK_ENTRY(gps_device),Cfg.gpsdev);
		return;
	}
	guiconfig_isopen=TRUE;

	w=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(w), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(w), "Wistumbler2 Preferences");
	gtk_widget_set_usize(GTK_WIDGET(w), 450,300);
	gtk_container_set_border_width(GTK_CONTAINER(w),5);
	gtk_signal_connect(GTK_OBJECT(w), "destroy",
			GTK_SIGNAL_FUNC(wistumbler_gui_closeconfig), NULL);

	/* Parent box */
	vbox=gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(w),vbox);

	/* TOP buttonbox (label, etc) */
	hbox=gtk_hbutton_box_new();
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox),GTK_BUTTONBOX_SPREAD);

	strcpy(cfgfile,"Configuration file is at '");
	strcat(cfgfile,getenv("HOME"));
	strcat(cfgfile,"/");
	strcat(cfgfile,DEFAULT_CFGFILE);
	strcat(cfgfile,"'");
	label=gtk_label_new(cfgfile);
	gtk_container_add(GTK_CONTAINER(hbox),label);

	nb=gtk_notebook_new();
	/* Stumbler Tab (fr1) */
	fr1=gtk_frame_new("Main configuration");
	{
		GtkWidget *vbox;
		GtkWidget 
			*speaker_delay_hbox,
			*speaker_delay_label;

		vbox=gtk_vbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(vbox),GTK_BUTTONBOX_START);
		gtk_container_set_border_width(GTK_CONTAINER(fr1),5);

		usex_enable=gtk_check_button_new_with_label("Use graphical mode");
		if (App.usex)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(usex_enable),true);
		gtk_box_pack_start(GTK_BOX(vbox),usex_enable,false,false,0);

		speaker_enable=gtk_check_button_new_with_label("Enable speaker");
		if (Cfg.beep_enable)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(speaker_enable),true);
		gtk_box_pack_start(GTK_BOX(vbox),speaker_enable,false,false,0);

		speaker_delay_hbox=gtk_hbox_new(0,5);
		speaker_delay_label=gtk_label_new("Speaker delay time");
		gtk_box_pack_start(GTK_BOX(speaker_delay_hbox),
				speaker_delay_label,false,false,0);
		speaker_delay=gtk_entry_new();
		sprintf(buf,"%d",Cfg.beep_delay);
		gtk_entry_set_text(GTK_ENTRY(speaker_delay),buf);
		gtk_entry_set_max_length(GTK_ENTRY(speaker_delay),3);
		gtk_entry_set_width_chars(GTK_ENTRY(speaker_delay),5);
		gtk_box_pack_start(GTK_BOX(speaker_delay_hbox),
				speaker_delay,false,false,0);
		gtk_container_add(GTK_CONTAINER(vbox),speaker_delay_hbox);
		//printf("ENTRY(%s)\n",gtk_entry_get_text(speaker_delay));

		signalmeter_enable=gtk_check_button_new_with_label("Floating signal-meter");
		if (App.signalmeter)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(signalmeter_enable),true);
		gtk_box_pack_start(GTK_BOX(vbox),signalmeter_enable,false,false,0);

		/* pack'm'all */
		gtk_container_add(GTK_CONTAINER(fr1),vbox);

		/* pack into notebook */
		gtk_notebook_append_page(
				GTK_NOTEBOOK(nb),
				GTK_WIDGET(fr1),
				gtk_label_new("Stumbler"));
	}

	/* WiFi Tab (fr2) */
	{
		GtkWidget *vbox,*hbox,*label;
		vbox=gtk_vbutton_box_new();

		fr2=gtk_frame_new("Wireless options");
		gtk_container_set_border_width(GTK_CONTAINER(fr2),5);
		//gtk_container_add(GTK_CONTAINER(fr2),

		gtk_button_box_set_layout(GTK_BUTTON_BOX(vbox),GTK_BUTTONBOX_START);
		gtk_container_set_border_width(GTK_CONTAINER(fr2),5);
		hbox=gtk_hbox_new(0,5);
		label=gtk_label_new("Interface");
		gtk_widget_set_usize(label,60,20);
		gtk_box_pack_start_defaults(GTK_BOX(hbox),label);
		wifi_device=gtk_entry_new();
		//printf("==> %s\n",Cfg.iface);
		gtk_entry_set_text(GTK_ENTRY(wifi_device),Cfg.iface);
		gtk_box_pack_start(GTK_BOX(hbox),
				wifi_device,false,false,0);
		gtk_container_add(GTK_CONTAINER(vbox),hbox);

		gtk_container_add(GTK_CONTAINER(fr2),vbox);
		gtk_notebook_append_page(
				GTK_NOTEBOOK(nb),
				GTK_WIDGET(fr2),
				gtk_label_new("Wireless"));
	}

	/* Logs Tab (fr3) */
	fr3=gtk_frame_new("Logging parameters");
	gtk_container_set_border_width(GTK_CONTAINER(fr3),5);
	gtk_container_add(GTK_CONTAINER(fr3),
			gtk_label_new("(TODO)"));
	gtk_notebook_append_page(
			GTK_NOTEBOOK(nb),
			GTK_WIDGET(fr3),
			gtk_label_new("Logs"));

	/* Sniff Tab (fr4) */
	fr4=gtk_frame_new("Sniffer");
	{
		GtkWidget *vbox,*sniff_enable;
		gtk_container_set_border_width(GTK_CONTAINER(fr4),5);

		vbox=gtk_vbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(vbox),GTK_BUTTONBOX_START);
		gtk_container_set_border_width(GTK_CONTAINER(fr4),5);

		sniff_enable=gtk_check_button_new_with_label("Passive sniffer");
		if (Cfg.sniff)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sniff_enable),true);
		gtk_box_pack_start(GTK_BOX(vbox),sniff_enable,false,false,0);

		gtk_container_add(GTK_CONTAINER(fr4),vbox);
		gtk_notebook_append_page(
				GTK_NOTEBOOK(nb),
				GTK_WIDGET(fr4),
				gtk_label_new("Sniffer"));
	}

	/* GPS Tab (fr5) */
	fr5=gtk_frame_new("GPS");
	{
		GtkWidget *vbox,*hbox,*label;
		vbox=gtk_vbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(vbox),GTK_BUTTONBOX_START);
		gtk_container_set_border_width(GTK_CONTAINER(fr5),5);
		gps_enable=gtk_check_button_new_with_label("Enable GPS");
		if (Cfg.gps)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gps_enable),true);
		gtk_box_pack_start_defaults(GTK_BOX(vbox),gps_enable);
		hbox=gtk_hbox_new(0,5);
		label=gtk_label_new("GPS device");
		gtk_widget_set_usize(label,60,20);
		gtk_box_pack_start_defaults(GTK_BOX(hbox),label);
		gps_device=gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(gps_device),Cfg.gpsdev);
		gtk_box_pack_start(GTK_BOX(hbox),
				gps_device,false,false,0);
		gtk_container_add(GTK_CONTAINER(vbox),hbox);

		gtk_container_add(GTK_CONTAINER(fr5),vbox);

		gtk_notebook_append_page(
				GTK_NOTEBOOK(nb),
				GTK_WIDGET(fr5),
				gtk_label_new("GPS"));
	}
	/* put noteboook into vbox */
	gtk_container_add(GTK_CONTAINER(vbox),nb);

	/* Buttons */
	hbbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbbox),GTK_BUTTONBOX_END);
	gtk_box_pack_start(GTK_BOX(vbox),hbbox,FALSE,FALSE,5);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbbox), 5);

	cancel=gtk_button_new_from_stock(GTK_STOCK_CANCEL);
	gtk_container_add(GTK_CONTAINER(hbbox),cancel);
	gtk_signal_connect_object(GTK_OBJECT(cancel),"clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy),(gpointer)w);

	ok=gtk_button_new_from_stock(GTK_STOCK_OK);
	gtk_container_add(GTK_CONTAINER(hbbox),ok);
	gtk_signal_connect_object(GTK_OBJECT(ok),"clicked",
			GTK_SIGNAL_FUNC(guiconf_ok),(gpointer)w);

	gtk_widget_show_all(w);

}
#endif
