/*
 * Copyright (c) 2003 pancake <pancake@phreaker.net>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStumbler2 package.
 *
 * $Id: guiviewlog.c,v 1.0 2003/11/29 15:54:29 pancake Exp $
 */

#include "main.h"
#if USE_GTK

#include "guimenu.h"
#define VIEWLOGS_HEIGHT 200

gboolean viewlogs_isopen=FALSE;
char *logbody=0;
GtkWidget *msg_label=0;
int viewlogs_height=VIEWLOGS_HEIGHT;

void wistumbler_gui_closeviewlogs(void*v)
{
	viewlogs_isopen=FALSE;
	if (logbody) free(logbody);
}

void clearlogs_callback(void*v)
{
	if (!App.gui_init)return;
	if (logbody) free(logbody);
	logbody=0;
	gtk_label_set_text(GTK_LABEL(msg_label),"");
	truncate(Cfg.logsfile,0);
	viewlogs_height=VIEWLOGS_HEIGHT;
}

void wistumbler_gui_viewlogs()
{
	GtkWidget *w,*msg_logs,*vbox,*hbox,
		  *clear_button,*ok_button,
		  *msg_text;
	GtkTextBuffer *buffer;
	FILE *fd;
	long size;

	if (NO_X||viewlogs_isopen) return;
	viewlogs_isopen=TRUE;

	fd = fopen(Cfg.logsfile,"r");
	if ( fd )
	{
		fseek( fd,0,SEEK_END );
		size = ftell(fd);
		if ( size>2048 )
		{
			logbody=strdup("logs too big");
		} else {
			fseek(fd,0,SEEK_SET);
			logbody=(char *)malloc(size+1);
			fread(logbody,size,1,fd);
			logbody[size]=0;
			viewlogs_height=VIEWLOGS_HEIGHT+(int)(size/8);
		}
		fclose(fd);
	} else {
		logbody = strdup("logfile not found");
	}

	w = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position (GTK_WINDOW(w), GTK_WIN_POS_CENTER);
	gtk_container_set_border_width (GTK_CONTAINER(w),5);
	gtk_window_set_title (GTK_WINDOW(w), "View Logs");
	gtk_widget_set_usize (GTK_WIDGET(w), 450,viewlogs_height);
	gtk_signal_connect (GTK_OBJECT(w), "destroy",
		GTK_SIGNAL_FUNC(wistumbler_gui_closeviewlogs), NULL);

	vbox=gtk_vbox_new(FALSE,5);
	//gtk_container_set_border_width(GTK_CONTAINER(w),5);
	gtk_container_add(GTK_CONTAINER(w),vbox);

	msg_logs=gtk_frame_new("Logs");
	gtk_container_set_border_width(GTK_CONTAINER(msg_logs),5);
	gtk_box_pack_start(GTK_BOX(vbox),msg_logs,TRUE,TRUE,5);

	buffer=gtk_text_buffer_new(0);
	gtk_text_buffer_set_text(GTK_TEXT_BUFFER(buffer),logbody,strlen(logbody));
	msg_text=gtk_text_view_new_with_buffer(GTK_TEXT_BUFFER(buffer));
	//msg_label=gtk_label_new(logbody);
	//  gtk_container_add(GTK_CONTAINER(msg_logs),msg_label);
	gtk_container_add(GTK_CONTAINER(msg_logs),msg_text);

	hbox=gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);

	clear_button=gtk_button_new_from_stock(GTK_STOCK_CLEAR);
	gtk_signal_connect(
		GTK_OBJECT(clear_button),"clicked",
		GTK_SIGNAL_FUNC(clearlogs_callback),(gpointer)NULL);
	gtk_container_add(GTK_CONTAINER(hbox),clear_button);

	ok_button=gtk_button_new_from_stock(GTK_STOCK_OK);
	gtk_container_add(GTK_CONTAINER(hbox),ok_button);

	//gtk_box_pack_start(GTK_BOX(vbox),ok_button,FALSE,TRUE,5);
	/* RESIZE , */
	gtk_signal_connect_object(GTK_OBJECT(ok_button),"clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy),(gpointer)w);
	//gtk_widget_set_usize(GTK_WIDGET(ok_button), 100, 50);

	gtk_widget_show_all(w);
}
#endif
