/*
 * 2004/02/01 - Copylefted by pancake@phreaker.net
 */

#ifdef USE_PCAP
#include "main.h"
#include <pcap.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#if __FreeBSD__
#include <net/ethernet.h>
#else
#include <net/route.h>
#include <net/if.h>
#if __OpenBSD__
#else
#include <net/if_ether.h>
#endif
#endif
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netinet/ip.h>
#define BUFSIZE 65540

/* [ethernet][ip][tcp][payload] */
void dissect(char *user,struct pcap_pkthdr *hdr,u_char *pkt)
{
	struct ip *iph;
	struct ether_header *eth;
	struct in_addr_t *ips;
	unsigned char *ptr;
	eth=(struct ether_header*)(pkt);
	iph=(struct ip*)(pkt+sizeof(struct ether_header));


	printf("#");
	fflush(stdout);
	if (ntohs(eth->ether_type)==ETHERTYPE_IP)
	{

		//ips=ntohl(iph->ip_src.s_addr);
		ptr=(unsigned char*)&iph->ip_src.s_addr;
		//printf("\nFROM(%s)\n",inet_ntoa(iph->ip_src.s_addr));
		//printf("IP4: FROM: %d.%d.%d.%d ",ptr[0],ptr[1],ptr[2],ptr[3]);
		printf("#");
		fflush(stdout);

		ptr=(unsigned char*)&iph->ip_dst.s_addr;
		if (ptr[0]!=192 && ptr[0]!=127 && ptr[0]!=10 && ptr[0]!=172 && ptr[0]!=224 && ptr[0]!=0 && ptr[0]!=255 && ptr[0]!=239)
		{
			//		printf("<<<<<<<<<<<<<<<<");
			//printf("\n");
			printf("IP4: TO : %d.%d.%d.%d ",ptr[0],ptr[1],ptr[2],ptr[3]);

			printf("SHOULDBEBSSID[%2x:%2x:%2x:%2x:%2x:%2x] \n",
					eth->ether_dhost[0],
					eth->ether_dhost[1],
					eth->ether_dhost[2],
					eth->ether_dhost[3],
					eth->ether_dhost[4],
					eth->ether_dhost[5]);
		}
	}
	//printf("TTL: %d FROM[%x:%x:%x:%x:%x:%x]\n",(unsigned char)IP->ip_ttl);
	//printf("ETHER_TYPE: %d\n",(short)eh->ether_type);
	//	printf("[%x] ",hdr->len);
#if 0
	switch(pkt[14])
	{
		case 0x45: printf("eth "); break;
		case 0x00: printf("arp "); break;
	}
	switch(pkt[17])
	{
		case 0x54: printf("icmp "); break;
	}
	printf("\t");
	for(i=14;i<30;i++)
		printf("%0.2x",(unsigned char )pkt[i]);
	printf("\n");
#endif
}

	void 
wistumbler_sniff()
{
	pcap_handler callback=(pcap_handler)&dissect;
	//int datalink=0;
	//struct bpf_program filter;
	//char *filter_app="";
	pcap_t *pd; /* like fd but for pcap :) */
	bpf_u_int32 net,mask;
	struct pcap_pkthdr header;
	const u_char *packet;
	char errbuf[PCAP_ERRBUF_SIZE];
	errbuf[0]=0;

	//dev=pcap_lookupdev(errbuf);
	//printf("errbuf: %s\n",errbuf);
	if (Cfg.iface==NULL)
		return;

	pd=pcap_open_live(Cfg.iface,BUFSIZE,1,69,errbuf);
	if (!pd)
	{
		printf("NOT PERMS TO SNIFF\n");
		return;
	}
	printf("Sniffer is ON\n");
#ifdef HAVE_PCAP_SET_DATALINK
	pcap_set_datalink(pd,0);
#endif
	//datalink=pcap_datalink(pd);
	pcap_lookupnet(Cfg.iface,&net,&mask,errbuf);
	/* set filter rules */
	//pcap_compile(pd,&filter,filter_app,0,net);
	//pcap_setfilter(pd,&filter);
	pcap_loop(pd,-1,callback,NULL);

	/* EXECUTION STOPS HERE : XXX : this code isn't used */
	while(1)
	{
		packet=pcap_next(pd,&header);
		if (!packet) continue;
		printf("[*] %d\n",header.len);
		write(2,packet,header.len);
		printf("--\n");
	}
	pcap_close(pd);
}

#endif

pthread_t th_sniffer=0;

void sniffer_start()
{
#if USE_PCAP
	pthread_create
	(
		&th_sniffer,
		NULL,
		(void *)wistumbler_sniff,
		(void *)0
	);
#endif
}

void sniffer_stop()
{
#if USE_PCAP
	pthread_join(th_sniffer,NULL);	
#endif
}
