/*
 * Copyright (c) 2002 Isao SEKI <iseki@gongon.com>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStumbler package.
 *
 * $Id: stumbler.c,v 1.4 2002/08/11 14:18:51 iseki Exp $
 * $Id: stumbler.c,v 1.5 2003/11/14 15:54:29 pancake Exp $
 */

#include <sys/types.h>
#include <sys/cdefs.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h> 
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <stdio.h>
#include <string.h> 
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h> 
#include <errno.h>
#include <err.h>
#include <time.h>
#include <signal.h>
#if USE_GTK
#include <gtk/gtk.h>
#include "guimenu.h"
GtkWidget *wifi_pb;
GtkWidget *popup_w=0; // window
GtkWidget *popup_pb=0; // pgb
#endif
#include "stumbler.h"
#include "gpscontrol.h"
#include "speaker.h"
#include "main.h"

struct access_point *access_points[MAX_APS];

#if USE_GTK
GtkWidget *wifi_label;
#endif

void window_setup()
{
#if USE_GTK

	gchar *titles[12] =
	{
		"", "SSID", "BSSID", "Channel", "Signal", "Interval",
		"Capinfo", "First", "Last", "Rate", "Position"
	};
	GtkWidget *vbox, *hbbox, *quit_button, *save_button, *scrolled_win;
	GtkWidget *hbox;
	GtkWidget *vsb;

	if (!App.usex) return;

	/* Popup signal-meter */
	popup_w=gtk_window_new(GTK_WINDOW_POPUP);
	popup_pb=gtk_progress_bar_new();
	gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(popup_pb),
			GTK_ORIENTATION_VERTICAL);
	gtk_container_add(GTK_CONTAINER(popup_w),popup_pb);

	if (App.signalmeter)
	{
		gtk_widget_show_all(popup_w);
	}

	/* Main window */
	App.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(App.window), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW (App.window), "wistumbler2");
	gtk_widget_set_usize(GTK_WIDGET(App.window),750,200);
	gtk_signal_connect(GTK_OBJECT(App.window), "destroy",
			GTK_SIGNAL_FUNC(wi_exit),NULL);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_container_add(GTK_CONTAINER(App.window), vbox);

	/* create MenuBar */
	wistumbler_gui_menu (App.window,vbox);

	/* create scrolled window */
	scrolled_win = gtk_scrolled_window_new(
		(GtkAdjustment*)gtk_adjustment_new(0,0,100,1,10,10),
		(GtkAdjustment*)gtk_adjustment_new(0,0,100,1,10,10)
		);
	gtk_container_set_border_width(GTK_CONTAINER(scrolled_win), 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(GTK_WIDGET(scrolled_win), 600, 100);
	gtk_box_pack_start(GTK_BOX (vbox), scrolled_win, TRUE, TRUE, 0);

	/* create GtkCList */
	App.clist = gtk_clist_new_with_titles(11, titles);
	gtk_clist_column_titles_passive((GtkCList *)App.clist);
	gtk_clist_set_column_width (GTK_CLIST(App.clist), 0, 10);  /* receive */
	gtk_clist_set_column_width (GTK_CLIST(App.clist), 1, 200); /* name */
	gtk_clist_set_column_width (GTK_CLIST(App.clist), 2, 200); /* BSSID */
	gtk_clist_set_column_width (GTK_CLIST(App.clist), 3, 30);  /* channel */
	gtk_clist_set_column_width (GTK_CLIST(App.clist), 4, 30);  /* signal */
	gtk_clist_set_column_width (GTK_CLIST(App.clist), 5, 60);  /* interval */
	gtk_clist_set_column_width (GTK_CLIST(App.clist), 7, 60);  /* First */
	gtk_clist_set_column_width (GTK_CLIST(App.clist), 8, 60);  /* last */
	gtk_clist_set_column_width (GTK_CLIST(App.clist), 9, 35);  /* rate */
	gtk_clist_set_column_width (GTK_CLIST(App.clist), 10, 100);/* position */
	gtk_container_add(GTK_CONTAINER(scrolled_win), App.clist);

	/* create Save &  Quit button */
	hbbox = gtk_hbutton_box_new();
	gtk_box_pack_start(GTK_BOX(vbox), hbbox, FALSE, FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(hbbox), 5);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbbox), 5);

	/* Horitzontal Box for !button widgets */
	hbox = gtk_hbutton_box_new();
	gtk_widget_show(hbox);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_START);
	gtk_container_add(GTK_CONTAINER(hbbox),hbox);

	/* WIFI PROGRESSBAR SIGNAL */
	wifi_pb = gtk_progress_bar_new();
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(wifi_pb),0);
	gtk_widget_set_usize(wifi_pb,100,10);
	gtk_container_add(GTK_CONTAINER(hbbox),wifi_pb);
	/* WIFI LABEL */
	wifi_label = gtk_label_new(Cfg.iface);
	gtk_container_add(GTK_CONTAINER(hbbox), wifi_label);
	/* SAVE BUTTON */
	save_button = gtk_button_new_from_stock(GTK_STOCK_SAVE);
	gtk_signal_connect_object(GTK_OBJECT(save_button), "clicked",
			GTK_SIGNAL_FUNC(print_clist),(gpointer)1);
	gtk_container_add(GTK_CONTAINER(hbbox), save_button);
	/* QUIT BUTTON */
	quit_button = gtk_button_new_from_stock(GTK_STOCK_QUIT);
	gtk_signal_connect_object(GTK_OBJECT(quit_button), "clicked",
			GTK_SIGNAL_FUNC(wi_exit), (gpointer)0);
	gtk_container_add(GTK_CONTAINER(hbbox), quit_button);

	/* Show All! */
	gtk_widget_show_all(App.window); 

	// MUTEX It
	App.gui_init=1;
#endif
}

void print_clist(int save)
{
	int i, j, k;
	int naps; // Number of APs found.
	float rate;
	struct tm *tm;
	struct access_point *aps;
	/* TODO VERY UGLY CODE (original one) */
	char receive[2], name[33], bssid[18], channel[3], signal[4], interval[6],
	     capinfo[4], first[6], last[6], speed[4], position[32], kismet[256];
	char *line[12] = {receive, name, bssid, channel, signal, interval, capinfo,
		first, last, speed, position};
	int maxsignal=0; /* for beep purposes */
	struct time_t *tmt;
	FILE *fd=NULL;

	if (save)
	{
		fd = fopen (Cfg.logsfile,"a");
		if (!fd) 
		{
			fprintf(stderr,"Cannot append logs to %s.\n",Cfg.logsfile);
			return;
		}

		/* Print date of log snapshot */
		tmt=(struct time_t*)time(0);
		fprintf(fd,"--[ %s",(char *) ctime((const time_t*)&tmt)); /* \n */
		return;
	}

	/* clear AP list */	
#if USE_GTK
	if (App.usex)
	{
		if (!App.gui_init) return;
		gtk_clist_clear((GtkCList *)App.clist);
	} else {
#endif
		printf("\e[2J"); /* clear screen */
		fflush(stdout);
#if USE_GTK
	}
#endif

	/* print APs */

	/* TODO This is heavy UGLY */
	naps=0; // Zero Naps
	for (i=0; i < MAX_APS; i++) 
	{
		if (access_points[i] == NULL)
			continue;
		naps++; // One AP found
		aps = access_points[i];

		/* for 1st column, receive status */
		if (aps->cur_receive == 0) 
			receive[0] = ' ', receive[1] = '\0';
		else
			receive[0] = 'o', receive[1] = '\0';

		strncpy(name,aps->wi_apinfo.name,aps->wi_apinfo.namelen);
		name[aps->wi_apinfo.namelen]='\0';

		sprintf(bssid, "%02x:%02x:%02x:%02x:%02x:%02x",
			aps->wi_apinfo.bssid[0]&0xff, aps->wi_apinfo.bssid[1]&0xff,
			aps->wi_apinfo.bssid[2]&0xff, aps->wi_apinfo.bssid[3]&0xff,
			aps->wi_apinfo.bssid[4]&0xff, aps->wi_apinfo.bssid[5]&0xff);

		snprintf(channel,  sizeof channel, "%d", aps->wi_apinfo.channel);
		snprintf(signal,   sizeof signal, "%d", aps->wi_apinfo.signal);
		snprintf(interval, sizeof interval, "%d", aps->wi_apinfo.interval);

		if (aps->cur_receive)	// only analize current ones.
		{
			if (aps->wi_apinfo.signal>maxsignal)
				maxsignal=aps->wi_apinfo.signal;
		}

		// THIS IS NETBSD SPECIFIC!!! XXX
		if (aps->wi_apinfo.capinfo & IEEE80211_CAPINFO_PRIVACY)
			strcpy(capinfo, "WEP");
		else if (aps->wi_apinfo.capinfo & IEEE80211_CAPINFO_ESS)
			strcpy(capinfo, "ESS");
		else if (aps->wi_apinfo.capinfo & IEEE80211_CAPINFO_IBSS)
			strcpy(capinfo, "IBSS");
		else
			strcpy(capinfo, "UNK"); // UNK instead of \0

		tm = localtime((const time_t *)&aps->first);
		sprintf(first, "%2.2d:%2.2d", tm->tm_hour, tm->tm_min);
		tm = localtime((const time_t *)&aps->last);
		sprintf(last, "%2.2d:%2.2d", tm->tm_hour, tm->tm_min);

		rate=(float)aps->wi_apinfo.rate;
		//printf("RATE IS : %f - %d\n",aps->wi_apinfo.rate,rate);

		#if 0
		switch (rate)
		{
			case WI_APRATE_1:
				rate = 1;
				break;
			case WI_APRATE_2:
				rate = 2;
				break;
			case WI_APRATE_5:
				rate = 5.5;
				break;
			case WI_APRATE_11:
				rate = 11;
				break;
			case WI_APRATE_0:
			default:
				rate = 0;
				break;
		}
		#endif
		if (rate)
			snprintf(speed, sizeof speed, "%g", rate);
		else
			sprintf(speed,"--");

		if (Cfg.gps == true)
			snprintf(position, sizeof position, "%f%c/%f%c",
					aps->dir.Ndeg, aps->dir.N, aps->dir.Edeg, aps->dir.E);
		else position[0] = '\0';

		// fprintf(fd,"%s %s ch:%s sig:%s int:%s %s %s-%s spd:%s\n",
		//	name,bssid,channel,signal,interval,capinfo,first,last,speed);
		//XXXXX WHAT HAPPENDS WITH SAVE !??!
		if (!App.usex||save)
		{
			printf("[%c] \"%s\"\n\t%s ch:%s sig:%s int:%s %s %s-%s spd:%s pos:%s\n",receive[0],
				name,bssid,channel,signal,interval,capinfo,first,last,speed,position);
		}

		if(App.kismet && App.kismetsock > 0)
		{
			k = snprintf(kismet, 256,
				"*NETWORK: %s %d \001"
				"%s"
				"\001 %s %d  %f"
				" %f %f %f\n", bssid, 0, name,
				channel, capinfo[0] == 'W' ? 1 : 0,
				aps->dir.Ndeg, aps->dir.Edeg, aps->dir.Ndeg,
				aps->dir.Edeg);

			if(write(App.kismetsock, kismet, k) < 0)
				App.kismetsock = -1;
		}
#if USE_GTK
		if (App.usex&&!save)
			gtk_clist_append((GtkCList *)App.clist, line);
#else
			printf("[%c] \"%s\"\n\t%s ch:%s sig:%s int:%s %s %s-%s spd:%s pos:%s\n",receive[0],
				name,bssid,channel,signal,interval,capinfo,first,last,speed,position);
#endif
	}

	if (naps==0&&!App.usex)
		printf("( no APs found )\n");

	/* DoBeep! */
	if (naps&&!save)
		do_beep(maxsignal);
}

int
gui_polling(int x)
{
	print_clist(0);
	return TRUE;
}

int wi_polling()
{
	gps_read();

	if (App.init)
	{
		/* no wifi ifaces found */
		if (Cfg.iface == NULL )
		{
			wistumbler_gui_error("No wifi devices found");
			//if (!App.usex) App.working=false;
			if (!App.usex) return false;
		} else {
			if (wi_apscan(Cfg.iface) == -1) 
			{
				wistumbler_gui_error("This is not a valid interface");
				App.with_iface = false;
			} else {
				if (App.with_iface == false)
				{
				wi_init(Cfg.iface);
				wistumbler_gui_error("Wireless network interface inserted");
				App.with_iface = true;
				}
			}

			if (App.debug) print_aps(stdout);
			if (!App.usex) print_clist(0); // not in this thread
		}
	}
	return true;
}

void th_polling()
{
	while (!App.init) usleep(300);

	if (!App.usex&&!Cfg.iface) /* nowork */
		return;

	App.working=true;
	while(App.working)
	{
		wi_polling();
		sleep(Cfg.scan_delay);
	}
	pthread_exit(0);
}

void gui_pollin(int x)
{
}

int wi_exit(int code)
{
	FILE *fd;
#if USE_GTK
	if (App.usex)
	gtk_main_quit();
#endif
	printf("WiFinish..\n");
	wi_finish(Cfg.iface);		/* power down the card , if needed */
	gps_close();

	if (Cfg.logsfile == NULL)
		exit(code);

	if ((fd = fopen(Cfg.logsfile, "a")) == NULL)
	{
		perror("fopen");
		exit(1);
	} else {
		printf("Writing log ...\n\n");
		print_aps(fd);
		fclose(fd);
		exit(code);
	}
}

static void cleanup(dummy)
	int dummy;
{
	wi_exit(0);
}


void dev_init()
{
	/* Init devices (wifi/gps) */
	if (Cfg.iface == NULL)
		Cfg.iface=autoget_wifi();
	if (Cfg.iface == NULL)
	{
#if USE_GTK
		wistumbler_gui_error("No wifi devices found.");
#else
		printf("No wifi devices found.\n");
#endif
		wi_exit(1);
	}
	signal(SIGINT, cleanup);
	signal(SIGQUIT, cleanup);
	signal(SIGHUP, cleanup);
	signal(SIGTERM, cleanup);

	if (Cfg.iface)
	{
		if (wi_init(Cfg.iface) < 0)  /* power on the card, if down */
		{
			if(App.usex) wistumbler_gui_error("Error initializiing wifi");
			else printf("Error initilizing wifi\n");
			App.working=0;
		}

		if (Cfg.gps)
			if (gps_open(Cfg.gpsdev) <= 0)
			{
				if (App.usex) wistumbler_gui_error("Error initializing gpsdev");
				else  printf("GPS ERROR\n");
				//exit(1);
			}
		App.init=1;
	}
}


