/**********************************************************************************

WMZCalock v0.1

	- A multi-format, themeable-ish calendar/clock dockapp for Window Maker


Bits and pieces, altered or whole, taken from the following GPL code:

	mount.app by Steve Borho <steve@borho.myip.org>

	wmCalClock by Mike Henderson <mghenderson@lanl.gov>

	wmsysmon by Dave Clark <clarkd@skynet.ca>
	            Vito Caputo <swivel@gnugeneration.com>

	wmgeneral (orig. from wmppp) by Martijn Pieterse <pieterse@xs4all.nl>

All else copyright (c) 2000 Lyle Zapato <lyle@zapatopi.net>
and released with no warranty under the GNU General Public License (see COPYING)

***********************************************************************************
                                Another fine product of
         Z a p a t o  P r o d u c t i o n s  I n t r a d i m e n s i o n a l
                                  http://zapatopi.net

***********************************************************************************/

/** set your tabs to 8 for viewing pleasure **/

#define NAME	"WMZCalock"
#define VERSION "0.1"

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <math.h>
#include <stdarg.h>
#include <locale.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "main.xpm"

#define FALSE	0
#define TRUE	1

#define M_24	0
#define M_12	1
#define M_10	2
#define M_16	3
#define M_2	4
#define MNUM	4

#define D_DAY	0
#define D_DECI	1
#define D_CENT	2
#define D_MILI	3
#define DNUM	5

int cur_wday = 0;
int cur_month = 0;
float dday;

signed long tzoff = 0;

int update_rate = 100000;

char timetxt[32];
char wdaytxt[8];
char monthtxt[8];
char mdaytxt[8];

int mday_x = 32;
int time_x = 0;


Font		gcf1, gcf2, gcf3;
unsigned long	gcctm, gccwd, gccmd,
		gccsh1, gccsh2, gccsh3,
		gccbg1, gccbg2, gccbg3,
		gccmd1;

char black[6] = "black";

char clock_mask_bits[64*64];
int  clock_mask_width  = 64;
int  clock_mask_height = 64;

Pixmap pixmap_mday;
Pixmap pixmap_wday;

int refresh_xpm = FALSE;


/*** Default Prefs ***/

int tmmode	= M_24;
int gmt		= FALSE;
int d_unit	= D_CENT;
int sh_time	= TRUE;
int sh_date	= FALSE;
int sh_tmfield	= TRUE;
int sh_dtfield	= FALSE;

char pixmap_file_mday[256] = "";
char pixmap_file_wday[256] = "";

char font_time[256]  = "-*-helvetica-medium-r-*-*-10-*-*-*-*-*-*-*";
char font_wday[256]  = "-*-helvetica-medium-r-*-*-10-*-*-*-*-*-*-*";
char font_date[256]  = "-*-helvetica-bold-r-*-*-24-*-*-*-*-*-*-*";

char color_frmdk[64] = "#000000";
char color_frmlt[64] = "#e6e6e6";
char color_time[64]  = "#3b3f33";
char color_mday[64]  = "#333333";
char color_wday[64]  = "#ffffff";
char color_bg1[64]   = "#a7b28e";
char color_bg2[64]   = "#696a74";
char color_bg3[64]   = "#c0c8e5";

int use_decimal_point = TRUE;
char dec_sep[2] = ".";
char prefix[2] = "";
char suffix[2] = "";
int dec_digets = 5;

int use_font_mday = TRUE;
int use_font_wday = TRUE;

/*********************/


void clock_routine(int, char **);
void set_locale_vars(void);
inline void draw_display(void);
void set_time_strings (void);
void draw_string (char *, int, int, unsigned long, int, unsigned long);
void draw_binary_time (void);
void init_fonts(void);
void init_colors(void);
unsigned long GetColor(char *, float, char *);
void set_main_xpm_colors(void);
XpmAttributes colorize_attributes(char *, char *);
Pixmap colorized_pixmap_file(char *, char *, char *);
/*Pixmap colorized_pixmap_data(char *, char *, char *);*/
void usage(int);
void clean_up(void);


/************************* WM GENERAL ************************/
/*************************************************************/

#define MAX_MOUSE_REGION (16)

typedef struct _rckeys rckeys;

struct _rckeys {
	const char	*label;
	char		**var;
};

typedef struct _rckeys2 rckeys2;

struct _rckeys2 {
	const char	*family;
	const char	*label;
	char		**var;
};

typedef struct {
	Pixmap		pixmap;
	Pixmap		mask;
	XpmAttributes	attributes;
} XpmIcon;

Display		*display;
Window		rootwin;
int		screen;
int		x_fd;
int		d_depth;
XSizeHints	mysizehints;
XWMHints	mywmhints;
Pixel		back_pix, fore_pix;
char		*Geometry = "";
Window		iconwin, win;
GC		winGC;
XpmIcon		wmgen;
Pixmap		pixmask;

typedef struct {
	int		enable;
	int		top;
	int		bottom;
	int		left;
	int		right;
} MOUSE_REGION;

MOUSE_REGION	mouse_region[MAX_MOUSE_REGION];

void AddMouseRegion(int index, int left, int top, int right, int bottom);
int CheckMouseRegion(int x, int y);
void openXwindow(int argc, char *argv[], char **, char *, int, int);
void RedrawWindow(void);
void RedrawWindowXY(int x, int y);
void createXBMfromXPM(char *, char **, int, int);
void copyXPMArea(int, int, int, int, int, int);
void copyXBMArea(int, int, int, int, int, int);
void setMaskXY(int, int);
void parse_rcfile(const char *, rckeys *);
static void GetXPM(XpmIcon *, char **);
void RedrawWindow(void);
void AddMouseRegion(int, int, int, int, int);
int CheckMouseRegion(int, int);

/*************************************************************/
/*************************************************************/



int main(int argc, char *argv[])
{
	int i;

	for (i = 1; i < argc; i++)
	{
		if (!strcmp(argv[i],"-display") |
			 !strcmp(argv[i],"-geometry")) i++;

		else if (!strcmp(argv[i],"-h") |
			 !strcmp(argv[i],"-help")) usage(0);

		else if (!strcmp(argv[i],"-help_theme")) usage(2);

		else if (!strcmp(argv[i],"-v") |
			 !strcmp(argv[i],"-version")) usage(9);

		else if (!strcmp(argv[i],"-gmt")) gmt = TRUE;

		else if (!strcmp(argv[i],"-idl"))
		{
			gmt = TRUE;
			tzoff = -43200;
		}

		else if (!strcmp(argv[i],"-tzoff"))
		{
			i++; if (i == argc) usage (1);
			gmt = TRUE;
			sscanf(argv[i],"%i",&tzoff);
		}

		else if (!strcmp(argv[i],"-swatch") |
			 !strcmp(argv[i],"-itime"))
		{
			gmt = TRUE; tzoff = 3600; tmmode = M_10;
			dec_digets = 3;strcpy(prefix,"@");use_decimal_point=FALSE;
		}

		else if (!strcmp(argv[i],"-m") | !strcmp(argv[i],"-mode"))
		{
			i++; if (i == argc) usage (1);

			if (!strcmp(argv[i],"24")) tmmode = M_24;
			else if (!strcmp(argv[i],"12") |
				 !strcmp(argv[i],"ap")) tmmode = M_12;
			else if (!strcmp(argv[i],"10") |
				 !strcmp(argv[i],"dec")) tmmode = M_10;
			else if (!strcmp(argv[i],"16") |
				 !strcmp(argv[i],"hex")) tmmode = M_16;
			else if (!strcmp(argv[i],"2") |
				 !strcmp(argv[i],"bin")) tmmode = M_2;
			else usage(1);
		}

		else if (!strcmp(argv[i],"-du"))
		{
			i++; if (i == argc) usage (1);

			if (!strcmp(argv[i],"1") |
				 !strcmp(argv[i],"day")) d_unit = D_DAY;
			else if (!strcmp(argv[i],"10") |
				 !strcmp(argv[i],"deci")) d_unit = D_DECI;
			else if (!strcmp(argv[i],"100") |
				 !strcmp(argv[i],"centi")) d_unit = D_CENT;
			else if (!strcmp(argv[i],"1000") |
				 !strcmp(argv[i],"milli")) d_unit = D_MILI;
			else usage(1);
		}
		else if (!strcmp(argv[i],"-bg1"))
		{
			i++; if (i == argc) usage (1);
			strcpy(color_bg1, argv[i]);
		}
		else if (!strcmp(argv[i],"-bg2"))
		{
			i++; if (i == argc) usage (1);
			strcpy(color_bg2, argv[i]);
		}
		else if (!strcmp(argv[i],"-bg3"))
		{
			i++; if (i == argc) usage (1);
			strcpy(color_bg3, argv[i]);
		}
		else if (!strcmp(argv[i],"-tmcol"))
		{
			i++; if (i == argc) usage (1);
			strcpy(color_time, argv[i]);
		}
		else if (!strcmp(argv[i],"-wdcol"))
		{
			i++; if (i == argc) usage (1);
			strcpy(color_wday, argv[i]);
		}
		else if (!strcmp(argv[i],"-mdcol"))
		{
			i++; if (i == argc) usage (1);
			strcpy(color_mday, argv[i]);
		}
		else if (!strcmp(argv[i],"-frmdkcol"))
		{
			i++; if (i == argc) usage (1);
			strcpy(color_frmdk, argv[i]);
		}
		else if (!strcmp(argv[i],"-frmltcol"))
		{
			i++; if (i == argc) usage (1);
			strcpy(color_frmlt, argv[i]);
		}

		else if (!strcmp(argv[i],"+sh_time")) sh_time = TRUE;
		else if (!strcmp(argv[i],"-sh_time")) sh_time = FALSE;

		else if (!strcmp(argv[i],"+sh_date")) sh_date = TRUE;
		else if (!strcmp(argv[i],"-sh_date")) sh_date = FALSE;

		else if (!strcmp(argv[i],"+sh_tmfield")) sh_tmfield = TRUE;
		else if (!strcmp(argv[i],"-sh_tmfield")) sh_tmfield = FALSE;

		else if (!strcmp(argv[i],"+sh_dtfield")) sh_dtfield = TRUE;
		else if (!strcmp(argv[i],"-sh_dtfield")) sh_dtfield = FALSE;

		else if (!strcmp(argv[i],"+use_font_wday")) use_font_wday = TRUE;
		else if (!strcmp(argv[i],"-use_font_wday")) use_font_wday = FALSE;

		else if (!strcmp(argv[i],"+use_font_mday")) use_font_mday = TRUE;
		else if (!strcmp(argv[i],"-use_font_mday")) use_font_mday = FALSE;

		else if (!strcmp(argv[i],"-font_time"))
		{
			i++; if (i == argc) usage (1);
			strcpy(font_time, argv[i]);
		}
		else if (!strcmp(argv[i],"-font_wday"))
		{
			i++; if (i == argc) usage (1);
			strcpy(font_wday, argv[i]);
			use_font_wday = TRUE;
		}
		else if (!strcmp(argv[i],"-font_mday"))
		{
			i++; if (i == argc) usage (1);
			strcpy(font_date, argv[i]);
			use_font_mday = TRUE;
		}

		else if (!strcmp(argv[i],"-pixmap_wday"))
		{
			i++; if (i == argc) usage (1);
			strcpy(pixmap_file_wday, argv[i]);
			use_font_wday = FALSE;
		}
		else if (!strcmp(argv[i],"-pixmap_mday"))
		{
			i++; if (i == argc) usage (1);
			strcpy(pixmap_file_mday, argv[i]);
			use_font_mday = FALSE;
		}

		else if (!strcmp(argv[i],"-prefix"))
		{
			i++; if (i == argc) usage (1);
			strcpy(prefix, argv[i]);
		}
		else if (!strcmp(argv[i],"-suffix"))
		{
			i++; if (i == argc) usage (1);
			strcpy(suffix, argv[i]);
		}

		else usage(0);
	}

	clock_routine(argc, argv);

	return 0;
}


void clock_routine(int argc, char **argv)
{
	int	i, but_stat = -1;
	XEvent	Event;

	set_locale_vars();

	createXBMfromXPM(clock_mask_bits, main_xpm,
			clock_mask_width, clock_mask_height);

	openXwindow(argc, argv, main_xpm, clock_mask_bits,
			clock_mask_width, clock_mask_height);

	if (use_font_mday == FALSE)
	{
		pixmap_mday = colorized_pixmap_file(
					pixmap_file_mday, color_mday, color_bg3);
		if ((int *)pixmap_mday == NULL) use_font_mday = TRUE;
	}
	if (use_font_wday == FALSE)
	{
		pixmap_wday = colorized_pixmap_file(
					pixmap_file_wday, color_wday, color_bg2);
		if ((int *)pixmap_wday == NULL) use_font_wday = TRUE;
	}

	init_fonts();
	init_colors();

	RedrawWindow();

	while(1)
	{
		draw_display();
		RedrawWindow();
        
		while (XPending(display))
		{
			XNextEvent(display, &Event);
			switch (Event.type)
			{
			case Expose:
				RedrawWindow();
				break;
			case DestroyNotify:

				clean_up();

				XCloseDisplay(display);
				exit(0);
				break;
			case ButtonPress:
				i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);

				if (Event.xbutton.y < 20)
				{
					if (Event.xbutton.button == Button1)
					{
						tmmode++;
						if (tmmode > MNUM) tmmode = 0;
					}
					else
					{
						tmmode--;
						if (tmmode < 0)	tmmode = MNUM;
					}
				}
				else
				{
					if (tmmode == M_10)
					{
						if (Event.xbutton.button == Button1)
						{
							d_unit++;
							if (d_unit > DNUM) d_unit = 0;
						}
						else
						{
							d_unit--;
							if (d_unit < 0)	d_unit = DNUM;
						}
					}
				}
				but_stat = i;
				break;

/***
			case ButtonRelease:
				i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);

				if (but_stat == i && but_stat >= 0)
				{
					switch (but_stat)
					{
					case 0 :
						break;
					case 1 :
						break;
					case 2:
						break;
					case 3:
						break;
					case 4:
						break;

					}
				}
				but_stat = -1;
				break;
***/

			}
		}

		usleep(update_rate);
	}

}


void set_locale_vars(void)
{
	struct lconv	*lc;

	lc = localeconv();

	strcpy(dec_sep, lc->decimal_point);

	return;
}


inline void draw_display( void )
{
	if(refresh_xpm)
	{
		GetXPM(&wmgen, main_xpm);
		XFreePixmap(display, pixmap_wday);
		XFreePixmap(display, pixmap_mday);
		pixmap_wday = colorized_pixmap_file(
					pixmap_file_wday, color_wday, color_bg2);
		pixmap_mday = colorized_pixmap_file(
					pixmap_file_mday, color_mday, color_bg3);
		refresh_xpm = FALSE;
	}
	else
	{

		XSetForeground(display, winGC, gccbg1);
		XFillRectangle(display, wmgen.pixmap, winGC, 6, 6, 53, 13);

		if(use_font_wday)
		{
			XSetForeground(display, winGC, gccbg2);
			XFillRectangle(display, wmgen.pixmap, winGC, 6, 25, 53, 12);
		}

		if(use_font_mday)
		{
			XSetForeground(display, winGC, gccbg3);
			XFillRectangle(display, wmgen.pixmap, winGC, 6, 37, 53, 22);
		}
	}

	set_time_strings();

	if(tmmode == M_2) draw_binary_time();
	else
	{
		XSetFont(display, winGC, gcf1);
		draw_string(timetxt, 6 + time_x, 16, gcctm, sh_time, gccsh1);
	}

	if(use_font_wday)
	{
		XSetFont(display, winGC, gcf2);
		draw_string(wdaytxt, 7, 34, gccwd, sh_date, gccsh2);
		draw_string(monthtxt, 32, 34, gccwd, sh_date, gccsh2);
	}
	else
	{
		XCopyArea(display, pixmap_wday, wmgen.pixmap, winGC,
						26*cur_wday+1, 0, 26, 12, 6, 25);
		if(cur_month < 6)
			XCopyArea(display, pixmap_wday, wmgen.pixmap, winGC,
						26*cur_month, 12, 26, 12, 32, 25);
		else
			XCopyArea(display, pixmap_wday, wmgen.pixmap, winGC,
						26*(cur_month - 6), 24, 26, 12, 32, 25);
	}

	if(use_font_mday)
	{
		XSetFont(display, winGC, gcf3);
		draw_string(mdaytxt, mday_x, 57, gccmd, sh_date, gccsh3);
	}
	else
	{
		XCopyArea(display, pixmap_mday, wmgen.pixmap, winGC,
						15*((int)mdaytxt[0]-48), 0, 15, 21, 28, 37);
		XCopyArea(display, pixmap_mday, wmgen.pixmap, winGC,
						15*((int)mdaytxt[1]-48), 0, 15, 21, 43, 37);
	}

	return;
}


void set_time_strings (void)
{
	struct tm	*timeS;
	time_t		timeT;
	struct timeval	timeV;
	int		hour, min, sec, apstate;
	char		ap[2] = "ap", swaptxt[16];

	timeT = time(NULL);

	if (gmt)
	{
		timeT = timeT + tzoff;
		timeS = gmtime(&timeT);
	}
	else
		timeS = localtime(&timeT);

	hour = timeS->tm_hour;
	min  = timeS->tm_min;
	sec  = timeS->tm_sec;

	cur_wday  = timeS->tm_wday;
	cur_month = timeS->tm_mon;

	if ((tmmode == M_10) | (tmmode == M_16) | (tmmode == M_2))
	{
		gettimeofday(&timeV, NULL);
		dday = ((float)hour/24)+((float)min/1440)+
			((float)sec/86400)+((float)timeV.tv_usec/86400000000);
	}

	switch (tmmode)
	{
	case M_24:
		time_x = 5;
		sprintf(timetxt, "%02i:%02i:%02i",
			hour, min, sec);
		break;
	case M_12:
		time_x = 2;
		if (hour <= 12)
		{
			apstate = 0;
			if (hour == 12)
				apstate = 1;
			if (hour == 0)
				hour = 12;
		}
		else
		{
			apstate = 1;
			hour = hour - 12;
		}
		sprintf(timetxt, "%2i:%02i:%02i%c",
			hour, min, sec, ap[apstate]);
		break;
	case M_10:
		time_x = 10-(4*strlen(prefix))-(4*strlen(suffix));

		dday = dday * pow(10, dec_digets);
		sprintf(timetxt, "%0*i", dec_digets, (int)dday);

		if(use_decimal_point)
		{
			sprintf(swaptxt, "");
			strncat(swaptxt, timetxt, d_unit);
			strcat(swaptxt, dec_sep);
			strcpy(timetxt, strcat(swaptxt, &timetxt[d_unit]));
		}

		if(strcmp(prefix, "") != 0)
			strcpy(timetxt, strcat(strcpy(swaptxt, prefix),timetxt));

		if(strcmp(suffix, "") != 0)
			strcat(timetxt, suffix);

		break;
	case M_16:
		time_x = 8;
		sprintf(timetxt, "0x%04x", (int)(dday * 65536));
		break;
	}

	strftime(wdaytxt, 8, "%a,", timeS);
	strftime(monthtxt, 8, "%b", timeS);
	strftime(mdaytxt, 8, "%d", timeS);

	return;
}


void draw_binary_time (void)
{
	int	x, y, i, a, b, dt;

	x = 8;
	y = 7;
	b = 262144;

	dt = (int)((float)dday * (float)b);

	for (i = 0; i < 16; i++)
	{
		b = b / 2;
		a = dt / b;
		if (a > 0) dt = dt - b;

		if (sh_time)
		{
			XSetForeground(display, winGC, (a == 1) ? gccsh1 : gccbg1);
			XFillRectangle(display, wmgen.pixmap, winGC, x+1, y+1, 5, 4);
		}

		XSetForeground(display, winGC, (a == 1) ? gcctm : gccmd1);
		XFillRectangle(display, wmgen.pixmap, winGC, x, y, 5, 4);

		x = x + 6;
		if ((i == 3)|(i == 11)) x = x +1;
		if (i == 7)
		{
			x = 8; y = 13;
		}
	}
	return;
}


void draw_string (char *text, int x, int y, unsigned long color,
					int shadow, unsigned long shcol)
{
	if (shadow)
	{
		XSetForeground(display, winGC, shcol);
		XDrawString(display, wmgen.pixmap, winGC, x+1, y+1, text, strlen(text));
	}
	XSetForeground(display, winGC, color);
	XDrawString(display, wmgen.pixmap, winGC, x, y, text, strlen(text));

	return;
}


XpmAttributes colorize_attributes(char *fore, char *back)
{
	XpmAttributes   attributes;
	XpmColorSymbol	clrs[8]={{"foreground", NULL, 0},
				{"gray1", NULL, 0},
				{"gray2", NULL, 0},
				{"gray3", NULL, 0},
				{"gray4", NULL, 0},
				{"gray5", NULL, 0},
				{"gray6", NULL, 0},
				{"background", NULL, 0}};

	clrs[0].value = fore;
	clrs[7].value = back;
	clrs[1].pixel = GetColor(fore, 0.84, back);
	clrs[2].pixel = GetColor(fore, 0.70, back);
	clrs[3].pixel = GetColor(fore, 0.56, back);
	clrs[4].pixel = GetColor(fore, 0.42, back);
	clrs[5].pixel = GetColor(fore, 0.28, back);
	clrs[6].pixel = GetColor(fore, 0.14, back);

	attributes.numsymbols   = 8;
	attributes.colorsymbols = clrs;
	attributes.exactColors  = False;
	attributes.closeness    = 40000;
	attributes.valuemask    = XpmReturnPixels | XpmReturnExtensions |
				  XpmColorSymbols | XpmExactColors |
				  XpmCloseness    | XpmSize;

	return(attributes);
}


Pixmap colorized_pixmap_file(char *pixmap_file, char *fore, char *back)
{
	Pixmap		the_pixmap;
	XpmAttributes   attributes;
	FILE		*fp;

	fp = fopen(pixmap_file, "r");
	if (fp == NULL)
	{
		fprintf(stderr,
			"Warning: Couldn't open file '%s', using font instead\n",pixmap_file);
		(int *)the_pixmap = NULL;
	}
	else
	{
		fclose(fp);
		attributes = colorize_attributes(fore,back);
		XpmReadFileToPixmap(display, rootwin,
					pixmap_file, &the_pixmap, NULL, &attributes);
	}

	return(the_pixmap);
}


/***** NOT USED YET *****
Pixmap colorized_pixmap_data(char *pixmap_data[], char *fore, char *back)
{
	Pixmap		the_pixmap;
	XpmAttributes   attributes;

	attributes = colorize_attributes(fore,back);
	XpmCreatePixmapFromData(display, rootwin, pixmap_data, &the_pixmap, NULL, &attributes);

	return(the_pixmap);
}
**************************/


void set_main_xpm_colors(void)
{
	XpmColorSymbol	clrs[9]={{"FrameDark", NULL, 0},
				{"FrameLite", NULL, 0},
				{"FrameCorner", NULL, 0},
				{"TimeBack", NULL, 0},
				{"WeekBack", NULL, 0},
				{"DateBack", NULL, 0},
				{"TimeShadow", NULL, 0},
				{"WeekShadow", NULL, 0},
				{"DateShadow", NULL, 0}};

	clrs[0].value = color_frmdk;
	clrs[1].value = color_frmlt;
	clrs[2].pixel = GetColor(color_frmdk, 0.5, color_frmlt);

	clrs[3].value = color_bg1;
	clrs[4].value = color_bg2;
	clrs[5].value = color_bg3;

	if (sh_tmfield)
		clrs[6].pixel = GetColor(color_bg1, 0.7, black);
	else
		clrs[6].value = color_bg1;

	if (sh_dtfield)
	{
		clrs[7].pixel = GetColor(color_bg2, 0.7, black);
		clrs[8].pixel = GetColor(color_bg3, 0.7, black);
	}
	else
	{
		clrs[7].value = color_bg2;
		clrs[8].value = color_bg3;
	}

	wmgen.attributes.numsymbols   = 9;
	wmgen.attributes.colorsymbols = clrs;
	wmgen.attributes.exactColors  = False;
	wmgen.attributes.closeness    = 40000;
	wmgen.attributes.valuemask    = XpmReturnPixels | XpmReturnExtensions |
					XpmColorSymbols | XpmExactColors |
					XpmCloseness    | XpmSize;

	return;
}

void init_colors( void )
{
	gcctm  = GetColor(color_time, 1, black);
	gccwd  = GetColor(color_wday, 1, black);
	gccmd  = GetColor(color_mday, 1, black);
	gccsh1 = GetColor(color_bg1, 0.91, black);
	gccsh2 = GetColor(color_bg2, 0.91, black);
	gccsh3 = GetColor(color_bg3, 0.91, black);
	gccbg1 = GetColor(color_bg1, 1, black);
	gccbg2 = GetColor(color_bg2, 1, black);
	gccbg3 = GetColor(color_bg3, 1, black);

	gccmd1 = GetColor(color_bg1, 0.91, color_time);		/* binary 0's */

	return;
}

void init_fonts( void )
{
	XFontStruct	*xfs;

	xfs = XLoadQueryFont(display, font_time);
	if (xfs == 0)
	{
		fprintf(stderr, "Unable to load time font: %s\n",font_time);
		exit(1);
	}
	gcf1 = xfs->fid;

	if (use_font_wday == TRUE)
	{
		xfs = XLoadQueryFont(display, font_wday);
		if (xfs == 0)
		{
			fprintf(stderr, "Unable to load weekday font: %s\n",font_wday);
			exit(1);
		}
		gcf2 = xfs->fid;
	}

	if (use_font_mday == TRUE)
	{
		xfs = XLoadQueryFont(display, font_date);
		if (xfs == 0)
		{
			fprintf(stderr, "Unable to load date font: %s\n",font_date);
			exit(1);
		}
		gcf3 = xfs->fid;
	}

	return;
}


void clean_up(void)
{
	XUnloadFont(display, gcf1);
	XUnloadFont(display, gcf2);
	XUnloadFont(display, gcf3);
	XFreePixmap(display, pixmap_mday);
	XFreePixmap(display, pixmap_wday);
	return;
}


void usage(int ex)
{
	fprintf(stderr, "%s v%s\n", NAME, VERSION);

	if(ex < 2)
	{
	fprintf(stderr, "\nusage:\n\n");

	fprintf(stderr, "\t-m, -mode <mode>\ttime mode: [24]     = 24 hour (default)\n");
	fprintf(stderr, "\t\t\t\t\t   [12|ap]  = AM/PM\n");
	fprintf(stderr, "\t\t\t\t\t   [10|dec] = decimal\n");
	fprintf(stderr, "\t\t\t\t\t   [16|hex] = hexidecimal\n");
	fprintf(stderr, "\t\t\t\t\t   [2|bin]  = binary\n");

	fprintf(stderr, "\t-du <n>\t\t\tdecimal unit: [1]    = days\n");
	fprintf(stderr, "\t\t\t\t\t      [10]   = decidays\n");
	fprintf(stderr, "\t\t\t\t\t      [100]  = centidays\n");
	fprintf(stderr, "\t\t\t\t\t      [1000] = millidays\n");

	fprintf(stderr, "\t-tzoff <seconds>\thow many seconds from GMT\n");
	fprintf(stderr, "\t-gmt\t\t\tuse Greenwich Mean Time\n");
	fprintf(stderr, "\t-idl\t\t\tuse International Date Line (GMT-12)\n");
	fprintf(stderr, "\t-swatch, -itime\t\tuse Swatch's 'Internet Time'\n");

	fprintf(stderr, "\t-h, -help\t\tthis help screen\n");
	fprintf(stderr, "\t-help_theme\t\tmore options for appearance\n");
	fprintf(stderr, "\t-v, -version\t\tprint the version number\n\n");
	}

	if(ex == 2)
	{
	fprintf(stderr, "\ntheme options:\n\n");
	fprintf(stderr, "\t-bg1 <color>\t\ttime background color\n");
	fprintf(stderr, "\t-bg2 <color>\t\tweek/month background color\n");
	fprintf(stderr, "\t-bg3 <color>\t\tdate background color\n");

	fprintf(stderr, "\t-tmcol <color>\t\ttime text color\n");
	fprintf(stderr, "\t-wdcol <color>\t\tweek/month text color\n");
	fprintf(stderr, "\t-mdcol <color>\t\tdate text color\n");

	fprintf(stderr, "\t-frmdkcol <color>\tframe dark color\n");
	fprintf(stderr, "\t-frmltcol <color>\tframe light color\n");

	fprintf(stderr, "\t-font_time <font>\ttime font\n");
	fprintf(stderr, "\t-font_wday <font>\tweek/month font\n");
	fprintf(stderr, "\t-font_mday <font>\tmonth day font\n");

	fprintf(stderr, "\t-pixmap_wday <file>\tweek/month pixmap\n");
	fprintf(stderr, "\t-pixmap_mday <file>\tmonth day pixmap\n");

	fprintf(stderr, "\t[+|-]sh_time\t\ttime text shadow\n");
	fprintf(stderr, "\t[+|-]sh_date\t\tweek/month/date text shadow\n");
	fprintf(stderr, "\t[+|-]sh_tmfield\t\ttime field shadow\n");
	fprintf(stderr, "\t[+|-]sh_dtfield\t\tdate field shadow\n\n");
	}

	if(ex > 1) ex = 0;

	exit(ex);
}


unsigned long GetColor(char *colorName, float fac, char *blendName)
{
	XColor			Color, Blend;
	XWindowAttributes	Attributes;

	if (fac > 1) fac = 1;

	XGetWindowAttributes(display, rootwin, &Attributes);
	Color.pixel = 0;
	Blend.pixel = 0;

	if (!XParseColor(display, Attributes.colormap, colorName, &Color))
	{
		fprintf(stderr, "Unable to parse color: %s\n", colorName);
		exit(1);
	}

	if (!XParseColor(display, Attributes.colormap, blendName, &Blend))
	{
		fprintf(stderr, "Unable to parse color: %s\n", blendName);
		exit(1);
	}

	Color.red   = (unsigned short)((fac*Color.red)+((1-fac)*Blend.red));
	Color.green = (unsigned short)((fac*Color.green)+((1-fac)*Blend.green));
	Color.blue  = (unsigned short)((fac*Color.blue)+((1-fac)*Blend.blue));
	Color.flags = DoRed | DoGreen | DoBlue;

	if (!XAllocColor(display, Attributes.colormap, &Color))
	{
		fprintf(stderr, "Unable to allocate color: %s\n", colorName);
		exit(1);
	}

	return Color.pixel;
}


/*******************************************************************************/
/****************************** WMGENERAL STUFF ********************************/
/*******************************************************************************/


/*******************************************************************************\
|* parse_rcfile									*|
\*******************************************************************************/
/*
void parse_rcfile(const char *filename, rckeys *keys)
{
	char	*p,*q;
	char	temp[128];
	char	*tokens = " :\t\n";
	FILE	*fp;
	int	i,key;

	fp = fopen(filename, "r");
	if (fp)
	{
		while (fgets(temp, 128, fp))
		{
			key = 0;
			q = strdup(temp);
			q = strtok(q, tokens);
			while (key >= 0 && keys[key].label)
			{
				if ((!strcmp(q, keys[key].label)))
				{
					p = strstr(temp, keys[key].label);
					p += strlen(keys[key].label);
					p += strspn(p, tokens);
					if ((i = strcspn(p, "#\n"))) p[i] = 0;
					free(*keys[key].var);
					*keys[key].var = strdup(p);
					key = -1;
				}
				else key++;
			}
			free(q);
		}
		fclose(fp);
	}
}
*/
/*******************************************************************************\
|* parse_rcfile2								*|
\*******************************************************************************/
/*
void parse_rcfile2(const char *filename, rckeys2 *keys)
{
	char	*p;
	char	temp[128];
	char	*tokens = " :\t\n";
	FILE	*fp;
	int	i,key;
	char	*family = NULL;

	fp = fopen(filename, "r");
	if (fp)
	{
		while (fgets(temp, 128, fp))
		{
			key = 0;
			while (key >= 0 && keys[key].label)
			{
				if ((p = strstr(temp, keys[key].label)))
				{
					p += strlen(keys[key].label);
					p += strspn(p, tokens);
					if ((i = strcspn(p, "#\n"))) p[i] = 0;
					free(*keys[key].var);
					*keys[key].var = strdup(p);
					key = -1;
				}
				else key++;
			}
		}
		fclose(fp);
	}
	free(family);
}
*/

/*******************************************************************************\
|* GetXPM									*|
\*******************************************************************************/

static void GetXPM(XpmIcon *wmgen, char *pixmap_bytes[])
{
	XWindowAttributes	attributes;
	int			err;

	/* For the colormap */
	XGetWindowAttributes(display, rootwin, &attributes);

	wmgen->attributes.valuemask |= (XpmReturnPixels | XpmReturnExtensions);

/* WMZCALOCK */
set_main_xpm_colors();
/*************/

	err = XpmCreatePixmapFromData(display, rootwin, pixmap_bytes, &(wmgen->pixmap),
					&(wmgen->mask), &(wmgen->attributes));
	
	if (err != XpmSuccess)
	{
		fprintf(stderr, "Not enough free colorcells.\n");
		exit(1);
	}
}

/*******************************************************************************\
|* flush_expose									*|
\*******************************************************************************/

static int flush_expose(Window w)
{
	XEvent	dummy;
	int	i=0;

	while (XCheckTypedWindowEvent(display, w, Expose, &dummy))
		i++;

	return i;
}

/*******************************************************************************\
|* RedrawWindow									*|
\*******************************************************************************/

void RedrawWindow(void)
{
	flush_expose(iconwin);
	XCopyArea(display, wmgen.pixmap, iconwin, winGC, 
			0,0, wmgen.attributes.width, wmgen.attributes.height, 0,0);
	flush_expose(win);
	XCopyArea(display, wmgen.pixmap, win, winGC,
			0,0, wmgen.attributes.width, wmgen.attributes.height, 0,0);
}

/*******************************************************************************\
|* RedrawWindowXY								*|
\*******************************************************************************/

void RedrawWindowXY(int x, int y)
{
	flush_expose(iconwin);
	XCopyArea(display, wmgen.pixmap, iconwin, winGC, 
			x,y, wmgen.attributes.width, wmgen.attributes.height, 0,0);
	flush_expose(win);
	XCopyArea(display, wmgen.pixmap, win, winGC,
			x,y, wmgen.attributes.width, wmgen.attributes.height, 0,0);
}

/*******************************************************************************\
|* AddMouseRegion								*|
\*******************************************************************************/

void AddMouseRegion(int index, int left, int top, int right, int bottom)
{
	if (index < MAX_MOUSE_REGION)
	{
		mouse_region[index].enable = 1;
		mouse_region[index].top = top;
		mouse_region[index].left = left;
		mouse_region[index].bottom = bottom;
		mouse_region[index].right = right;
	}
}

/*******************************************************************************\
|* CheckMouseRegion								*|
\*******************************************************************************/

int CheckMouseRegion(int x, int y)
{
	int	i;
	int	found;

	found = 0;

	for (i=0; i<MAX_MOUSE_REGION && !found; i++)
	{
		if (mouse_region[i].enable &&
			x <= mouse_region[i].right &&
			x >= mouse_region[i].left &&
			y <= mouse_region[i].bottom &&
			y >= mouse_region[i].top)
			found = 1;
	}
	if (!found) return -1;
	return (i-1);
}

/*******************************************************************************\
|* createXBMfromXPM	 							*|
\*******************************************************************************/
void createXBMfromXPM(char *xbm, char **xpm, int sx, int sy)
{
	int		i,j,k;
	int		width, height, numcol, depth;
	int		zero=0;
	unsigned char	bwrite;
	int		bcount;
	int		curpixel;
	
	sscanf(*xpm, "%d %d %d %d", &width, &height, &numcol, &depth);

	for (k=0; k!=depth; k++)
	{
		zero <<=8;
		zero |= xpm[1][k];
	}

	for (i=numcol+1; i < numcol+sy+1; i++)
	{
		bcount = 0;
		bwrite = 0;
		for (j=0; j<sx*depth; j+=depth)
		{
			bwrite >>= 1;
			curpixel=0;
			for (k=0; k!=depth; k++)
			{
				curpixel <<=8;
				curpixel |= xpm[i][j+k];
			}
                
			if ( curpixel != zero )
			{
				bwrite += 128;
			}
			bcount++;
			if (bcount == 8)
			{
				*xbm = bwrite;
				xbm++;
				bcount = 0;
				bwrite = 0;
			}
		}
	}
}

/*******************************************************************************\
|* copyXPMArea									*|
\*******************************************************************************/

void copyXPMArea(int x, int y, int sx, int sy, int dx, int dy)
{
	XCopyArea(display, wmgen.pixmap, wmgen.pixmap, winGC, x, y, sx, sy, dx, dy);
}

/*******************************************************************************\
|* copyXBMArea									*|
\*******************************************************************************/

void copyXBMArea(int x, int y, int sx, int sy, int dx, int dy)
{
	XCopyArea(display, wmgen.mask, wmgen.pixmap, winGC, x, y, sx, sy, dx, dy);
}


/*******************************************************************************\
|* setMaskXY									*|
\*******************************************************************************/

void setMaskXY(int x, int y)
{
	XShapeCombineMask(display, win, ShapeBounding, x, y, pixmask, ShapeSet);
	XShapeCombineMask(display, iconwin, ShapeBounding, x, y, pixmask, ShapeSet);
}

/*******************************************************************************\
|* openXwindow									*|
\*******************************************************************************/
void openXwindow(int argc, char *argv[], char *pixmap_bytes[], char *pixmask_bits,
		int pixmask_width, int pixmask_height)
{
	unsigned int	borderwidth = 1;
	XClassHint	classHint;
	char		*display_name = NULL;
	char		*wname = argv[0];
	XTextProperty	name;

	XGCValues	gcv;
	unsigned long	gcm;

	char		*geometry = NULL;

	int		dummy=0;
	int		i, wx, wy;

	for (i=1; argv[i]; i++)
	{
		if (!strcmp(argv[i], "-display"))
		{
			display_name = argv[i+1];
			i++;
		}
		if (!strcmp(argv[i], "-geometry"))
		{
			geometry = argv[i+1];
			i++;
		}
	}

	if (!(display = XOpenDisplay(display_name)))
	{
		fprintf(stderr, "%s: can't open display %s\n",
					wname, XDisplayName(display_name));
		exit(1);
	}
	screen  = DefaultScreen(display);
	rootwin = RootWindow(display, screen);
	d_depth = DefaultDepth(display, screen);
	x_fd    = XConnectionNumber(display);


	/* Convert XPM to XImage */
	GetXPM(&wmgen, pixmap_bytes);

	/* Create a window to hold the stuff */
	mysizehints.flags = USSize | USPosition;
	mysizehints.x = 0;
	mysizehints.y = 0;

	back_pix = GetColor("white",1,black);
	fore_pix = GetColor("black",1,black);

	XWMGeometry(display, screen, Geometry, NULL, borderwidth, &mysizehints,
			&mysizehints.x, &mysizehints.y,&mysizehints.width,
			&mysizehints.height, &dummy);

	mysizehints.width = 64;
	mysizehints.height = 64;
		
	win = XCreateSimpleWindow(display, rootwin, mysizehints.x, mysizehints.y,
		mysizehints.width, mysizehints.height, borderwidth, fore_pix, back_pix);
	
	iconwin = XCreateSimpleWindow(display, win, mysizehints.x, mysizehints.y,
		mysizehints.width, mysizehints.height, borderwidth, fore_pix, back_pix);

	/* Activate hints */
	XSetWMNormalHints(display, win, &mysizehints);
	classHint.res_name = wname;
	classHint.res_class = wname;
	XSetClassHint(display, win, &classHint);

	XSelectInput(display, win,
			ButtonPressMask | ExposureMask | ButtonReleaseMask |
			PointerMotionMask | StructureNotifyMask);
	XSelectInput(display, iconwin,
			ButtonPressMask | ExposureMask | ButtonReleaseMask |
			PointerMotionMask | StructureNotifyMask);

	if (XStringListToTextProperty(&wname, 1, &name) == 0)
	{
		fprintf(stderr, "%s: can't allocate window name\n", wname);
		exit(1);
	}

	XSetWMName(display, win, &name);

	/* Create GC for drawing */
	
	gcm = GCForeground | GCBackground | GCGraphicsExposures;
	gcv.foreground = fore_pix;
	gcv.background = back_pix;
	gcv.graphics_exposures = 0;
	winGC = XCreateGC(display, rootwin, gcm, &gcv);

	/* ONLYSHAPE ON */

	pixmask = XCreateBitmapFromData(display, win, pixmask_bits,
					pixmask_width, pixmask_height);

	XShapeCombineMask(display, win, ShapeBounding, 0, 0, pixmask, ShapeSet);
	XShapeCombineMask(display, iconwin, ShapeBounding, 0, 0, pixmask, ShapeSet);

	/* ONLYSHAPE OFF */

	mywmhints.initial_state = WithdrawnState;
	mywmhints.icon_window = iconwin;
	mywmhints.icon_x = mysizehints.x;
	mywmhints.icon_y = mysizehints.y;
	mywmhints.window_group = win;
	mywmhints.flags = StateHint | IconWindowHint |
			  IconPositionHint | WindowGroupHint;

	XSetWMHints(display, win, &mywmhints);

	XSetCommand(display, win, argv, argc);
	XMapWindow(display, win);

	if (geometry)
	{
		if (sscanf(geometry, "+%d+%d", &wx, &wy) != 2)
		{
			fprintf(stderr, "Bad geometry string.\n");
			exit(1);
		}
		XMoveWindow(display, win, wx, wy);
	}
}

