/* $Id: category.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include "programConfig.h"

#if CATEGORY_SUPPORT

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "clist.h"
#include "str.h"
#include "xfError.h"
#include "country.h"
#include "allocmem.h"
#include "category.h"

static CLIST *catlist;   /* linked list of categories */

void initCategory() {
  catlist=newlist(STRUCT,sizeof(category)); /* create linked list */
  loadCategories();
}

void loadCategories() {
  FILE *f;
  char buf[MAX_DEFINITION_SIZE];
  int i,l;
  char *p;
  category new;

  if( !(f=fopen(CAT_FILE, "r")) ) {
    /* xfError(ERR_FILE_NOT_FOUND, NONFATAL, "file not found"); 
       NB! we cant't use xfError at this point */
    return;
  }

  while(!feof(f)) {
    if( fgets(buf,MAX_DEFINITION_SIZE,f) ) {
      l=strlen(buf);
      buf[l-1]=0;
      /* printf("Number: %s\n", buf);*/
      new.number=atoi(buf);
    } else
      break;

    fgets(buf,MAX_DEFINITION_SIZE,f);
    l=strlen(buf);
    buf[l-1]=0;
    /* printf("Name  : %s\n", buf); */
    zeroAddStrncpy(new.name, buf, CAT_NAME_LENGTH-1);

    buf[0]=0;
    l=0;i=0;
    p=buf;

    while(!feof(f) && l<MAX_DEFINITION_SIZE-1) {
      if( fgets(p,MAX_DEFINITION_SIZE-l,f) ) {
	if(!strcmp(p,"#enddef\n"))
	  break;
	i=strlen(p);
	l+=i; 
	p+=i;
      }
    }
    if( l==0 )
      l++;
    new.definition = (char *)AllocateMemory(l);
    zeroAddStrncpy(new.definition, buf, l-1);
    /* printf("Def %d : %s\n", l, new.definition); */

    insert_last((BYTE *)&new, catlist);
  }

  fclose(f);
}

void saveCategories() {
  FILE *f;
  int i;
  category *c;

  if( !(f=fopen(CAT_FILE, "w")) ) {
    xfError(ERR_CANT_WRITE_FILE, NONFATAL, "can't write");
    return;
  }

  for(i=0; i<catlist->size; i++) {
    c=(category *)retrieve(i+1, catlist);
    fprintf(f, "%d\n%s\n%s\n#enddef\n", c->number, c->name, c->definition);
  }

  fclose(f);
}

category *findCat(int num) {
  int i;
  category *c;

  for(i=0; i<catlist->size; i++) {
    c=(category *)retrieve(i+1, catlist);
    if( c->number==num ) {
      /* printf("%d\n%s\n%s", c->number, c->name, c->definition); */
      return c;
    }
  }
  return 0;
}

char **categoryWindowStrings(char *res[], int maxlines, char *word) {
  char buf[256];
  int i, j, k;
  category *c;

  for(i=0, k=0; i<catlist->size && k<maxlines-1; i++) {
    c=(category *)retrieve(i+1,catlist);
    if( cistrstr(c->name, word) ) {
      sprintf(buf, "%04d  %s", c->number, c->name);
      res[k]=(char *)AllocateMemory(strlen(buf)+1);
      strcpy(res[k], buf);
      k++;
    }
  }

  res[k]=0;
  return res;
}

category *findCatWithRelativeIndex(int index, char *word) {
  int i, j, k;
  category *c;

  for(i=0, k=0; i<catlist->size; i++) {
    c=(category *)retrieve(i+1,catlist);
    if( cistrstr(c->name, word) ) {
      if( k==index )
	return c;
      k++;
    }
  }

  return 0;
}

void deleteCategory(int number) {
  int i;
  category *c;

  for(i=0; i<catlist->size; i++) {
    c=(category *)retrieve(i+1,catlist);
    if( c->number==number ) {
      if( c->definition )
	free(c->definition);
      delete_ith(i+1,catlist);
      return;
    }
  }
}

void insertCategory(category *newcat) {
  int i;
  category *c;

  deleteCategory(newcat->number);    /* remove existing cat. with same
					number (if any) */
  for(i=0; i<catlist->size; i++) {
    c=(category *)retrieve(i+1,catlist);
    if( c->number > newcat->number )
      break;
  }
  insert_ith(i+1, (BYTE *)newcat, catlist);
}

#endif /* CATEGORY_SUPPORT */
