/* $Id: focus.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include "clist.h"            /* circular linked list */
#include "programConfig.h"
#include "focus.h"

#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h> 

static CLIST *pairList;
static int group;
static int focusMethod=FOCUS_MOUSE;

void initFocus() {
  pairList=newlist(STRUCT,sizeof(focus_pair)); /* create linked list */
  group=0;
}

int newGroup() {
  return ++group;
}

int currentGroup() {
  return group;
}

void setFocusMethod(int focusMeth) {
  focusMethod=focusMeth;
}

void removeCarets(int fgroup) {
  focus_pair *fp;
  int i;
  
  for(i=1; i<=pairList->size; i++) {
    fp=(focus_pair *)retrieve(i,pairList);
    if(fp->group==fgroup)
      XtVaSetValues(fp->from,
		    XtNdisplayCaret, False,
		    NULL );
  }
}

static void setFocus(Widget root, Widget target, int fgroup) {
  Position x,y;
    
  if( focusMethod==FOCUS_KEYB ) {
    removeCarets(fgroup);
    XtSetKeyboardFocus(root, target); 
    
    XtVaSetValues(target,
		  XtNdisplayCaret, True,
		  NULL );
    return;
  }
  
  if(focusMethod==FOCUS_EXPER) {
    XtVaGetValues(target, XtNx, &x,
		  XtNy, &y,
		  NULL );
    
    /* printf("%d,%d\n", x,y); */
    
    XWarpPointer(XtDisplay(target), 0, XtWindow(root), 0,0, 0,0, 
		 x+FRAME_X_OFFSET+X_OFFSET, y+FRAME_Y_OFFSET+Y_OFFSET);
    return;
  }
}

void saveFocusInfo(Widget from, Widget to, Widget root, 
		   Widget confirm, int newgroup) {
  focus_pair fp;
  
  fp.from = from;
  fp.to   = to;
  fp.root = root;
  fp.confirmButton = confirm;
  if(newgroup) {
    fp.group=newGroup();
  }
  else
    fp.group=currentGroup();
  
  insert_last((BYTE *)&fp, pairList);
}

static focus_pair *nextField(Widget currentField) {
  focus_pair *fp;
  int i;
  
  for(i=1; i<=pairList->size; i++) {
    fp=(focus_pair *)retrieve(i,pairList);
    if(fp->from==currentField)
      return fp;
  }
  
  return 0;
}

static focus_pair *prevField(Widget currentField) {
  focus_pair *fp;
  int i;
  
  for(i=1; i<=pairList->size; i++) {
    fp=(focus_pair *)retrieve(i,pairList);
    if(fp->to==currentField)
      return fp;
  }
  
  return 0;
}

void jumpNext(Widget currentField) {
  focus_pair *next;

  next=nextField(currentField);
  if(next) {
    setFocus(next->root, next->to, next->group);
  }
}

void jumpPrev(Widget currentField) {
  focus_pair *prev;

  prev=prevField(currentField);
  if(prev) {
    setFocus(prev->root, prev->from, prev->group);
  }
}

void jumpTo(Widget field) {
  focus_pair *next;
  
  next=nextField(field);
  if(next) {
    setFocus(next->root, next->from, next->group);
  }
}

void confirmAction(Widget field) {
  focus_pair *next;
  Widget confirm;
  
  next=nextField(field);
  if(next) {
    confirm=next->confirmButton;
    if(confirm)
      XtCallCallbacks(confirm, XtNcallback, 0);
  }
}
