/* $Id: error.c,v 4.2 1995/10/04 21:36:47 lupus Exp lupus $ */

#include <time.h>
#include <string.h>
#include <stdio.h>

#include "errorp.h"
#include "error.h"
#include "country.h"
#include "info.h"

#define PW 300
#define CHARW 6

static Widget errorShell, errorForm, 
  errorTextLabel, 
  errorOk, errorHelp;

static int up=0;
static char *helpl="";

void createErrorWidgets(void) {
  static int done=0;
  
  if(done)
    return;
  done=1;

  errorShell = XtVaCreatePopupShell (
				     "errorShell",
				     transientShellWidgetClass,
				     topLevel,
				     XtNtitle, ERROR_TITLE,
				     XtNwidth, PW,
				     NULL );
  
  errorForm = XtVaCreateManagedWidget(
				   "errorForm",
				   formWidgetClass,
				   errorShell,
				   NULL);
  
  errorTextLabel = XtVaCreateManagedWidget(
				     "errorTextLabel",
				     labelWidgetClass,
				     errorForm,
				     XtNlabel, "jaja" ,
				     XtNwidth, PW-10,
				     XtNresize, False,
				     NULL);

  errorOk = XtVaCreateManagedWidget(
				    "errorOk",
				    commandWidgetClass,
				    errorForm,
				    XtNlabel, ERROR_OK_LABEL,
				    XtNfromVert, errorTextLabel,
				    XtNwidth, (PW/2)-5,
				    NULL);

  errorHelp = XtVaCreateManagedWidget(
				    "errorHelp",
				    commandWidgetClass,
				    errorForm,
				    XtNlabel, ERROR_HELP_LABEL,
				    XtNfromVert, errorTextLabel,
				    XtNfromHoriz, errorOk,
				    XtNwidth, (PW/2)-5,
				    NULL);
  
  addErrorCallBack();
}

void addErrorCallBack(void) {
  XtAddCallback(errorOk, XtNcallback, ErrorOk, topLevel);
  XtAddCallback(errorHelp, XtNcallback, ErrorHelp, topLevel);
}

/* ========================================================== */     
void ErrorPopup(char *text, char *helplink)
{
  Position x,y;
  Dimension width, height;
  String p;
  int i;
  
  createErrorWidgets();

  if( helplink )
    helpl=helplink;
  else
    helpl="nolink";
  
  XtVaSetValues(errorTextLabel,	
		XtNlabel, text,
		/* XtNwidth, CHARW*strlen(text)+10, */
		NULL);

  if(!up) {
    XtTranslateCoords(topLevel,(Position)25, (Position)50,
		      &x, &y);
    
    XtVaSetValues(errorShell, XtNx, x,
		  XtNy, y,
		  NULL );
  
    up=1;
    XtPopup(errorShell, XtGrabNone);
  }
}

void ErrorOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  up=0;
  XtPopdown(errorShell);
}

void ErrorHelp(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  up=0;
  XtPopdown(errorShell);
  find_info(helpl);
}
