/* $Id: hyper.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include <stdio.h>
#include <string.h>

#include "clist.h"
#include "allocmem.h"
#include "hyper.h"
#include "xfError.h"
#include "country.h"

CLIST *hlist;
char htfile[256];

void readIndex(FILE *f, FILE *htf);
char *bodyTextFromFile(int lnum, int size, FILE *f);

void hyperInit(char *hypertextfile) {
  FILE *f;
  FILE *htf;

  char buf[256];

  hlist=newlist(STRUCT,sizeof(struct hlink)); /* create linked list */

  strcpy(htfile,hypertextfile);
  strcpy(buf,hypertextfile);
  strcat(buf,".index");

  if( (f=fopen(buf,"r"))==NULL ) {
    xfError("File 'hyperhelp.index' not found", NONFATAL,"file not found");
    return;
  }
  
  if( (htf=fopen(htfile,"r"))==NULL ) {
    xfError("File 'hyperhelp' not found", NONFATAL,"file not found");
    fclose(f);
    return;
  }
  
  readIndex(f,htf);
  fclose(htf);
  fclose(f);
}

void readIndex(FILE *f, FILE *htf) {
  char buf[256];
  struct hlink hl;
 
  while(!feof(f)) {
    if( fgets(buf,255,f) )   {
      hl.name=(char *)AllocateMemory(strlen(buf)+1);
      strcpy(hl.name,buf);
      hl.name[strlen(hl.name)-1]=0;

      fgets(buf,255,f);
      hl.nextlink=(char *)AllocateMemory(strlen(buf)+1);
      strcpy(hl.nextlink,buf);
      hl.nextlink[strlen(hl.nextlink)-1]=0;

      fgets(buf,255,f);
      hl.linenum=atoi(buf);

      fgets(buf,255,f);
      hl.size=atoi(buf);

      hl.body=bodyTextFromFile(hl.linenum, hl.size, htf);
      /* printf("%s == %s", hl.name, hl.body); */ 
      insert_last((BYTE *)&hl,hlist);
    }
  }
}

char *bodyTextFromFile(int lnum, int size, FILE *f) {
  static int prevline=0;
  int totallen=0, old;
  int delta, i;
  char buf[256];
  char *res;

  delta=lnum-prevline;

  for(i=0; i<delta; i++) {
    prevline++;
    fgets(buf,255,f);
    /* printf("skip %s\n", buf); */
  }
  res=(char *)AllocateMemory(size+5);
  res[0]=0;

  while( fgets(buf,255,f) ) {
    prevline++;
    /* printf("use %s\n", buf); */
    if(buf[0]==':')
      return res;
    old=totallen;
    totallen+=strlen(buf);
    if(totallen<size+1)
      /* strcat(res,buf); */
      strcpy(res+old,buf);
  }
  return res;
}

struct hlink *linkFind(char *name) {
  struct hlink *hl;
  int t;

  for(t=1; t<=hlist->size; t++) {
    hl=(struct hlink *)retrieve(t,hlist);
    /* printf("%s %d %d\n", hl->name, hl->linenum, hl->size); */
    if(!strcmp(name,hl->name))
      return hl;
  }
  return 0;
}

char *bodyText(char *linkname) {
  struct hlink *hl;
  hl=linkFind(linkname);
  if(!hl)
    return "nomatch";
  return hl->body;
}

char *linkAtPosition(char *bodyText, int position) {
  int i,j,k;
  int done=0;
  char *p="nolink";
  static char item[LINK_MAX_LEN];

  if(position>strlen(bodyText)) {
    return p;
  }
  for(i=position; i>0 && !done; i--) {
    if( *(bodyText+i)=='_' && *(bodyText+i-1)=='_' ) {
      for(j=i+1, k=0; k<LINK_MAX_LEN && *(bodyText+j); j++, k++) {
	if( *(bodyText+j)=='_' && *(bodyText+j+1)=='_' ) {
	  item[k]=0;
	  return item;
	}
	item[k]=*(bodyText+j);
      }
      done=1;
    }
  }
  return p;
}

char *nextlink(char *linkname) {
  struct hlink *hl;
  hl=linkFind(linkname);
  if(!hl)
    return "nolink";
  return hl->nextlink;
}
