/* $Id: post.c,v 4.11 1996/06/15 19:33:07 lupus Exp lupus $ */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "post.h"
#include "clist.h"
#include "xfinans.h"
#include "post_io.h"
#include "psOutput.h"
#include "konto.h"
#include "rente.h"
#include "pante.h"
#include "aktie.h"
#include "str.h"
#include "datoPrint.h"
#include "date.h"
#include "gregor.h"
#include "average.h"
#include "xfError.h"
#include "country.h"
#include "programConfig.h"
#include "allocmem.h"
#include "config.h"
#include "window.h"
#include "saldo.h"
#include "category.h"
#include "printDimen.h"
#include "multiSort.h"
#include "displayLimit.h"

#define LINELEN 45
#define BALANCE_LEN 11
#define SEARCH_LEN 38
#define DAT(y, m, d) ( (y)*10000 + (m)*100 + (d) )

extern int  showCommitted;             /* in config.c */
extern int  showTransNumbers;          /* in config.c */
extern int  showCatNumbers;            /* in config.c */
extern int  showCatNames;              /* in config.c */
extern char floatFormatString[];       /* in config.c */
extern char floatShortFormatString[];  /* in config.c */

CLIST *aktPoster;                   /* linked list of transactions */
char *postString[MAX_POSTERINGER];  /* text strings to be shown in window */
static int antalVises=DEFAULT_ANTAL_VISES;/* number of transactions shown */
static int actualFirstIndx=0;
static double currentSaldo=0.0;
static int set_zero=0;
static double deltaZeroBalance=0.0;

void initPost(void) {
  int i;
  aktPoster=newlist(STRUCT,sizeof(struct postering)); /* create linked list */
  for(i=0; i<MAX_POSTERINGER; i++)
    postString[i]=0;
}

void testPost(void) {
   int t;
   struct postering *p;
   printf("BEGIN\n");
   for(t=1; t<=aktPoster->size; t++) {
     p=(struct postering *)retrieve(t,aktPoster);
     printf("%s\n", p->tekst );
   }
   printf("END\n");
 }

void clearPoster(void) {
  delete_all(aktPoster); /* slet alt i den linkede liste */
}

void loadPoster(char *fname) {
  FILE *f;
  struct postering buf, *ny;

  if( (f=fopen(fname,"r"))==NULL ) {
    xfError(ERR_FILE_NOT_FOUND, NONFATAL, "file not found");
    return;
  }
  
  delete_all(aktPoster); /* slet alt i den linkede liste */

  while( load_post(f,&buf) ) {  /* indlaes post fra fil */
    insert_last((BYTE *)&buf,aktPoster); /* indsaet post i linket liste */
  }

  fclose(f);
}

void savePoster(char *fname) {
  FILE *f;
  struct postering *p;
  int i;

  if( (f=fopen(fname,"w"))==NULL ) {
    xfError(ERR_CANT_WRITE_FILE, NONFATAL, "can't write");
    return;
  }

  for(i=0; i<aktPoster->size; i++) {
    p=(struct postering *)retrieve(i+1, aktPoster);
    save_post(f,p);
  }
  fclose(f);
}

void writeTransactionsToFile(FILE *f) {
  struct postering *post;
  int i;
  char buf[POST_TEXT_LENGTH+1];

  for(i=0; i<aktPoster->size; i++) {
    post=(struct postering *)retrieve(i+1, aktPoster);
    zeroAddStrncpy(buf, post->tekst, POST_TEXT_LENGTH);
    fprintf(f, "%d;%05d;%d;%s;%f;%d\n", 
	    DAT(year(post->dato), month(post->dato), day(post->dato)),
	    post->number,
	    post->category,
	    nosemicolon(buf), 
	    post->bel,
	    post->committed);
  }
}

static int startIndex(int size) {
  if( actualFirstIndx!=0 )
    return actualFirstIndx;

  if( antalVises==0 ) /* antalVises=0 betyder vis alle posteringer 
			 -> altsaa start ved indx 0 */
    return 0;
  if( size-antalVises<0 )
    return 0;
  return size-antalVises;
}

double calculateBalanceAt(int date) {
  int i;
  double balance=0.0;
  struct postering *p;
  
  for(i=0; 
      i<aktPoster->size;
      i++) {
    p=(struct postering *)retrieve(i+1,aktPoster);
    if(p->dato<=date) 
      balance+=p->bel;
    else
      break;
  }
  return balance;
}
     
void calculateCurrentSaldo(void) {  
  int i, j, saldoFirst=1;
  double saldo=0.0;
  struct postering *p;
  
  for(i=0; 
      i<aktPoster->size;
      i++) {
    p=(struct postering *)retrieve(i+1,aktPoster);
    if(p->dato>today() && saldoFirst) {
      saldoFirst=0;
      currentSaldo=saldo;
      currentSaldoValid(currentSaldo);
    }
    saldo+=p->bel;
  }
  if(saldoFirst) {
    saldoFirst=0;
    currentSaldo=saldo;
    currentSaldoValid(currentSaldo);
  }
}

char *floatString(char *in, double x) {
  sprintf(in, floatFormatString, x);
  return in;
}

char *transactionNumberString(int num) {
  static char buf[20];
  
  if(showTransNumbers)
    sprintf(buf, TRANSACTION_NUMBER_FORMAT, num);
  else
    buf[0]=0;
  
  return buf;
}

char *categoryNumberString(int num) {
  static char buf[20];
  
  if(showCatNumbers)
    sprintf(buf, "%04d  ", num);
  else
    buf[0]=0;
  
  return buf;
}

char *categoryNameString(int num) {
  static char buf[50];
  category *c;
  int i;

#if CATEGORY_SUPPORT
  if(showCatNames) {
    c=findCat(num);
    if(c) 
      zeroAddStrncpy(buf, c->name, strlen(CAT_NAME_LABEL)-2);
    else
      zeroAddStrncpy(buf, CAT_NOT_FOUND_LABEL, strlen(CAT_NAME_LABEL)-2);
    for(i=strlen(buf); i<strlen(CAT_NAME_LABEL); i++)
      buf[i]=' ';
    buf[i]=0;
  }
  else
#endif
    buf[0]=0;
  
  return buf;
}

void printTransaction(char *in, int transaction_witdh, int date, 
		      char *text, double amount, 
		      double bal1, double bal2, 
		      int committed, int number, int catnum) {
  int number_of_float_columns=2;
  int text_length, i,j;
  char buf[256], floatbuf1[32], floatbuf2[32];

  if(showCommitted)
    number_of_float_columns++;

  if(get_two_column())
    number_of_float_columns++;

  text_length=transaction_witdh-strlen(dateString(date))-number_of_float_columns*BALANCE_LEN-2;

  if(set_zero)
    bal1-=deltaZeroBalance;
  
  if(get_show_all())
    text_length-=3;

  if(showTransNumbers)
    text_length-=strlen(TRANS_NUMBER_LABEL);
  if(showCatNumbers)
    text_length-=strlen(CAT_NUMBER_LABEL);
  if(showCatNames)
    text_length-=strlen(CAT_NAME_LABEL);

  if(text_length<2)
    text_length=2;

  zeroAddStrncpy(buf,text,text_length);
  for(i=strlen(buf); i<text_length; i++)
    buf[i]=' ';
  buf[i]=0;

  if( get_two_column()) {
#if WITHDRAW_COLUMN==LEFT
    if( amount<0.0 ) {
#else
    if( amount>=0.0 ) {
#endif

#if !SIGNED_TRANSACTIONS_IN_TWO_COLUMN_MODE
    amount=(amount<0.0) ? -amount:amount;
#endif
      sprintf(in, "%s  %s%s%s%s  %s", dateString(date), 
                                transactionNumberString(number), 
	                        categoryNumberString(catnum),
	                        categoryNameString(catnum),
	                        buf, 
	                        floatString(floatbuf1, amount));
      for(i=strlen(in), j=0; j<BALANCE_LEN; i++, j++)
	in[i]=' ';
      in[i]=0;
      sprintf(in+strlen(in), "  %s", floatString(floatbuf1, bal1));
    } else {
      sprintf(in, "%s  %s%s%s%s", dateString(date), 
	                          transactionNumberString(number), 
	                          categoryNumberString(catnum),
	                          categoryNameString(catnum),
	                          buf);
      for(i=strlen(in), j=0; j<BALANCE_LEN; i++, j++)
	in[i]=' ';
      in[i]=0;
      sprintf(in+strlen(in), "  %s  %s", 
	                            floatString(floatbuf1, amount), 
	                            floatString(floatbuf2, bal1) );
    }
  } else
    sprintf(in, "%s  %s%s%s%s  %s  %s", dateString(date), 
	                          transactionNumberString(number), 
	                          categoryNumberString(catnum),
	                          categoryNameString(catnum),
	                          buf,
 	                          floatString(floatbuf1, amount), 
	                          floatString(floatbuf2, bal1) );

  if(showCommitted) {
    if(committed)
      sprintf(in+strlen(in), "  %s", floatString(floatbuf1, bal2) );
    else {
      for(i=strlen(in), j=0; j<BALANCE_LEN; i++, j++)
	in[i]=' ';
      in[i]=0;
    }
  }
}


char *transactionHeader(char *buf, int transaction_witdh, char *balance_label) {
  int number_of_float_columns=2;
  int text_length, i,j,l;
  char *p;

  p=buf;

  if( aktKontoType()==PANTEBREV ) {
    i=strlen(dateString(today()));
    for(j=0; j<i-6; j++) {
      *p=' ';
      p++;
    }
    sprintf(p, "%7s%11s%11s%11s%11s %11s", "Dato","Restgld","Rente","Afdrag","Termin","Ny restgld");
    return buf;
  }

  if( aktKontoType()==AKTIE ) {
    sprintf(buf, "Aktiekonto");
    return buf;
  }

  if(showCommitted)
    number_of_float_columns++;

  if(get_two_column())
    number_of_float_columns++;
  
  text_length=transaction_witdh-strlen(dateString(today()))-number_of_float_columns*BALANCE_LEN-1;
  
  if(get_show_all()) {
    text_length-=3;
    sprintf(p, "   ");
    p+=3;
  }

  sprintf(p, " %s", DATE1);

  for(i=strlen(p), j=0; j<strlen(dateString(today()))-strlen(DATE1); i++, j++)
    *(p+i)=' ';

  if(showTransNumbers) {
    sprintf(p+i, "%s", TRANS_NUMBER_LABEL);
    l=strlen(TRANS_NUMBER_LABEL);
    i+=l; text_length-=l;
  }
  if(showCatNumbers) {
    sprintf(p+i, "%s", CAT_NUMBER_LABEL);
    l=strlen(CAT_NUMBER_LABEL);
    i+=l; text_length-=l;
  }
  if(showCatNames) {
    sprintf(p+i, "%s", CAT_NAME_LABEL);
    l=strlen(CAT_NAME_LABEL);
    i+=l; text_length-=l;
  }
  
  if(text_length<2)
    text_length=2;
  zeroAddStrncpy(p+i, TEXT_LABEL, text_length);
  j=strlen(p+i);
  for(i=strlen(p)-1; j<text_length; j++, i++)
    *(p+i)=' ';

  p+=i;

  if( get_two_column()) {
#if WITHDRAW_COLUMN==LEFT
    sprintf(p, "%11s%11s", WITHDRAW, DEPOSIT);
#else
    sprintf(p, "%11s%11s", DEPOSIT, WITHDRAW);
#endif
  } else
    sprintf(p, "%11s", DEPOSIT_WITHDRAW);

  p+=strlen(p);

  sprintf(p, "%11s", balance_label);
  p+=strlen(p);
  
  if(showCommitted) {
    sprintf(p, "%11s", COMMIT_POST_LABEL);
  }

  return buf;
}

char **almPostStrings(void) {  /* lav tekst at vise i posterings-vindue */
  char *str, buffer[256];
  int i, j, si, k, saldoFirst=1;
  double saldo=0.0, commitSaldo=0.0;
  struct postering *p;
  Date limitFromDate, limitToDate;
  int indxFirst;

  int thisday=today();

  limitFromDate=getDisplayFromLimit();
  limitToDate=getDisplayToLimit();
  indxFirst=1;
  actualFirstIndx=0;

  si=startIndex(aktPoster->size);
  for(i=0, k=0; 
      i<aktPoster->size && k<MAX_POSTERINGER-1;
      i++) {
    p=(struct postering *)retrieve(i+1,aktPoster);
    if(saldoFirst && p->dato>thisday) {
      saldoFirst=0;
      currentSaldo=saldo;
      currentSaldoValid(currentSaldo);
    }
    saldo+=p->bel;
    if(showCommitted && p->committed)
      commitSaldo+=p->bel;
    if((antalVises!=0 && i>=si) 
       || (antalVises==0 && (limitFromDate==0 || p->dato>=limitFromDate) 
                         && (limitToDate==0   || p->dato<=limitToDate))) {
      if(indxFirst) {
	indxFirst=0;
	actualFirstIndx=i;
      }
      str=postString[k];
      if( !str )
	str=postString[k]=(char *)AllocateMemory(TRANSACTION_MAX_WIDTH);
      
      printTransaction(buffer, TRANSACTION_MAX_WIDTH-10, 
		       p->dato, p->tekst, p->bel, saldo, 
		       commitSaldo, p->committed, p->number, p->category);
      zeroAddStrncpy(str, buffer, TRANSACTION_MAX_WIDTH-1);
      k++;
    }
  }
  if(saldoFirst) {
    saldoFirst=0;
    currentSaldo=saldo;
    currentSaldoValid(currentSaldo);
  }
  
  str=postString[k];
  if(str) {
    free(str);
    postString[k]=0;
  }
  return postString;
}

char **postStrings(void) {
  int h;

  /*printf("h=%d\n", (h & 0xffff)/15 );*/

  if(antalVises!=0) {
    h=postviewh();
    antalVises=((h & 0xffff)-5)/15;
    if(antalVises<2)
      antalVises=DEFAULT_ANTAL_VISES;
  }

  freePostStrings();
  switch( aktKontoType() ) {
  case PANTEBREV:
    if(aktPoster->size<1)
      return postString;   /* skriv ingenting */
    return pantePostStrings((struct postering *)retrieve(1,aktPoster));
    break;
  case AKTIE:
    return aktiePostStrings(aktPoster);
    break;
  default:
    return almPostStrings();
    break;
  }
}

static void freePostStrings(void) {
  int i=0;
  
  return;  /* note: new approach: we don't free the memory, but reuse it */

/*  while(postString[i]) {
    free(postString[i]);
    postString[i]=0;
    i++;
  }
*/

}

void getPostAsText(int relIndx, char *dato, char *text, char *bel, 
		   char *transactionNumber, char *periodLength, 
		   char *categoryNumber, int *periodUnit) {
  struct postering *p;
  int indx;
  indx=relIndx+startIndex(aktPoster->size);
  p=(struct postering *)retrieve(indx+1, aktPoster);
  sprintf(dato, "%s", dateString(p->dato));
  sprintf(text, "%s", p->tekst);
  sprintf(bel, floatShortFormatString, p->bel);
  sprintf(transactionNumber, "%d", p->number);
  sprintf(periodLength, "%d", p->period);
  sprintf(categoryNumber, "%d", p->category);
  *periodUnit=p->unit;
}

int getPostCommit(int relIndx) {
  struct postering *p;
  int indx;
  indx=relIndx+startIndex(aktPoster->size);
  p=(struct postering *)retrieve(indx+1, aktPoster);
  return p->committed;
}

void okSletPost(int relIndx) {
  int indx;
  indx=relIndx+startIndex(aktPoster->size);
  delete_ith(indx+1, aktPoster);
}

void okSletPostAbsolut(int indx) {
  delete_ith(indx+1, aktPoster);
}

int okNyPost(int comm, char *dato, char *text, char *bel,
	     int transactionNumber, int periodLength, 
	     int periodUnit, int categoryNumber) 
                            /* return: indx of new trans., <0 if error */
{   
                          
  struct postering ny, *p;
  int i, j, antal, igang;
  char navn1[128], navn2[128], belbuf[50];
  double kurs;

  if( aktPoster->size >= MAX_POSTERINGER ) {
    xfError(WARN_MAX_TRANSACTIONS, NONFATAL, "max transactions");
  }

  zeroAddStrncpy(belbuf,bel,49);

  ny.committed=comm;
  ny.dato=parseDate(dato);
  if( ny.dato==0 ) {
    xfError(ERR_BAD_DATE, NONFATAL, "bad date");
    return -1;
  }

  zeroAddStrncpy(ny.tekst, text, POST_TEXT_LENGTH-1);
  ny.tekst[POST_TEXT_LENGTH-1]=0;

  switch( aktKontoType() ) {
  case PANTEBREV:
    delete_first(aktPoster);  /* slet postEN, saa vi sikrer, at der kun er 1 post */
    ny.bel=atof(nocomma(belbuf));
    ny.number=0;
    ny.category=0;
    ny.period=0;
    ny.unit=0;
    insert_first((BYTE *)&ny, aktPoster);
    return 0;
    break;
  case AKTIE:
    ny.number=0;
    ny.category=0;
    ny.period=0;
    ny.unit=0;
    igang=0;
    navnAntalKurs(text, navn1, &antal, &kurs);
    for(i=0; i<aktPoster->size; i++) {
      p=(struct postering *)retrieve(i+1, aktPoster);
      navnAntalKurs(p->tekst, navn2, &antal, &kurs);
      if( strcmp(navn1,navn2)!=0 ) {  /* hvis navne forskellige */
	if( igang ) {
	  insert_ith(i+1,(BYTE *)&ny, aktPoster);
	  return i;
	}
      } else {
	igang=1;
	if( p->dato>ny.dato ) {
	  insert_ith(i+1,(BYTE *)&ny, aktPoster);
	  return i;
	}
      }
    }
    insert_last((BYTE *)&ny, aktPoster);
    /* testPost(); */
    return i;
    break;
  default:
    ny.bel=atof(nocomma(belbuf));
    ny.number=transactionNumber;
    ny.period=(periodLength<1) ? 1:periodLength;
    ny.unit=periodUnit;
    ny.category=categoryNumber;
    /* printf("%d\n%s - %s\n%9.2f\n", ny.dato, ny.tekst, text, ny.bel);  */
    for(i=0; i<aktPoster->size; i++) {
      p=(struct postering *)retrieve(i+1, aktPoster);
      if( p->dato>ny.dato  /* loop variable has larger date */
                           /* or same date, smaller amount: */
	 || (p->dato==ny.dato && p->bel<ny.bel)
                           /* or same date, same amount, "larger" text: */
	 || (p->dato==ny.dato && p->bel==ny.bel && strcmp(p->tekst,ny.tekst)>0) ) {
	insert_ith(i+1,(BYTE *)&ny, aktPoster);
	return i;
      }
    }  /* "else" */
    insert_last((BYTE *)&ny, aktPoster);
    return i;
    break;
  }
}

void okRetPost(int relIndx, char *nydato, char *nytext, char *nybel,
	       int transactionNumber, int periodLength, 
	       int periodUnit, int categoryNumber) 
{ 
  int nyIndx, glIndx, commit;

  glIndx=relIndx+startIndex(aktPoster->size);
  commit=getPostCommit(relIndx);
  nyIndx=okNyPost(commit, nydato, nytext, nybel,  /* create new trans. */
		  transactionNumber, periodLength, periodUnit, categoryNumber);  
  if(nyIndx>=0) {               /* if no errors */
    if(nyIndx>glIndx) 
                /* hvis posten er indsat laengere nede i kontoen, end den
		   var foer */
       okSletPostAbsolut(glIndx);
    else
                /* posten er indsat laengere oppe eller samme sted som foer */
       okSletPostAbsolut(glIndx+1);
  }
}

void insertHeaderFile(FILE *to, FILE *from) {
  char buf[256];
  while( fgets(buf, 256, from) )
    fputs(buf, to);
}

void header(FILE *f, int pageNum) {
  char pbuf[128];

  setFontSize(f, "Times-ISO", 12);
  sprintf(pbuf, "%s %d", PAGE, pageNum);
  skrivXY(f, PAGE_X, PAGE_Y, pbuf);

  sprintf(pbuf, "%s %s", NUMBER, getKontoNr(aktKonto()));
  skrivXY(f, TEXT_X, PAGE_Y, pbuf);
  
  fprintf(f, "\nxfinans\n");
  setFontSize(f, "Times-ISO", 30);
  skrivOutlineXY(f, 1.1, 2.7, getKontoName(aktKonto()));
  setFontSize(f, "Times-ISO", 12);
  skrivXY(f, DATO_X1, TOP_MARGIN-0.8, DATE1);
  if( showTransNumbers ) {
    skrivXY(f, TEXT_X, TOP_MARGIN-0.8, TRANS_NUMBER_LABEL);
    skrivXY(f, TEXT_X+TRANS_NUM_WIDTH, TOP_MARGIN-0.8, TEXT_LABEL);
  }
  else
    skrivXY(f, TEXT_X, TOP_MARGIN-0.8, TEXT_LABEL);
  /* skrivXY(f, BEL_X, TOP_MARGIN-0.8, DEPOSIT_WITHDRAW); */
  skrivXY(f, SALDO_X-1.5, TOP_MARGIN-0.8, BALANCE_LABEL);
}

void udskriv(int dato) {
  int i, j, firstLine=1;
  double saldo=0.0, committedsaldo=0.0;
  struct postering *p;
  char buf[256];

  FILE *f, *hf;

  if(getPS()) {        /* if PostScript */
    if( (hf=fopen("xfin.ps", "r"))==NULL ) {
      xfError(ERR_NO_HEADER, NONFATAL, "no PS header");
      return;
    }
    f=fopen("xf.ps", "w");
    if( f==NULL ) {
      xfError(ERR_CANT_WRITE_FILE, NONFATAL, "can't write");
      fclose(hf);
      return;
    }
    
    insertHeaderFile(f,hf);
    fclose(hf);
    
    initPS(f);
    /*setSize(f,11);*/
    
    for(i=0; i<aktPoster->size; i++) {
      p=(struct postering *)retrieve(i+1,aktPoster);
      saldo+=p->bel;
      
      if( p->dato>=dato ) {
	if( firstLine && dato>0 ) {
	  firstLine=0;
	  setFontSize(f, "Times-ISO", 11);
	  sprintf(buf, "%s", dateString(dato) );
	  skrivRJ(f, DATO_X, buf);
	  skriv(f, TEXT_X, BALANCE_LABEL);
	  floatString(buf, saldo-p->bel);  /* bel skal lige traekkes fra igen */
	  skrivRJ(f, SALDO_X, buf);
	  newLine(f);
	}
	setFontSize(f, "Times-ISO", 11);
	sprintf(buf, "%s", dateString(p->dato) );
	skrivRJ(f, DATO_X, buf);
	if(showTransNumbers) {
	  sprintf(buf, TRANSACTION_NUMBER_FORMAT, p->number);
	  skriv(f, TEXT_X, buf);
	  skriv(f, TEXT_X+TRANS_NUM_WIDTH, p->tekst);
	}
	else
	  skriv(f, TEXT_X, p->tekst);
	
	floatString(buf, p->bel);

	if(get_two_column() && p->bel<0.0)
	  skrivRJ(f, NEG_AMOUNT_X, buf);
	else
	  skrivRJ(f, BEL_X, buf);
	
	floatString(buf, saldo);
	skrivRJ(f, SALDO_X, buf);
	newLine(f);
      }
    }
    if( anyLinesPrintedOnCurrentPage() )
      showpage(f);
    exitPS(f);
    fclose(f);
    sprintf(buf, "%s xf.ps", getPrintCommand());
    system(buf);
    /* printf("%s\n", buf); */
  }
  else {                    /* NOT PostScript */
    f=fopen("xf.txt", "w");
    if( f==NULL ) {
      xfError(ERR_CANT_WRITE_FILE, NONFATAL, "can't write");
      return;
    }

    fprintf(f, " %s, %s %s\n\n", POSTING_LIST, getKontoName(aktKonto()), 
	                                  getKontoNr(aktKonto()));

    fprintf(f, "  %s\n", transactionHeader(buf, 77, BALANCE_LABEL) );

    for(i=0; i<aktPoster->size; i++) {
      p=(struct postering *)retrieve(i+1,aktPoster);
      saldo+=p->bel;
      if(p->committed)
	committedsaldo+=p->bel;
      
      if( p->dato>=dato ) {
	if( firstLine && dato>0 ) {
	  firstLine=0;
	  printTransaction(buf, 77, dato, BALANCE_LABEL, saldo-p->bel, 
			   saldo-p->bel, saldo-p->bel, 1,0,0);
	  
	  fprintf(f, " %s\n", buf);
	}
	printTransaction(buf, 77, p->dato, p->tekst, p->bel, 
			 saldo, committedsaldo, p->committed, 
			 p->number, p->category);
	
	fprintf(f, " %s\n", buf);
      }
    }
    fclose(f);
    sprintf(buf, "%s xf.txt", getPrintCommand());
    system(buf); 
    /* printf("%s\n", buf); */
  }
} 

double okRente(long d1, long d2, double f1, double f2) {
  return rente(aktPoster, d1, d2, f1, f2);
}

void defaultLimitPosts(void) {
/*  antalVises=DEFAULT_ANTAL_VISES;*/
  int h;

  h=postviewh();
  antalVises=(h & 0xffff)/15;

  if( antalVises<2 )
    antalVises=DEFAULT_ANTAL_VISES;
}

void noLimitPosts(void) {
  antalVises=0;
}

char **searchStrings(char *res[], int maxlines, char *word, char *sort) {
  char buf[256], buf2[256], floatbuf1[32], floatbuf2[32];
  char *str;
  int i, j, k;
  double saldo=0.0, commitSaldo=0.0;
  struct postering *p;
  struct postering **d;

  d=(struct postering **)AllocateMemory(
		         (aktPoster->size+1)*sizeof(struct postering *));

  for(i=0, k=0; i<aktPoster->size && k<maxlines-1; i++) {
    p=(struct postering *)retrieve(i+1,aktPoster);
    if( cistrstr(p->tekst, word) ) {
      d[k]=p;
      k++;
    }
  }
  multiSort(d,0,k-1,order_of(sort[0]),0,strlen(sort)-1,sort);

  for(i=0; i<k; i++) {
    p=d[i];
    saldo+=p->bel;
    if(p->committed)
      commitSaldo+=p->bel;
    str=res[i];
    if( !str )
      str=res[i]=(char *)AllocateMemory(TRANSACTION_MAX_WIDTH);
    
    printTransaction(buf, TRANSACTION_MAX_WIDTH-13, 
		     p->dato, p->tekst, p->bel, saldo, 
		     commitSaldo, p->committed, p->number, p->category);
    zeroAddStrncpy(str, buf, TRANSACTION_MAX_WIDTH-1);
  }

  if(res[k])
    free(res[k]);
  res[k]=0;
  free(d);

  return res;
}

int writePlotData(long fra, long til, FILE *f) {
  int i, j;
  int dage, antal=0, first=1;
  long last, thisDate=0;
  double saldo=0.0, oldsaldo=0.0, thisSaldo=0.0;
  struct postering *p;

  last=fra;

  for(i=0; i<aktPoster->size; i++) {
    p=(struct postering *)retrieve(i+1,aktPoster);
    saldo+=p->bel;
    if(last==0)
      last=p->dato;
    if( fra==0 || (fra!=0 && p->dato>=fra) ) {
      if( til==0 || (til!=0 && p->dato<=til) ) {
	if( first ) {
	  if( fra!=0 && fra!=p->dato ) {
	    antal++;
	    fprintf(f, "%d %9.2f\n", 0, oldsaldo);
	  }
	  first=0;
	} 
	thisDate=p->dato;
	thisSaldo=saldo;
	antal++;
	fprintf(f, "%d %9.2f\n", rentedage(last, p->dato), saldo);
      }
    }
    oldsaldo=saldo;
  }

  if( til>thisDate ) {
    antal++;
    fprintf(f, "%d %9.2f\n", rentedage(last, til), thisSaldo);
  }
  return antal;
}

int invertShowCommitted() {
  showCommitted=!showCommitted;
  return showCommitted;
}

void doCommit(int relIndx) {
  struct postering *p;
  int indx;
  indx=relIndx+startIndex(aktPoster->size);
  p=(struct postering *)retrieve(indx+1, aktPoster);

  p->committed=!p->committed;
  if(showCommitted)
    opdaterPostList();
  saveKonto();
}

double computeAverage(long fromDate, long toDate) {
  return averageBalance(aktPoster, fromDate, toDate);
}

void toggle_set_zero(void) {
  int i, indx, date;
  struct postering *p;

  i=indxOfPostSelection();

  if( set_zero && i<0 )
    set_zero=0;
  else if( set_zero && i>=0 )
    set_zero=1;
  else if( !set_zero && i<0 ) {
    xfError(ERR_DO_CLICK_POSTING, NONFATAL, "contents");
    return;
  }
  else if( !set_zero && i>=0 )
    set_zero=1;
  
  updateMarkWithText(SET_ZERO, set_zero);

  if(set_zero && i>=0 ) {
    indx=i+startIndex(aktPoster->size);
    p=(struct postering *)retrieve(indx+1, aktPoster);
    deltaZeroBalance=calculateBalanceAt(p->dato);
  } else {
    deltaZeroBalance=0.0;
  }
  opdaterPostList();
}

void unset_zero(void) {
  set_zero=0;
  updateMarkWithText(SET_ZERO, set_zero);
  deltaZeroBalance=0.0;
}
