/* $Id: search.c,v 4.7 1995/09/11 16:05:22 lupus Exp lupus $ */

#include <string.h>

#include "searchp.h"
#include "search.h"
#include "saldo.h"
#include "post.h"
#include "plot.h"
#include "xfError.h"
#include "country.h"
#include "programConfig.h"
#include "str.h"
#include "focus.h"

#define MAXLI 1000
#define SEA_BUTW 60

#define SEARCH_HEIGHT 280
#define SEARCH_WIDTH  455
#define SEARCH_TEXT_WIDTH  275

Widget searchShell, searchPane, searchBox, searchBox2,
  searchTextLabel, searchTextIn, searchSortLabel, searchSortIn, 
  searchClearText, searchClearSort, 
  searchHeaderLabel,
  searchViewp, searchList,
  searchOk,
  searchClose;

static char *searchStr[MAXLI];
static int popup=0;

int searchIsPopup(void) {
  return popup;
}

searchInit(void) {
  int i;
  for(i=0; i<MAXLI; i++)
    searchStr[i]=0;
}

searchFree(void) {  /* New strategy: reuse */
/*
  int i=0;
  while(searchStr[i] && i<MAXLI) {
    free(searchStr[i]);
    searchStr[i]=0;
    i++;
  }
*/
}

void opdaterSearchList(void) {
  String p;
  char text[256], sort[256];

  if(!popup)
    return;  

  XtVaSetValues(searchHeaderLabel,
		XtNlabel, transactionHeader(text, 69, SUM_LABEL),
		NULL);

  XtVaGetValues(searchTextIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(text,p,255);

  XtVaGetValues(searchSortIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(sort,p,255);

  searchFree();
  XawListChange(searchList, searchStrings(searchStr,MAXLI,text,sort), 0,0, TRUE);
}

static void ClearEntry(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget putIn;

  putIn=(Widget) client_data;

  XtVaSetValues(putIn, 
		XtNstring, "",
		NULL); 
}

void createSearchWidgets(void) {
  static int done=0;
  char buf[256];

  if(done)
    return;
  done=1;

  searchInit();

  searchShell = XtVaCreatePopupShell (
				      "searchShell",
				      transientShellWidgetClass,
				      topLevel,
				      XtNtitle, FUNCTIONS_TITLE,
				      XtNx,0,
				      XtNy,130,
				      NULL );
  
  searchPane = XtVaCreateManagedWidget(
				       "searchPane",
				       panedWidgetClass,
				       searchShell,
				       XtNheight, SEARCH_HEIGHT,
				       XtNwidth, SEARCH_WIDTH,
				       NULL);
  
  searchBox = XtVaCreateManagedWidget(
				   "searchBox",
				   boxWidgetClass,
				   searchPane,
				   NULL);

  searchClose = XtVaCreateManagedWidget(
				     "searchClose",
				     commandWidgetClass,
				     searchBox,
				     XtNlabel, CLOSE,
				     XtNwidth, SEA_BUTW,
				     NULL);

  searchOk = XtVaCreateManagedWidget(
				     "searchOk",
				     commandWidgetClass,
				     searchBox,
				     XtNlabel, SEARCH_LABEL,
				     XtNwidth, SEA_BUTW,
				     NULL);
  
  searchBox2 = XtVaCreateManagedWidget(
				   "searchBox2",
				   boxWidgetClass,
				   searchPane,
				   NULL);

  searchTextLabel = XtVaCreateManagedWidget(
				 "searchTextLabel",
				 labelWidgetClass,
				 searchBox2,
				 XtNlabel, SEARCH_EXPR,
				 NULL);
  
  searchTextIn = XtVaCreateManagedWidget(
				     "searchTextIn",
				     asciiTextWidgetClass,
				     searchBox2,
				     XtNeditType, XawtextEdit,
				     XtNwidth, SEARCH_TEXT_WIDTH,
				     NULL);

  searchClearText = XtVaCreateManagedWidget(
				     "searchClearText",
				     commandWidgetClass,
				     searchBox2,
				     XtNlabel, CLEAR_LABEL,
				     XtNwidth, SEA_BUTW,
				     NULL);

  searchSortLabel = XtVaCreateManagedWidget(
				 "searchSortLabel",
				 labelWidgetClass,
				 searchBox2,
				 XtNlabel, SORT_EXPR,
				 NULL);
  
  searchSortIn = XtVaCreateManagedWidget(
				     "searchSortIn",
				     asciiTextWidgetClass,
				     searchBox2,
				     XtNeditType, XawtextEdit,
				     XtNwidth, SEARCH_TEXT_WIDTH,
				     XtNstring, DEFAULT_SORT_STRING,
				     NULL);

  searchClearSort = XtVaCreateManagedWidget(
				     "searchClearSort",
				     commandWidgetClass,
				     searchBox2,
				     XtNlabel, CLEAR_LABEL,
				     XtNwidth, SEA_BUTW,
				     NULL);

  searchHeaderLabel = XtVaCreateManagedWidget(
				 "searchHeaderLabel",
				 labelWidgetClass,
				 searchPane,
				 XtNlabel, transactionHeader(buf, 74, SUM_LABEL),
  			         XtNmin, (Dimension)25,
				 XtNmax, (Dimension)25,
				 NULL);

  searchViewp = XtVaCreateManagedWidget(
                                  "searchViewp",
                                  viewportWidgetClass,
                                  searchPane,
                                  XtNheight, 65,
                                  /* XtNwidth, 220, */
                                  XtNallowVert, TRUE,
                                  NULL);
 
  searchList = XtVaCreateManagedWidget(
				       "searchList",
				       listWidgetClass,
				       searchViewp,
				       /* XtNlist, searchStrings(searchStr,MAXLI,"",DEFAULT_SORT_STRING), */
				       XtNlist, searchStr,
				       XtNheight, 65,
				       XtNdefaultColumns, 1,
				       XtNpasteBuffer, TRUE,
				       XtNforceColumns, TRUE,
  				       NULL);
  
  saveFocusInfo(searchTextIn, searchSortIn, searchPane, searchOk, 1);
  saveFocusInfo(searchSortIn, searchTextIn, searchPane, searchOk, 0);
  
  addSearchCallBack();
}

void addSearchCallBack(void) {
  XtAddCallback(searchClose, XtNcallback, SearchClose, topLevel);
  XtAddCallback(searchOk, XtNcallback, SearchOk, topLevel);
  XtAddCallback(searchClearText, XtNcallback, ClearEntry, searchTextIn);
  XtAddCallback(searchClearSort, XtNcallback, ClearEntry, searchSortIn);
}

/* ========================================================== */     
void SearchPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  if( !popup ) {
    createSearchWidgets();

    XtPopup(searchShell, XtGrabNone);
    popup=1;
    opdaterSearchList();
    updateMarkWithText(SEARCH_LABEL,popup);
    jumpTo(searchTextIn);
  }
  else {
    XtPopdown(searchShell);
    popup=0;
    updateMarkWithText(SEARCH_LABEL,popup);
  }
}

void SearchOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
/*
  if( strlen(text)==0 ) {
    xfError(ERR_NO_WORD, NONFATAL, "search");
    return;
  }
*/

  /* searchFree(); */
  opdaterSearchList();
}

void SearchClose(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(searchShell);
  popup=0;
  updateMarkWithText(SEARCH_LABEL,popup);
}
