/*
 * Copyright (c) 1995, 1996, 1997, 2000, Mark Buser.
 * Copyright (c) 2001, 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/drawing.c,v 2.14 2003/11/20 20:12:35 danny Exp $
 */

static char id[] = "$Header: /pack/anoncvs/xinvest/src/drawing.c,v 2.14 2003/11/20 20:12:35 danny Exp $";

#include <Xm/Xm.h>
#include <Xm/DrawingA.h>

#include "drawing.h"
#include "functions.h"
#include "graph.h"
#include "pixmap.h"
#include "portfolio.h"
#include "status.h"
#include "xutil.h"

#include "xinvest.h"

static Widget Graph;
static int last_graph = PLOT;

void setDrawingArea (Widget w)
{
	Graph = w;
}

void setLastGraph (int which)
{
	last_graph = which;
}

/* Convenience function so we don't have to have a handle to Graph. */
void drawDrawingArea ()
{
	if (XtIsRealized(Graph))
		redrawDrawing(Graph, (XtPointer)NULL, (XtPointer)NULL);
}

/* ARGSUSED */
void redrawDrawing (Widget Drawing, XtPointer data, XtPointer cbs)
{
	static Pixmap		Drawpixmap = (Pixmap )NULL;
	static Display		*dpy;
	static Dimension	pixheight, pixwidth;

	Dimension		height, width;
	Pixel			background, foreground;
	GC			gc;

	static int		firsttime = 1;

	/* Check whether this is about the current display */
	if (XtDisplay(Drawing) != per->dpy)
		return;

	/* This may take a while */
	if (per->Toplevel)
		setBusyCursor( Graph, True );       

	if (firsttime) {
		/*
		 * Turn off drawing area widget gravity so smaller windows
		 * generate expose events.
		*/
		XSetWindowAttributes attrs;
		unsigned long mask = CWBitGravity;
		attrs.bit_gravity = ForgetGravity;

		XChangeWindowAttributes(XtDisplay(Drawing), XtWindow(Drawing),
			mask, &attrs);

		/* FIX ME this stinks in a multi-display environment */
		firsttime = 0;
	}

	XtVaSetValues (Drawing, XmNunitType, XmPIXELS, NULL);

	/* Allocate colors - different for window/printer */
#ifdef	XPRINT
	if (per->pctxt) {	/* Print */
		foreground = per->color[13];
		background = per->color[14];
	} else
#endif
	{
		XtVaGetValues (Drawing,
			XmNbackground, &background,
			XmNforeground, &foreground,
		NULL );
	}

	XtVaGetValues (Drawing,
		XmNheight,     &height,
		XmNwidth,      &width,
		XmNuserData,   &gc,
	NULL );

	/*
	** Make or resize pixmap if necessary
	**
	*/

	/* There is no pixmap */
	if (Drawpixmap == (Pixmap)NULL) {
		Drawpixmap = XCreatePixmap(XtDisplay(Drawing),
			RootWindowOfScreen(XtScreen(Drawing)),
			width, height,
			DefaultDepthOfScreen(XtScreen(Drawing)));
		dpy = XtDisplay(Drawing);

		/* Pixmap has different size */
	} else if (pixheight != height || pixwidth  != width) {
		/* destroy old pixmap */
		XFreePixmap(dpy, Drawpixmap);

		/* make a new one at adjusted size */
		dpy = XtDisplay(Drawing);
		Drawpixmap = XCreatePixmap(XtDisplay(Drawing),
			RootWindowOfScreen(XtScreen(Drawing)),
			width, height,
			DefaultDepthOfScreen(XtScreen(Drawing)));
	}

	/* 
	** Suppress errors on expose only. 
	*/
	if (pixheight == height && pixwidth == width) /* Is this a resize? */
		suppress((int)data == 1);                /* Expose or user update */

	pixheight = height;
	pixwidth = width;

	/*  Clear pixmap with background color */
	XSetForeground(XtDisplay (Drawing), gc, background);
	XFillRectangle(XtDisplay (Drawing), Drawpixmap, gc, 0, 0, pixwidth, pixheight);

	XSetForeground(XtDisplay (Drawing), gc, foreground);

	XSetLineAttributes(XtDisplay(Drawing), gc, 2, LineSolid, CapNotLast, JoinBevel);

	if (last_graph == PLOT && getVActive()) {
		/* Plot, if it was last selected */
		plot(Drawing, Drawpixmap, gc);
	} else if ( last_graph == PORTFOLIO && getPActive() ) {
		/* Portfolio, if it was last selected */
		pie(Drawing, Drawpixmap, gc);
	} else {
		/*
		** No plots selected, they get the booby prize
		**
		*/
		XSetTile(XtDisplay(Drawing), gc, GetPixmap(PSTIPPLE, NORMAL, XtDisplay(Drawing)));
		XSetFillStyle( XtDisplay (Drawing), gc, FillTiled);
		XFillRectangle(XtDisplay (Drawing), Drawpixmap, gc, 0, 0, pixwidth, pixheight);
		XSetFillStyle( XtDisplay (Drawing), gc, FillSolid);
	}

	if (last_graph == FUNCCALC) {
		/* Just write performance data over logo background */
		draw_funccalc ( Drawing, Drawpixmap, gc );
	}

	/* All errors enabled */
	suppress (False);  

	XCopyArea ( XtDisplay(Drawing), Drawpixmap, XtWindow (Drawing),
		gc, 0, 0, pixwidth, pixheight, 0, 0 );

	if (per->Toplevel)
		setBusyCursor( Graph, False );
}
