/*
 * Copyright (c) 1996, 1997, 1998, Mark Buser.
 * Copyright (c) 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/edit.c,v 2.5 2003/11/19 19:35:10 danny Exp $
 */
#include <Xm/XmAll.h>

#include "pref.h"
#include "status.h"

/* ARGSUSED */
void editCB( Widget w, XtPointer client_data, XtPointer call_data)
{
  int result = True;
  int reason = (int) client_data;
  XEvent *event = ((XmPushButtonCallbackStruct *) call_data)->event;
  Time when;

  extern Widget Transtext;

  if (event != NULL) {
    switch (event->type) {
      case ButtonRelease:
                            when = event->xbutton.time;
                            break;
      case KeyRelease:
                            when = event->xkey.time;
                            break;
      default:
                            when = CurrentTime;
                            break;
    }
  }

  switch (reason) {
    case 0:
             result = XmTextCopy (Transtext, when);
             break;
    case 1:
             result = XmTextCut (Transtext, when);
             break;
    case 2:
             result = XmTextPaste (Transtext);
             break;
    case 3:  result = True;
             prefPostPreference();
    default:
             break;
  }
  
  if (result == False)
    write_status ("Edit failed, no selection?\n"
                  "Source or destination must be\n"
                  "transaction window.", ERR);
}

/* ARGSUSED */
void editSelectionCB( Widget w, XtPointer client_data, 
                  XmAnyCallbackStruct *call_data)
{
  extern Widget Editmenu;
  Widget cut, copy;
  XmTextPosition left, right;

  int enable = False;

  switch (call_data->reason ) {
    case XmCR_GAIN_PRIMARY:
         enable = True;
         break;
    case XmCR_LOSE_PRIMARY:
         enable = False;
         break;
    case XmCR_MOVING_INSERT_CURSOR:
         if (XmTextGetSelectionPosition (w, &left, &right))
           if (left != right)
             enable = True;
         break;
  }

  cut = XtNameToWidget ( Editmenu, "button_0");
  if (cut)
    XtSetSensitive ( cut, enable );
  copy = XtNameToWidget ( Editmenu, "button_1");
  if (copy)
    XtSetSensitive ( copy, enable );
  
}
