/*
 * Copyright (c) 1996, Mark Buser.
 * Copyright (c) 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/nav.c,v 2.5 2003/11/14 19:45:25 danny Exp $
 */
#include <stdio.h>
#include <Xm/Xm.h>

#include "account.h"
#include "nav.h"
#include "trans.h"


/* Are the current parameters the same as the last transaction? */
int isNavChanged( int account, NAV *nav)
{
  char date[11];
  long strtoday(char *);

  int numTrans;
  void *trans;

  getAccount( account, ACCOUNT_NUM_TRANS, &numTrans );
  getAccount( account, ACCOUNT_TRANS, &trans );

  if ( trans == NULL || numTrans == 0)      /* just in case */
    return False;

  sprintf( date, "%d/%d/%d", nav->month, nav->date, nav->year);

  if ( (float)(nav->value) - (float)GetTransNav (trans, numTrans) != (float)0.0 
       || strtoday(date) != GetTransLDate(trans, numTrans) )
     return True;
  else
     return False;
}

void setNav (NAV *nav, int field, void *val)
{

  if (nav) {

    switch (field) {
      case NAV_VALUE:
          nav->value = (float) *(double *)val;
          break;

      case NAV_MONTH:
          nav->month = *(int *)val;
          break;

      case NAV_DAY:
          nav->date = *(int *)val;
          break;

      case NAV_YEAR:
          nav->year = *(int *)val;
          break;

      case NAV_DATE:
          sscanf ( (char *)val, "%2d/%2d/%4d", 
                   &(nav->month), &(nav->date), &(nav->year) );
          break;
    }
  }
}

void getNav (NAV *nav, int field, void *val)
{
  if (nav) {

    switch (field) {
      case NAV_VALUE:
          *(float *)val = nav->value;
          break;

      case NAV_MONTH:
          *(int *)val = nav->month;
          break;

      case NAV_DAY:
          *(int *)val = nav->date;
          break;

      case NAV_YEAR:
          *(int *)val = nav->year;
          break;
    }
  }
}

long navToLDate ( NAV *navp )
{
  extern long strtoday (char *);
  char currentDate[11];

  sprintf( currentDate, "%2d/%2d/%2d", navp->month, navp->date, navp->year);
  return ( strtoday(currentDate) );
}
