/*
 * Copyright (c) 2001, Mark Buser.
 * Copyright (c) 2002, 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/xinvestP.h,v 2.3 2003/11/19 19:35:13 danny Exp $
 */
#ifndef XINVESTP_H
#define XINVESTP_H

static XtResource resources [] = {
  {
     XmNfontList,
     XmCFontList,
     XmRFontList,
     sizeof( XmFontList ),
     XtOffsetOf ( AppData, graph_font_list),
     XtRString,
     XmNdefaultFontList
  },
  {
     "printFontList",
     XmCFontList,
     XmRFontList,
     sizeof(XmFontList),
     XtOffsetOf(AppData, print_font_list),
     XtRString,
     XmNdefaultFontList
  },
  {
     "install",
     "Install",
     XmRBoolean,
     sizeof(Boolean),
     XtOffsetOf ( AppData, install),
     XmRImmediate,
     False
  },
  {
     "help",
     "Help",
     XmRBoolean,
     sizeof(Boolean),
     XtOffsetOf ( AppData, help),
     XmRImmediate,
     False
  },
  {
     "color0",
     "Color0",
     XmRString,
     sizeof(String),
     XtOffsetOf(AppData, color0),
     XmRImmediate,
     False
  },
  {
     "color1",
     "Color1",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, color1),
     XmRImmediate,
     False
  },
  {
     "color2",
     "Color2",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, color2),
     XmRImmediate,
     False
  },
  {
     "color3",
     "Color3",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, color3),
     XmRImmediate,
     False
  },
  {
     "color4",
     "Color4",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, color4),
     XmRImmediate,
     False
  },
  {
     "color5",
     "Color5",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, color5),
     XmRImmediate,
     False
  },
  {
     "color6",
     "Color6",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, color6),
     XmRImmediate,
     False
  },
{
     "color7",
     "Color7",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, color7),
     XmRImmediate,
     False
  },
  {
     "colorRed",
     "ColorRed",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, colorRed),
     XmRImmediate,
     False
  },
  {
     "colorGreen",
     "ColorGreen",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, colorGreen),
     XmRImmediate,
     False
  },
  {
     "colorGrey",
     "ColorGrey",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, colorGrey),
     XmRImmediate,
     False
  },
  {
     "colorWhite",
     "ColorWhite",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, colorWhite),
     XmRImmediate,
     False
  },
  {
     "colorBlack",
     "ColorBlack",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, colorBlack),
     XmRImmediate,
     False
  },
  {
     "colorPrintBackground",
     "ColorPrintBackground",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, colorPrintBackground),
     XmRImmediate,
     False
  },{
     "colorPrintForeground",
     "ColorPrintForeground",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, colorPrintForeground),
     XmRImmediate,
     False
  },{
     "colorPrintIllustrations",
     "ColorPrintIllustrations",
     XmRString,
     sizeof(String),
     XtOffsetOf ( AppData, colorPrintIllustrations),
     XmRImmediate,
     False
  },{
     "restore",
     "Restore",
     XmRString,
     sizeof(char *),
     XtOffsetOf ( AppData, restore),
     XmRImmediate,
     NULL
  },{
     "maxaccounts",
     "Maxaccounts",
     XmRInt,
     sizeof(int),
     XtOffsetOf(AppData, maxaccounts),
     XmRImmediate,
     (XtPointer)10
  },
};

/* Application defined options */
static XrmOptionDescRec options [] = {
  {
     "-install", "install", XrmoptionNoArg, "True"
  },
  {
     "-help", "help", XrmoptionNoArg, "True"
  },
  {
     "-restore", "restore", XrmoptionSepArg, NULL
  }
};

#endif
