/*  window_menu.cc
 *     ɥΥ˥塼κȡ٥Ƚ
 */
/*
 *
 *  Copyright (C) 2000-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#include <gtk--/menu.h>
#include <gtk--/menushell.h>
#include <gtk--/menuitem.h>
#include <gtk--/radiomenuitem.h>
#include <gtk--/label.h>
#include <vector>
#include <stdio.h>
#include <unistd.h>
#include "window.h"

#define WINDOW_MENU_DEBUG

/* ХåΥ˥塼ɽʤ */
#ifdef WITH_BACKLOG
#undef WITH_BACKLOG
#endif

using namespace Gtk::Menu_Helpers;
using namespace SigC;

/**********************************************
**
** ֡ѤΥ˥塼ɥ
** ѾƼºݤΥ˥塼ˤʤ
**
***********************************************
*/
class AyuWin_FileMenu : public Gtk::Menu {
	int item_deal; // ˥塼ο
	char* menu_string; // ˥塼ʸ(֤)
	virtual void exec_cmd(int num) = 0; // ºݤ˼¹Ԥ륳ޥ
public:
	AyuWin_FileMenu(int _deal, char* str);
	// ˥塼ɽʸʥʤɡ
	void SetString(char** strlist);
};

// AyuWin_FileMenu μ
class AyuWin_SaveMenu : public AyuWin_FileMenu {
	AyuWindow* main_window;
	void exec_cmd(int num);
public:
	AyuWin_SaveMenu(int deal, AyuWindow* parent) :
		AyuWin_FileMenu(deal, "Save") , main_window(parent){};
};

class AyuWin_LoadMenu : public AyuWin_FileMenu {
	AyuWindow* main_window;
	void exec_cmd(int num);
public:
	AyuWin_LoadMenu(int deal, AyuWindow* parent) :
		AyuWin_FileMenu(deal, "Load"), main_window(parent) {};
};

// deal ĤΥ˥塼Ĥ
AyuWin_FileMenu::AyuWin_FileMenu(int deal, char* str) {
	item_deal = deal;
	char* gstr = gettext(str);
	menu_string = new char[strlen(gstr)+1]; strcpy(menu_string, gstr);
	MenuList& list = items();
	int i;
	// ˥塼äƤ
	for (i=0; i<deal; i++) {
		// ֥˥塼Ĥ
		Gtk::Menu* submenu = manage(new Gtk::Menu());
		MenuList& sublist = submenu->items();
		sublist.push_back(MenuElem(menu_string, SigC::bind<int>( SigC::slot(this, &AyuWin_FileMenu::exec_cmd), i) ));

		sublist.push_back(MenuElem(gettext("Cancel")));
		// ʬ˲ä
		list.push_back(MenuElem("", *submenu));
	}
}

// ֥եΥȥʸΥå
void AyuWin_FileMenu::SetString(char** strlist) {
	int i; char buf[1024];
	int deal2 = 0; for (; strlist[deal2] != 0; deal2++) ;
	if (deal2 > item_deal) deal2 = item_deal; // ʸο˥塼ο¤
	MenuList::iterator it = items().begin();
	// ˥塼ʸѤƤ
	for (i=0; i<deal2; i++) {
		Gtk::MenuItem* item = *it++;
		// item  label ʤСlabelΤϤʤɡʸѹ
		if (item->get_child() != 0 && Gtk::Label::isA( item->get_child()) ) {
			Gtk::Label* lb = (Gtk::Label*)(item->get_child());
			kconv( (unsigned char*)strlist[i], (unsigned char*)buf);
			if (strcmp(buf, lb->get_text().c_str()) != 0) {
				lb->set_text(buf);
			}
		}
	}
}
extern void SaveFile(int no);
void AyuWin_SaveMenu::exec_cmd(int no) {
	SaveFile(no);
}
void AyuWin_LoadMenu::exec_cmd(int no) {
	main_window->local_system.SetLoadData(no);
}

/**********************************************
**
** ˥塼ɥ
**
***********************************************
*/
class AyuWin_Menu : public Gtk::MenuBar {
	AyuWindow* main_window;
	Gtk::Menu* fileMenu;
	Gtk::Menu* optionMenu;
	Gtk::Menu* backlogMenu;
	Gtk::Menu* popupMenu;
	Gtk::Menu* backlogPopupMenu;
	Gtk::Menu* current_popup;
	vector<Gtk::MenuItem*> titleItems;
	AyuWin_LoadMenu* loadMenu;

	/* file menu , popup menu  save /load menu */
	AyuWin_LoadMenu* file_loadMenu;
	AyuWin_SaveMenu* file_saveMenu;
	AyuWin_LoadMenu* popup_loadMenu;
	AyuWin_SaveMenu* popup_saveMenu;

	/* file menu λҶ */
	Gtk::Menu* file_drawMenu;
	Gtk::Menu* popup_drawMenu;
	Gtk::Menu* file_sysMenu;
	Gtk::Menu* popup_sysMenu;
	Gtk::Menu* file_endMenu;
	Gtk::Menu* popup_endMenu;
	Gtk::Menu* popup2_endMenu;
	/* option menu λҶ */
	Gtk::Menu* option_textspeedMenu;
	Gtk::Menu* popup_textspeedMenu;
	Gtk::Menu* option_grpfastMenu;
	Gtk::Menu* popup_grpfastMenu;
	Gtk::Menu* option_koeMenu;
	Gtk::Menu* popup_koeMenu;
	Gtk::Menu* option_textbackMenu;
	Gtk::Menu* popup_textbackMenu;
	Gtk::Menu* option_textskipMenu;
	Gtk::Menu* popup_textskipMenu;

	// file menu Ĥ
	void CreateFileMenu(void);
	// option menu Ĥ
	void CreateOptionMenu(void);
	// popup menu Ĥ
	void CreatePopupMenu(void);
	// load menu Ĥ
	void CreateLoadMenu(void);
	// backlog menu Ĥ
	void CreateBacklogMenu(void);
	// backlog  popup menu Ĥ
	void CreateBacklogPopupMenu(void);
	
	// file menu λҶĤ
	void CreateFileSubMenu(void);
	// option menu λҶĤ
	void CreateOptionSubMenu(void);

	static void SearchMenu(vector<Gtk::MenuItem*>& ret_list, Gtk::Menu* menu, const char* name);
	vector<Gtk::MenuItem*> SearchMenu(const char* name);

	/* widget ˴ޤޤ label ѹ */
	static void ChangeName(Gtk::Widget& widget, const char* old_name, const char* new_name);
	static void ChangeMenuName(Gtk::Menu* menu, const char* old_name, const char* new_name);
public:
	void ChangeMenuName(const char* old_name, const char* new_name);
	/* widget  name ޤޤƤ뤫򸡺 */
	/* ޤޤƤ 1, ʤ 0 ֤ */
	static int CheckName(Gtk::Widget* widget, const char* name);

	// menu  menuitem õ
	AyuWin_Menu(AyuWindow* parent);
	void Update(char** menu_list); // ֡ɥ˥塼դä
	// popup menu ɽ
	void Popup(void);
	// popup menu 
	void SetCurrentPopup(int i) {
		if (i == 0) current_popup = popupMenu;
		else if (i==1) current_popup = backlogPopupMenu;
	}
	// load menu  popup ɽ
	void PopupLoad(void);
	// ȥ
	void SetTitle(char* title);

	// menu  enable / disable
	void SetSensitive(vector<Gtk::MenuItem*> items, int mode) {
		vector<Gtk::MenuItem*>::iterator it;
		for (it=items.begin(); it!=items.end(); it++) {
			if (mode) {(*it)->set_sensitive(1); }
			else { (*it)->set_sensitive(0); }
		}
	}
	void SetSensitive(const char* menu_name, int mode) {
		deselect();
		main_window->activate_focus();
		SetSensitive(SearchMenu(menu_name), mode);
	}
	void SetSensitive(vector<const char*>& menu_names, int mode) {
		deselect();
		main_window->activate_focus();
		vector<const char*>::iterator mit;
		for (mit=menu_names.begin(); mit != menu_names.end(); mit++) {
			SetSensitive(SearchMenu(*mit),mode);
		}
	}
	void SetShow(const char* menu_name, int mode) {
		deselect();
		main_window->activate_focus();
		vector<Gtk::MenuItem*> items = SearchMenu(menu_name);
		vector<Gtk::MenuItem*>::iterator it;
		for (it=items.begin(); it!=items.end(); it++) {
			if (mode) { (*it)->show(); (*it)->set_sensitive(1); }
			else { (*it)->hide(); (*it)->set_sensitive(0); }
		}
	}
	void SetActive(const char* menu_name, bool state = true) {
		vector<Gtk::MenuItem*> items = SearchMenu(menu_name);
		vector<Gtk::MenuItem*>::iterator it;
		for (it=items.begin(); it!=items.end(); it++) {
			if (Gtk::CheckMenuItem::isA(*it)) {
				Gtk::CheckMenuItem* item = dynamic_cast<Gtk::CheckMenuItem*>(*it);
				item->set_active(state);
			}
		}
	}

private:
	// menu  callback

	// ե롧ɥ
	void PdtDraw(int num) {
		main_window->local_system.DeleteTextWindow();
		if (num < 0x80)
			main_window->local_system.CopyBuffer(0,0,639,479, num, 0,0,0, 0);
		else
			main_window->local_system.CopyPDTtoBuffer(0,0,639,479, num-0x80, 0,0,0, 0);
	}
	// ե롧ƥࡧߡ
	void StopProcess(int state) {
		if (in_proc&2) return; // ػ
		in_proc |= 2;
		main_window->local_system.SetStopProcess(state);
		// radio button ξ֤ꤹ
		if (state) SetActive("Pause");
		else SetActive("Resume");
		in_proc &= ~2;
	}
	// ץ󡧥ƥ®١no wait / ® / ® / ®
	void SetTextSpeed(int time, char* widget_name) {
		if (in_proc&4) return; // ػ
		in_proc |= 4;
		main_window->local_system.SetTextSpeed(time);
		// radio button ξ֤ꤹ
		SetActive(widget_name);
		in_proc &= ~4;
	}
	// ե : ƥ : ɤФ
	void SetForceFast(Gtk::CheckMenuItem* widget) {
		if (in_proc&8) return; // ػ
		in_proc |= 8;
		if (widget->get_active()) {
			main_window->local_system.SetForceFast(true);
		} else {
			main_window->local_system.SetForceFast(false);
		}
		SetActive("Enable all-skip", widget->get_active());
		in_proc &= ~8;
	}
	void SetRandomSelect(Gtk::CheckMenuItem* widget) {
		if (in_proc&8192) return; // ػ
		in_proc |= 8192;
		if (widget->get_active()) {
			main_window->local_system.SetRandomSelect(true);
		} else {
			main_window->local_system.SetRandomSelect(false);
		}
		SetActive("Enable random-select", widget->get_active());
		in_proc &= ~8192;
	}
	// ե : ƥ :  ON / OFF
	void SetGraphicEffect(int state) {
		if (in_proc&16) return; // ػ
		in_proc |= 16;
		main_window->local_system.SetGraphicEffectOff(state);
		if (state) SetActive("Disable effect");
		else SetActive("Enable effect");
		in_proc &= ~16;
	}
	// ե롧λ˥塼
	void GoMenu(void) {
		main_window->local_system.SetGoMenu();
	}
	// ץ:⡼
	void GrpFastMode(int mode, char* widget_name) {
		if (in_proc & 2048) return; // ػ
		in_proc |= 2048;
		main_window->local_system.SetGrpFastMode(AyuSys::GrpFastType(mode));
		// radio button ξ֤ꤹ
		SetActive(widget_name);
		in_proc &= ~2048;
	}
	// ץ:⡼
	void KoeMode(int mode, char* widget_name) {
		if (in_proc & 4096) return; // ػ
		in_proc |= 4096;
		main_window->local_system.SetKoeMode(mode);
		// radio button ξ֤ꤹ
		SetActive(widget_name);
		in_proc &= ~4096;
	}
	// ץ󡧥ƥ
	void TextFast(Gtk::CheckMenuItem* widget) {
		if (in_proc & 8192) return; // ػ
		in_proc |= 8192;
		if (widget->get_active()) {
			main_window->local_system.SetTextFastMode(true);
			SetActive("Skip text",true);
			SetActive("Auto-skip text",false);
		} else {
			main_window->local_system.SetTextFastMode(false);
			SetActive("Skip text",false);
			SetActive("Auto-skip text",false);
		}
		in_proc &= ~8192;
	}
	// ץ󡧥ƥȼư
	void TextAuto(Gtk::CheckMenuItem* widget) {
		if (in_proc & 8192) return; // ػ
		in_proc |= 8192;
		if (widget->get_active()) {
			main_window->local_system.SetTextAutoMode(true);
			SetActive("Skip text",false);
			SetActive("Auto-skip text",true);
		} else {
			main_window->local_system.SetTextAutoMode(false);
			SetActive("Skip text",false);
			SetActive("Auto-skip text",false);
		}
		in_proc &= ~8192;
	}

	// ץ󡧥ƥȾõ
	int in_proc;
	void DeleteWaku(void) {
		if (in_proc&1) return; // ػ
		in_proc |= 1;
		// Ⱦõ
		int type, bri;
		main_window->DeleteTextWindow(&type,&bri);
		int x,y,clicked, now_click;
		// ޥޤԤ
		main_window->ClearMouseState();
		while(1) {
			main_window->GetMouseState(x,y,clicked, now_click);
			if (clicked != -1) break;
			main_window->local_system.CallProcessMessages();
		}
		main_window->ClearMouseState();
		// ƥȤľƽλ
		main_window->DrawTextWindow(type,bri);
		in_proc &= ~1;
	}

	// ץ̥⡼
	void ToAllScreen(void) {
		if (in_proc & 32) return; // ػ
		in_proc |= 32;
		if (main_window->IsAllScreen()) {
			/* ɥ⡼ɤ */
			main_window->ToNoAllScreen();
		} else {
			/* ̥⡼ɤ */
			main_window->ToAllScreen();
		}
		/* ҤȤϤ򤪤ޤʤȸġ */
		main_window->DisplaySync();
		usleep(1000*100);
		main_window->DisplaySync();
		in_proc &= ~32;
	}

	void SetBacklog(int back) {
		main_window->local_system.SetBacklog(back);
	}

	// ץ󡧥ƥɤФ
	void TextSkip(int count) {
		main_window->local_system.StartTextSkipMode(count);
	}
};

/**********************************************
**
** AyuWindow <-> AyuWin_Menu Υ󥿡ե
**
***********************************************
*/
void AyuWindow::UpdateMenu(char** menu_list) {
	if (menu_window)
		menu_window->Update(menu_list);
}

void AyuWindow::CreateMenu(void) {
	// menu Ĥ
	menu_window = manage(new AyuWin_Menu(this));
	main_vbox.pack_start(*menu_window);
	menu_window->show_all();
	// menu ν֤
	ChangeMenuTextFast();
	SetMenuScreenmode(0);
	SetMenuBacklogMode(0);
}

void AyuWindow::hide_menu(void) {
	menu_window->hide();
}

void AyuWindow::show_menu(void) {
	menu_window->show();
}

void AyuWindow::PopupLoadMenu(void) {
	if (menu_window)
		menu_window->PopupLoad();
}
void AyuWindow::PopupMenu(void) {
	if (menu_window)
		menu_window->Popup();
}

// ˥塼ḁ̇̄⡼ɤڤؤ
void AyuWindow::SetMenuScreenmode(int mode) {
	if (mode) { // ̥⡼
		menu_window->ChangeMenuName("Full screen mode", "Window mode");
	} else { // ̥⡼
		menu_window->ChangeMenuName("Window mode", "Full screen mode");
	}
	return;
}

// ˥塼 backlog mode ڤؤ
void AyuWindow::SetMenuBacklogMode(int mode) {
	if (mode) { // backlog mode ˤʤ
		menu_window->SetCurrentPopup(1);
		menu_window->SetSensitive("Log",0);
		menu_window->SetSensitive("Leave log",1);
		menu_window->SetSensitive("Prev message", 1);
		menu_window->SetSensitive("Next message", 1);
		menu_window->SetSensitive("Restart here",1);
	} else { // backlog mode 
		menu_window->SetCurrentPopup(0);
		menu_window->SetSensitive("Log",1);
		menu_window->SetSensitive("Leave log",0);
		menu_window->SetSensitive("Prev message", 0);
		menu_window->SetSensitive("Next message", 0);
		menu_window->SetSensitive("Restart here",0);
	}
}

// ɬפ˱ơǤʤ褦ˤ
void AyuWindow::ChangeMenuTextFast(void) {
#if 0
	if (!menu_window) return;

	vector<const char*> items;
	items.push_back("Skip text");
	items.push_back("Auto-skip text");
	int mode = 0;
	if (local_system.NowInKidoku()) mode = 1;
	menu_window->SetSensitive(items, mode);

	switch(local_system.TextFastMode()) {
	case AyuSys::TF_NORMAL: menu_window->SetActive("Skip text",false); menu_window->SetActive("Auto-skip text",false); break;
	case AyuSys::TF_FAST:   menu_window->SetActive("Skip text",true);  menu_window->SetActive("Auto-skip text",false); break;
	case AyuSys::TF_SKIP:   menu_window->SetActive("Skip text",true);  menu_window->SetActive("Auto-skip text",false); break;
	case AyuSys::TF_AUTO:   menu_window->SetActive("Skip text",false); menu_window->SetActive("Auto-skip text",true);  break;
	}
#endif
	menu_window->SetActive("Skip text", local_system.IsTextFast());
	menu_window->SetActive("Auto-skip text", local_system.IsTextAuto());
	CheckIconRegion();
	return;
}

// ɬפ˱ơ˥塼ƥõ
void AyuWindow::ShowMenuItem(std::vector<const char*>& items, int active) {
	if (! menu_window) return;
	menu_window->SetSensitive(items, active);
}
void AyuWindow::SetMenuTitle(char* title) {
	if (!menu_window) return;
	menu_window->SetTitle(title);
}

/**********************************************
**
** ˥塼СľΥ˥塼κ
**
***********************************************
*/
AyuWin_Menu::AyuWin_Menu(AyuWindow* parent) {
	main_window = parent; in_proc = 0;
	// menubar κ
	CreateFileMenu();
	CreateOptionMenu();
	CreatePopupMenu();
	CreateBacklogMenu();
	CreateBacklogPopupMenu();
	CreateLoadMenu();
	
	items().push_back(MenuElem(gettext("File"), *fileMenu));
	items().push_back(MenuElem(gettext("Option"), *optionMenu));
	items().push_back(MenuElem(gettext("Log"), *backlogMenu));
	items().push_back(MenuElem(gettext("Title")));
	titleItems.push_back(items().back());
	items().back()->right_justify();
	current_popup = popupMenu;

	// radio button κǽξ֤ꤷƤ
	StopProcess(0);
	SetGraphicEffect(0);
	SetTextSpeed(70, "Medium");
	GrpFastMode(1, "Normal");
	KoeMode(1, "Enable KOE");
}

void AyuWin_Menu::SetTitle(char* title) {
	vector<Gtk::MenuItem*>::iterator it = titleItems.begin();
	for (; it != titleItems.end(); it++) {
		Gtk::MenuItem* titleItem = *it;
		if (titleItem == 0) continue;
		if (titleItem->get_child() == 0) continue;
		if ( Gtk::Label::isA(titleItem->get_child()) ) {
			Gtk::Label* lb = (Gtk::Label*)(titleItem->get_child());
			lb->set_text(title);
		}
	}
}

void AyuWin_Menu::CreateFileMenu(void) {
	fileMenu = manage(new Gtk::Menu);
	CreateFileSubMenu();
	// ե˥塼κ
	int save_times = main_window->local_system.config->GetParaInt("#SAVEFILETIME");
	file_loadMenu = manage(new AyuWin_LoadMenu(save_times, main_window));
	file_saveMenu = manage(new AyuWin_SaveMenu(save_times, main_window));
	fileMenu->items().push_back( MenuElem(gettext("Load"), *file_loadMenu));
	fileMenu->items().push_back( MenuElem(gettext("Save"), *file_saveMenu));
#ifdef WINDOW_MENU_DEBUG
	fileMenu->items().push_back( MenuElem(gettext("Draw"), *file_drawMenu));
	fileMenu->items().push_back( MenuElem(gettext("System"), *file_sysMenu));
#endif
	fileMenu->items().push_back( MenuElem(gettext("Exit"), *file_endMenu));
}

void AyuWin_Menu::CreateOptionMenu(void) {
	optionMenu = manage(new Gtk::Menu);
	CreateOptionSubMenu();
/*
	optionMenu->items().push_back( CheckMenuElem(gettext("Skip text"),
		slot(this, &AyuWin_Menu::TextFast) ));
	optionMenu->items().push_back( CheckMenuElem(gettext("Auto-skip text"),
		slot(this, &AyuWin_Menu::TextAuto) ));
*/
	Gtk::CheckMenuItem* cmitem;
	optionMenu->items().push_back( CheckMenuElem(gettext("Skip text")));
	cmitem = static_cast<Gtk::CheckMenuItem*>(optionMenu->items().back());
	cmitem->toggled.connect(SigC::bind<Gtk::CheckMenuItem*>( SigC::slot(this, &AyuWin_Menu::TextFast), cmitem));
	optionMenu->items().push_back( CheckMenuElem(gettext("Auto-skip text")));
	cmitem = static_cast<Gtk::CheckMenuItem*>(optionMenu->items().back());
	cmitem->toggled.connect(SigC::bind<Gtk::CheckMenuItem*>( SigC::slot(this, &AyuWin_Menu::TextAuto), cmitem));
	optionMenu->items().push_back( MenuElem(gettext("Erase text field"),
		slot(this, &AyuWin_Menu::DeleteWaku) ));
	optionMenu->items().push_back( CheckMenuElem(gettext("Enable all-skip")));
	cmitem = static_cast<Gtk::CheckMenuItem*>(optionMenu->items().back());
	cmitem->toggled.connect(SigC::bind<Gtk::CheckMenuItem*>( SigC::slot(this, &AyuWin_Menu::SetForceFast), cmitem));
	optionMenu->items().push_back( CheckMenuElem(gettext("Enable random-select")));
	cmitem = static_cast<Gtk::CheckMenuItem*>(optionMenu->items().back());
	cmitem->toggled.connect(SigC::bind<Gtk::CheckMenuItem*>( SigC::slot(this, &AyuWin_Menu::SetRandomSelect), cmitem));
	optionMenu->items().push_back( MenuElem(gettext("Text speed"), *option_textspeedMenu));
	optionMenu->items().push_back( MenuElem(gettext("Visual effect"), *option_grpfastMenu));
	optionMenu->items().push_back( MenuElem(gettext("Koe effect"), *option_koeMenu));
	optionMenu->items().push_back( MenuElem(gettext("Full screen mode"),"<alt>Return",
		slot(this, &AyuWin_Menu::ToAllScreen) ));
}

void AyuWin_Menu::CreatePopupMenu(void) {
	popupMenu = manage(new Gtk::Menu);
	int save_times = main_window->local_system.config->GetParaInt("#SAVEFILETIME");
	popup_loadMenu = manage(new AyuWin_LoadMenu(save_times, main_window));
	popup_saveMenu = manage(new AyuWin_SaveMenu(save_times, main_window));

	popupMenu->items().push_back( MenuElem("Title"));
	titleItems.push_back(popupMenu->items().back());
	popupMenu->items().push_back( SeparatorElem());
	popupMenu->items().push_back( MenuElem(gettext("Load"), *popup_loadMenu));
	popupMenu->items().push_back( MenuElem(gettext("Save"), *popup_saveMenu));
	popupMenu->items().push_back( SeparatorElem() );
	popupMenu->items().push_back( MenuElem(gettext("Right click"),
		bind<int>(slot(main_window, &AyuWindow::MouseClick), 2) ));
	popupMenu->items().push_back( SeparatorElem() );
	popupMenu->items().push_back( CheckMenuElem(gettext("Skip text")));
	Gtk::CheckMenuItem* cmitem;
	cmitem = static_cast<Gtk::CheckMenuItem*>(popupMenu->items().back());
	cmitem->toggled.connect(SigC::bind<Gtk::CheckMenuItem*>( SigC::slot(this, &AyuWin_Menu::TextFast), cmitem));
	popupMenu->items().push_back( CheckMenuElem(gettext("Auto-skip text")));
	cmitem = static_cast<Gtk::CheckMenuItem*>(popupMenu->items().back());
	cmitem->toggled.connect(SigC::bind<Gtk::CheckMenuItem*>( SigC::slot(this, &AyuWin_Menu::TextAuto), cmitem));
#ifdef WITH_BACKLOG
	popupMenu->items().push_back( MenuElem(gettext("Enter log"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -1)));
#endif
	popupMenu->items().push_back( SeparatorElem() );

	popupMenu->items().push_back( MenuElem(gettext("Erase text field"),
		slot(this, &AyuWin_Menu::DeleteWaku) ));

	popupMenu->items().push_back( CheckMenuElem(gettext("Enable all-skip")));
	cmitem = static_cast<Gtk::CheckMenuItem*>(popupMenu->items().back());
	cmitem->toggled.connect(SigC::bind<Gtk::CheckMenuItem*>( SigC::slot(this, &AyuWin_Menu::SetForceFast), cmitem));
	popupMenu->items().push_back( CheckMenuElem(gettext("Enable random-select")));
	cmitem = static_cast<Gtk::CheckMenuItem*>(popupMenu->items().back());
	cmitem->toggled.connect(SigC::bind<Gtk::CheckMenuItem*>( SigC::slot(this, &AyuWin_Menu::SetRandomSelect), cmitem));
	popupMenu->items().push_back( MenuElem(gettext("Previous text"), *popup_textbackMenu));
	popupMenu->items().push_back( MenuElem(gettext("Skip"), *popup_textskipMenu));
	popupMenu->items().push_back( MenuElem(gettext("Text speed"), *popup_textspeedMenu));
	popupMenu->items().push_back( MenuElem(gettext("Visual effect"), *popup_grpfastMenu));
	popupMenu->items().push_back( MenuElem(gettext("Koe effect"), *popup_koeMenu));
	popupMenu->items().push_back( MenuElem(gettext("Full screen mode"),"<alt>Return",
		slot(this, &AyuWin_Menu::ToAllScreen) ));
	popupMenu->items().push_back( MenuElem(gettext("Draw"), *popup_drawMenu));
	popupMenu->items().push_back( MenuElem(gettext("System"), *popup_sysMenu));
	popupMenu->items().push_back( MenuElem(gettext("Exit"), *popup_endMenu));
}

void AyuWin_Menu::CreateBacklogMenu(void) {
	backlogMenu = manage(new Gtk::Menu);

	Gtk::Menu* backlogMenu_Prev = manage(new Gtk::Menu);
	backlogMenu_Prev->items().push_back(MenuElem(gettext("Prev(log)"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 1)));
	backlogMenu_Prev->items().push_back(MenuElem(gettext("Prev 10"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 10)));
	backlogMenu_Prev->items().push_back(MenuElem(gettext("Prev 100"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 100)));
	backlogMenu_Prev->items().push_back(MenuElem(gettext("Previous choice"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -3)));
	backlogMenu_Prev->items().push_back(MenuElem(gettext("Previous day"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -4)));

	Gtk::Menu* backlogMenu_Next = manage(new Gtk::Menu);
	backlogMenu_Next->items().push_back(MenuElem(gettext("Next(log)"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 10000+ 1)));
	backlogMenu_Next->items().push_back(MenuElem(gettext("Next 10"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 10000+ 10)));
	backlogMenu_Next->items().push_back(MenuElem(gettext("Next 100"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 10000+ 100)));
	backlogMenu_Next->items().push_back(MenuElem(gettext("Next choice"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -5)));
	backlogMenu_Next->items().push_back(MenuElem(gettext("Next day"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -6)));

	Gtk::Menu* backlogMenu_End = manage(new Gtk::Menu);
	backlogMenu_End->items().push_back(MenuElem(gettext("Really exit"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -1)));
	backlogMenu_End->items().push_back(MenuElem(gettext("Cancel")));

	Gtk::Menu* backlogMenu_Cont = manage(new Gtk::Menu);
	backlogMenu_Cont->items().push_back(MenuElem(gettext("Really restart"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -2)));
	backlogMenu_Cont->items().push_back(MenuElem(gettext("Cancel")));

#ifdef WITH_BACKLOG
	backlogMenu->items().push_back( MenuElem(gettext("Enter log"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -1)));
#endif
	backlogMenu->items().push_back( MenuElem(gettext("Previous text"),
		*option_textbackMenu));
	backlogMenu->items().push_back( MenuElem(gettext("Skip"),
		*option_textskipMenu));
	backlogMenu->items().push_back( MenuElem(gettext("Leave log"),
		*backlogMenu_End));
	backlogMenu->items().push_back( MenuElem(gettext("Prev message"),
		*backlogMenu_Prev));
	backlogMenu->items().push_back( MenuElem(gettext("Next message"),
		*backlogMenu_Next));
	backlogMenu->items().push_back( SeparatorElem() );
	backlogMenu->items().push_back( MenuElem(gettext("Restart here"),
		*backlogMenu_Cont));
}

void AyuWin_Menu::CreateBacklogPopupMenu(void) {
	backlogPopupMenu = manage(new Gtk::Menu);

	Gtk::Menu* backlogMenu_Prev = manage(new Gtk::Menu);
	backlogMenu_Prev->items().push_back(MenuElem(gettext("Prev"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 1)));
	backlogMenu_Prev->items().push_back(MenuElem(gettext("Prev 10"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 10)));
	backlogMenu_Prev->items().push_back(MenuElem(gettext("Prev 100"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 100)));
	backlogMenu_Prev->items().push_back(MenuElem(gettext("Previous choice"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -3)));
	backlogMenu_Prev->items().push_back(MenuElem(gettext("Previous day"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -4)));

	Gtk::Menu* backlogMenu_Next = manage(new Gtk::Menu);
	backlogMenu_Next->items().push_back(MenuElem(gettext("Next"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 10000+ 1)));
	backlogMenu_Next->items().push_back(MenuElem(gettext("Next 10"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 10000+ 10)));
	backlogMenu_Next->items().push_back(MenuElem(gettext("Next 100"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 10000+ 100)));
	backlogMenu_Next->items().push_back(MenuElem(gettext("Next choice"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -5)));
	backlogMenu_Next->items().push_back(MenuElem(gettext("Next day"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -6)));

	Gtk::Menu* backlogMenu_End = manage(new Gtk::Menu);
	backlogMenu_End->items().push_back(MenuElem(gettext("Really exit"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -1)));
	backlogMenu_End->items().push_back(MenuElem(gettext("Cancel")));

	Gtk::Menu* backlogMenu_Cont = manage(new Gtk::Menu);
	backlogMenu_Cont->items().push_back(MenuElem(gettext("Really restart"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -2)));
	backlogMenu_Cont->items().push_back(MenuElem(gettext("Cancel")));

	backlogPopupMenu->items().push_back( MenuElem("Title"));
	titleItems.push_back(backlogPopupMenu->items().back());
	popupMenu->items().push_back( SeparatorElem());
	backlogPopupMenu->items().push_back( MenuElem(gettext("Enter log"),
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -1)));
	backlogPopupMenu->items().push_back( MenuElem(gettext("Leave log"),
		*backlogMenu_End));
	backlogPopupMenu->items().push_back( MenuElem(gettext("Prev message"),
		*backlogMenu_Prev));
	backlogPopupMenu->items().push_back( MenuElem(gettext("Next message"),
		*backlogMenu_Next));
	backlogPopupMenu->items().push_back( SeparatorElem() );
	backlogPopupMenu->items().push_back( MenuElem(gettext("Restart here"),
		*backlogMenu_Cont));
	backlogPopupMenu->items().push_back( MenuElem(gettext("Full screen mode"),
		slot(this, &AyuWin_Menu::ToAllScreen) ));
	backlogPopupMenu->items().push_back( MenuElem(gettext("Exit"), *popup2_endMenu));
}

void AyuWin_Menu::CreateLoadMenu(void) {
	int save_times = main_window->local_system.config->GetParaInt("#SAVEFILETIME");
	loadMenu = manage(new AyuWin_LoadMenu(save_times, main_window));
}

/**********************************************
**
** ˥塼СΥ֥˥塼κ
**
***********************************************
*/

void AyuWin_Menu::CreateFileSubMenu(void) {
	file_drawMenu = manage(new Gtk::Menu());
	popup_drawMenu = manage(new Gtk::Menu());

	file_drawMenu->items().push_back( MenuElem("Buf0",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x01)));
	file_drawMenu->items().push_back( MenuElem("Buf1",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x01)));
	file_drawMenu->items().push_back( MenuElem("Buf2",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x02)));
	file_drawMenu->items().push_back( MenuElem("Buf3",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x03)));
	file_drawMenu->items().push_back( MenuElem("Buf4",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x04)));
	file_drawMenu->items().push_back( MenuElem("Buf5",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x05)));
	file_drawMenu->items().push_back( MenuElem("Buf6",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x06)));
	file_drawMenu->items().push_back( MenuElem("Buf7",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x07)));
	file_drawMenu->items().push_back( MenuElem("Buf8",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x08)));
	file_drawMenu->items().push_back( MenuElem("Buf9",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x09)));
	file_drawMenu->items().push_back( MenuElem("BufA",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x0a)));
	file_drawMenu->items().push_back( MenuElem("BufB",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x0b)));
	file_drawMenu->items().push_back( MenuElem("PDT0",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x81)));
	file_drawMenu->items().push_back( MenuElem("PDT1",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x81)));
	file_drawMenu->items().push_back( MenuElem("PDT2",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x82)));
	file_drawMenu->items().push_back( MenuElem("PDT3",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x83)));
	file_drawMenu->items().push_back( MenuElem("PDT4",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x84)));
	file_drawMenu->items().push_back( MenuElem("PDT5",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x85)));
	file_drawMenu->items().push_back( MenuElem("PDT6",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x86)));
	file_drawMenu->items().push_back( MenuElem("PDT7",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x87)));
	file_drawMenu->items().push_back( MenuElem("PDT8",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x88)));
	file_drawMenu->items().push_back( MenuElem("PDT9",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x89)));
	file_drawMenu->items().push_back( MenuElem("PDTA",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x8a)));
	file_drawMenu->items().push_back( MenuElem("PDTB",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x8b)));

	popup_drawMenu->items().push_back( MenuElem("Buf1",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x01)));
	popup_drawMenu->items().push_back( MenuElem("Buf2",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x02)));
	popup_drawMenu->items().push_back( MenuElem("Buf3",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x03)));
	popup_drawMenu->items().push_back( MenuElem("Buf4",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x04)));
	popup_drawMenu->items().push_back( MenuElem("Buf5",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x05)));
	popup_drawMenu->items().push_back( MenuElem("Buf6",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x06)));
	popup_drawMenu->items().push_back( MenuElem("PDT1",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x81)));
	popup_drawMenu->items().push_back( MenuElem("PDT2",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x82)));
	popup_drawMenu->items().push_back( MenuElem("PDT3",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x83)));
	popup_drawMenu->items().push_back( MenuElem("PDT4",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x84)));
	popup_drawMenu->items().push_back( MenuElem("PDT5",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x85)));
	popup_drawMenu->items().push_back( MenuElem("PDT6",
		bind<int>(slot(this, &AyuWin_Menu::PdtDraw), 0x86)));


	file_sysMenu = manage(new Gtk::Menu());
	popup_sysMenu = manage(new Gtk::Menu());
	
	Gtk::RadioMenuItem::Group fileSysGr;
	file_sysMenu->items().push_back( RadioMenuElem(fileSysGr, gettext("Pause"),
		bind<int>(slot(this, &AyuWin_Menu::StopProcess), 1)));
	file_sysMenu->items().push_back( RadioMenuElem(fileSysGr, gettext("Resume"),
		bind<int>(slot(this, &AyuWin_Menu::StopProcess), 0)));

	Gtk::RadioMenuItem::Group fileSysGr3;
	file_sysMenu->items().push_back( RadioMenuElem(fileSysGr3, gettext("Disable effect"),
		bind<int>(slot(this, &AyuWin_Menu::SetGraphicEffect), 1)));
	file_sysMenu->items().push_back( RadioMenuElem(fileSysGr3, gettext("Enable effect"),
		bind<int>(slot(this, &AyuWin_Menu::SetGraphicEffect), 0)));

	Gtk::RadioMenuItem::Group popupSysGr;
	popup_sysMenu->items().push_back( RadioMenuElem(popupSysGr, gettext("Pause"),
		bind<int>(slot(this, &AyuWin_Menu::StopProcess), 1)));
	popup_sysMenu->items().push_back( RadioMenuElem(popupSysGr, gettext("Resume"),
		bind<int>(slot(this, &AyuWin_Menu::StopProcess), 0)));

	Gtk::RadioMenuItem::Group popupSysGr3;
	popup_sysMenu->items().push_back( RadioMenuElem(popupSysGr3, gettext("Disable effect"),
		bind<int>(slot(this, &AyuWin_Menu::SetGraphicEffect), 1)));
	popup_sysMenu->items().push_back( RadioMenuElem(popupSysGr3, gettext("Enable effect"),
		bind<int>(slot(this, &AyuWin_Menu::SetGraphicEffect), 0)));


	file_endMenu = manage(new Gtk::Menu());
	popup_endMenu = manage(new Gtk::Menu());
	popup2_endMenu = manage(new Gtk::Menu());

	file_endMenu->items().push_back( MenuElem(gettext("Continue")));
	file_endMenu->items().push_back( MenuElem(gettext("Return to menu"), 
		slot(this, &AyuWin_Menu::GoMenu) ));
	file_endMenu->items().push_back( MenuElem(gettext("Really exit"), slot(main_window, &AyuWindow::Destroy) ));

	popup_endMenu->items().push_back( MenuElem(gettext("Continue")));
	popup_endMenu->items().push_back( MenuElem(gettext("Return to menu"), 
		slot(this, &AyuWin_Menu::GoMenu) ));
	popup_endMenu->items().push_back( MenuElem(gettext("Really exit"), slot(main_window, &AyuWindow::Destroy) ));

	popup2_endMenu->items().push_back( MenuElem(gettext("Continue")));
	popup2_endMenu->items().push_back( MenuElem(gettext("Really exit"), slot(main_window, &AyuWindow::Destroy) ));

}

void AyuWin_Menu::CreateOptionSubMenu(void) {
	option_textspeedMenu = manage(new Gtk::Menu());
	popup_textspeedMenu = manage(new Gtk::Menu());
	option_grpfastMenu = manage(new Gtk::Menu());
	popup_grpfastMenu = manage(new Gtk::Menu());
	option_koeMenu = manage(new Gtk::Menu());
	popup_koeMenu = manage(new Gtk::Menu());
	option_textbackMenu = manage(new Gtk::Menu());
	popup_textbackMenu = manage(new Gtk::Menu());
	option_textskipMenu = manage(new Gtk::Menu());
	popup_textskipMenu = manage(new Gtk::Menu());

	Gtk::RadioMenuItem::Group optionTSGr;
	option_textspeedMenu->items().push_back( RadioMenuElem(optionTSGr,gettext("No Wait"),
		bind<int,char*>(slot(this, &AyuWin_Menu::SetTextSpeed),1000, "No Wait") ));
	option_textspeedMenu->items().push_back( RadioMenuElem(optionTSGr,gettext("Fast"),
		bind<int,char*>(slot(this, &AyuWin_Menu::SetTextSpeed),200, "Fast") ));
	option_textspeedMenu->items().push_back( RadioMenuElem(optionTSGr,gettext("Medium"),
		bind<int,char*>(slot(this, &AyuWin_Menu::SetTextSpeed),70, "Medium") ));
	option_textspeedMenu->items().push_back( RadioMenuElem(optionTSGr,gettext("Slow"),
		bind<int,char*>(slot(this, &AyuWin_Menu::SetTextSpeed),20, "Slow") ));

	Gtk::RadioMenuItem::Group popupTSGr;
	popup_textspeedMenu->items().push_back( RadioMenuElem(popupTSGr,gettext("No Wait"),
		bind<int,char*>(slot(this, &AyuWin_Menu::SetTextSpeed),1000, "No Wait") ));
	popup_textspeedMenu->items().push_back( RadioMenuElem(popupTSGr,gettext("Fast"),
		bind<int,char*>(slot(this, &AyuWin_Menu::SetTextSpeed),200, "Fast") ));
	popup_textspeedMenu->items().push_back( RadioMenuElem(popupTSGr,gettext("Medium"),
		bind<int,char*>(slot(this, &AyuWin_Menu::SetTextSpeed),70, "Medium") ));
	popup_textspeedMenu->items().push_back( RadioMenuElem(popupTSGr,gettext("Slow"),
		bind<int,char*>(slot(this, &AyuWin_Menu::SetTextSpeed),20, "Slow") ));

	option_textbackMenu->items().push_back( MenuElem(gettext("Prev"),"Up",
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 2)));
	option_textbackMenu->items().push_back( MenuElem(gettext("Prev 10"),"Right",
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 11)));
	option_textbackMenu->items().push_back( MenuElem(gettext("Prev 100"),"<ctl>B",
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 101)));
	option_textbackMenu->items().push_back( MenuElem(gettext("Previous choice"),"<ctl>P",
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -3)));
	option_textbackMenu->items().push_back( MenuElem(gettext("Previous day"),"Home",
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -4)));

	popup_textbackMenu->items().push_back( MenuElem(gettext("Prev"),"Up",
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 2)));
	popup_textbackMenu->items().push_back( MenuElem(gettext("Prev 10"),"Right",
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 11)));
	popup_textbackMenu->items().push_back( MenuElem(gettext("Prev 100"),"<ctl>B",
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), 101)));
	popup_textbackMenu->items().push_back( MenuElem(gettext("Previous choice"),"<ctl>P",
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -3)));
	popup_textbackMenu->items().push_back( MenuElem(gettext("Previous day"),"Home",
		bind<int>(slot(this, &AyuWin_Menu::SetBacklog), -4)));

	option_textskipMenu->items().push_back( MenuElem(gettext("Next 10"),"Left",
		bind<int>(slot(this, &AyuWin_Menu::TextSkip),10) ));
	option_textskipMenu->items().push_back( MenuElem(gettext("Next 100"),"<ctl>F",
		bind<int>(slot(this, &AyuWin_Menu::TextSkip),100) ));
	option_textskipMenu->items().push_back( MenuElem(gettext("Until choice"),"<ctl>N",
		bind<int>(slot(this, &AyuWin_Menu::TextSkip),-1) ));
	option_textskipMenu->items().push_back( MenuElem(gettext("Until title change"),"End",
		bind<int>(slot(this, &AyuWin_Menu::TextSkip),-2) ));

	popup_textskipMenu->items().push_back( MenuElem(gettext("Next 10"),"Left",
		bind<int>(slot(this, &AyuWin_Menu::TextSkip),10) ));
	popup_textskipMenu->items().push_back( MenuElem(gettext("Next 100"),"<ctl>F",
		bind<int>(slot(this, &AyuWin_Menu::TextSkip),100) ));
	popup_textskipMenu->items().push_back( MenuElem(gettext("Until choice"),"<ctl>N",
		bind<int>(slot(this, &AyuWin_Menu::TextSkip),-1) ));
	popup_textskipMenu->items().push_back( MenuElem(gettext("Until title change"),"End",
		bind<int>(slot(this, &AyuWin_Menu::TextSkip),-2) ));

	Gtk::RadioMenuItem::Group optionGSGr;
	option_grpfastMenu->items().push_back( RadioMenuElem(optionGSGr, gettext("Normal"),
		bind<int,char*>(slot(this, &AyuWin_Menu::GrpFastMode), 0,"Normal")));
	option_grpfastMenu->items().push_back( RadioMenuElem(optionGSGr, gettext("FastGrp"),
		bind<int,char*>(slot(this, &AyuWin_Menu::GrpFastMode), 1,"FastGrp")));
	option_grpfastMenu->items().push_back( RadioMenuElem(optionGSGr, gettext("No effect"),
		bind<int,char*>(slot(this, &AyuWin_Menu::GrpFastMode), 2,"No effect")));
	option_grpfastMenu->items().push_back( RadioMenuElem(optionGSGr, gettext("Disable image"),
		bind<int,char*>(slot(this, &AyuWin_Menu::GrpFastMode), 3,"Disable image")));

	Gtk::RadioMenuItem::Group popupGSGr;
	popup_grpfastMenu->items().push_back( RadioMenuElem(popupGSGr, gettext("Normal"),
		bind<int,char*>(slot(this, &AyuWin_Menu::GrpFastMode), 0,"Normal")));
	popup_grpfastMenu->items().push_back( RadioMenuElem(popupGSGr, gettext("FastGrp"),
		bind<int,char*>(slot(this, &AyuWin_Menu::GrpFastMode), 1,"FastGrp")));
	popup_grpfastMenu->items().push_back( RadioMenuElem(popupGSGr, gettext("No effect"),
		bind<int,char*>(slot(this, &AyuWin_Menu::GrpFastMode), 2,"No effect")));
	popup_grpfastMenu->items().push_back( RadioMenuElem(popupGSGr, gettext("Disable image"),
		bind<int,char*>(slot(this, &AyuWin_Menu::GrpFastMode), 3,"Disable image")));

	Gtk::RadioMenuItem::Group optionKOEr;
	option_koeMenu->items().push_back( RadioMenuElem(optionKOEr, gettext("Enable KOE"),
		bind<int,char*>(slot(this, &AyuWin_Menu::KoeMode), 1,"Enable KOE")));
	option_koeMenu->items().push_back( RadioMenuElem(optionKOEr, gettext("Disable KOE"),
		bind<int,char*>(slot(this, &AyuWin_Menu::KoeMode), 0,"Disable KOE")));

	Gtk::RadioMenuItem::Group popupKOEr;
	popup_koeMenu->items().push_back( RadioMenuElem(popupKOEr, gettext("Enable KOE"),
		bind<int,char*>(slot(this, &AyuWin_Menu::KoeMode), 1,"Enable KOE")));
	popup_koeMenu->items().push_back( RadioMenuElem(popupKOEr, gettext("Disable KOE"),
		bind<int,char*>(slot(this, &AyuWin_Menu::KoeMode), 0,"Disable KOE")));

}

void AyuWin_Menu::Update(char** list) {
	file_loadMenu->SetString(list);
	file_saveMenu->SetString(list);
	popup_loadMenu->SetString(list);
	popup_saveMenu->SetString(list);
	loadMenu->SetString(list);
}

void AyuWin_Menu::Popup(void) {
	current_popup->popup(0,0,0,0);
}

void AyuWin_Menu::PopupLoad(void) {
	loadMenu->popup(0,0,0,0);
}

/* gtk-- version 1.2.3 餷 Container::foreach() ᥽åɤȤʤΤ
** Ʊ̣ĥåѤޤ
*/
void gtkmm_foreach_callback_(GtkWidget* w, gpointer data) {
	Slot1<void, Gtk::Widget&>* s = (Slot1<void, Gtk::Widget&>*)data;
	if (!w) return;
	s->call(*Gtk::wrap(w));
}

void gtkmm_foreach(Gtk::Container* container, const Slot1<void, Gtk::Widget&>& s) {
	gtk_container_foreach(container->gtkobj(), gtkmm_foreach_callback_, gpointer(&s));

}

/* widget ̾٥ѹ */
/* ޤޤƤ 1, ʤ 0 ֤ */
void AyuWin_Menu::ChangeName(Gtk::Widget& widget, const char* old_name, const char* new_name) {
	/* ٥ʤƤ */
	if (Gtk::Label::isA(&widget)) {
		Gtk::Label* label = dynamic_cast<Gtk::Label*>(&widget);
		if (strcmp(old_name, label->get_text().c_str()) == 0) {
			label->set_text(new_name);
		}
		return;
	}
	/* ƥʤʤޤޤwidgetƤˤĤӤԤ */
	/* ꥹȤȴФʤΤ foreach Ǥ */
	if (Gtk::Container::isA(&widget)) {
		Gtk::Container* container = dynamic_cast<Gtk::Container*>(&widget);
		/* container->foreach( bind(slot(&AyuWin_Menu::ChangeName), old_name, new_name)); */
		gtkmm_foreach(container, bind(slot(&AyuWin_Menu::ChangeName), old_name, new_name));
		return;
	}
	return;
}
// menu ̾ menu item õ
void AyuWin_Menu::ChangeMenuName(Gtk::Menu* menu, const char* old_name, const char* new_name) {
	MenuList& menu_list = menu->items();
	// ꥹȤκǽ餫ǸޤõƤ
	for (MenuList::iterator it = menu_list.begin();
		it != menu_list.end(); it++) {
		// menuitem Υ٥ѹ
		Gtk::MenuItem* item = *it;
		if (item->get_child())
			ChangeName(*(item->get_child()), old_name, new_name);
		// menuitem  submenu ʤ顢õ
		if (item->has_submenu()) {
			ChangeMenuName(item->get_submenu(), old_name, new_name);
		}
        }
	return;
}

void AyuWin_Menu::ChangeMenuName(const char* old_name, const char* new_name) {
	vector<Gtk::MenuItem*> items;
	const char* local_old_name = gettext(old_name);
	const char* local_new_name = gettext(new_name);
	ChangeMenuName(fileMenu, local_old_name, local_new_name);
	ChangeMenuName(optionMenu, local_old_name, local_new_name);
	ChangeMenuName(backlogMenu, local_old_name, local_new_name);
	ChangeMenuName(popupMenu, local_old_name, local_new_name);
	ChangeMenuName(backlogPopupMenu, local_old_name, local_new_name);
	return;
}
static void checkname_foreach_callback(Gtk::Widget& wid, const char* name, int* result_ptr) {
	if (result_ptr)
		*result_ptr |= AyuWin_Menu::CheckName(&wid, name);
}
/* widget  name ޤޤƤ뤫򸡺 */
/* ޤޤƤ 1, ʤ 0 ֤ */
int AyuWin_Menu::CheckName(Gtk::Widget* widget, const char* name) {
	if (widget == 0) return 0;
	/* ٥ʤƤ */
	if (Gtk::Label::isA(widget)) {
		if (strcmp(name, (dynamic_cast<Gtk::Label*>(widget))->get_text().c_str()) == 0) return 1;
		else return 0;
	}
	/* ƥʤʤޤޤwidgetƤˤĤӤԤ */
	/* ꥹȤȴФʤΤ foreach Ǥ */
	if (Gtk::Container::isA(widget)) {
		int result = 0;
		Gtk::Container* container = dynamic_cast<Gtk::Container*>(widget);
		/* container->foreach( bind(slot(checkname_foreach_callback), name, &result)); */
		gtkmm_foreach(container, bind(slot(checkname_foreach_callback), name, &result));
		return result;
	}
	return 0;
}

// menu ̾ menu item õ
void AyuWin_Menu::SearchMenu(vector<Gtk::MenuItem*>& ret_list, Gtk::Menu* menu, const char* name) {
	MenuList& menu_list = menu->items();
	// ꥹȤκǽ餫ǸޤõƤ
	for (MenuList::iterator it = menu_list.begin();
		it != menu_list.end(); it++) {
		// menuitem  label ǡƤnameʤ餽֤
		Gtk::MenuItem* item = *it;
		if (CheckName(item->get_child(), name)) {
			ret_list.push_back(item);
		}
		// menuitem  submenu ʤ顢õ
		if (item->has_submenu()) {
			SearchMenu(ret_list, item->get_submenu(), name);
		}
        }
	return;
			
}

vector<Gtk::MenuItem*> AyuWin_Menu::SearchMenu(const char* name) {
	vector<Gtk::MenuItem*> items;
	const char* local_name = gettext(name);
	SearchMenu(items, fileMenu, local_name);
	SearchMenu(items, optionMenu, local_name);
	SearchMenu(items, backlogMenu, local_name);
	SearchMenu(items, popupMenu, local_name);
	SearchMenu(items, backlogPopupMenu, local_name);
	return items;
}
