/*
 * audioMix_alsa.c  ALSA mixer lowlevel access
 *
 * Copyright (C) 1997-1998 Masaki Chikama (Wren) <chikama@kasumi.ipl.mech.nagoya-u.ac.jp>
 *               1998-                           <masaki-c@is.aist-nara.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/asoundlib.h>
#include "audio.h"
#include "config.h"

static char *mixer_devicename = MIXERDEV;
static int   mixer_fd,mixer_card;

#if SND_PROTOCOL_MAJOR(SND_MIXER_VERSION) > 1 || SND_LIB_VERSION >= SND_PROTOCOL_VERSION(0,5,0)

typedef struct {
	unsigned char name[24];
	int index;
} a_mix_elements;

#include "audioMix_alsa.h"
static snd_mixer_element_t elems[4];
static snd_mixer_element_info_t e_info[4];
static snd_mixer_t *mixer_handle;

void mixer_set_level(int device, int level){
	int i;
    int err;
	if (snd_mixer_open( &mixer_handle, mixer_card, mixer_fd ) < 0) {
		fprintf(stderr, "mixer_initiliz(): Opening mixer device %s failed\n", mixer_devicename);
		return;
	}

	level+=e_info[device].data.volume1.prange[0].min;
	if(e_info[device].data.volume1.prange[0].max<level)level=
		e_info[device].data.volume1.prange[0].max;

	for( i=0 ; i<elems[device].data.volume1.voices ; i++ )
		elems[device].data.volume1.pvoices[i]=level;
	if ((err=snd_mixer_element_write(mixer_handle,elems+device))<0) {
		fprintf(stderr, "mixer_set_level(lv%d): mixser write failed(%s)\n",
                level,snd_strerror(err));
		snd_mixer_close(mixer_handle);
		return;
	}
	snd_mixer_close(mixer_handle);
}

int mixer_get_level(int device) { 
	if (snd_mixer_open( &mixer_handle, mixer_card, mixer_fd ) < 0) {
		fprintf(stderr, "mixer_initiliz(): Opening mixer device %s failed\n", mixer_devicename);
		return 0;
	}
	
	if ( snd_mixer_element_read(mixer_handle,elems+device)<0 ) {
		fprintf(stderr, "mixer_gett_level(): mixser read failed\n");
		return 0;
	}
	snd_mixer_close(mixer_handle);
	return elems[device].data.volume1.pvoices[0]-e_info[device].data.volume1.prange[0].min;
}

int mixer_initilize(){ 
	int i;
	mixer_card=atoi(mixer_devicename);
	if (snd_mixer_open( &mixer_handle, mixer_card , mixer_fd ) < 0) {
		fprintf(stderr, "mixer_initiliz(): Opening mixer device %s failed\n", mixer_devicename);
		return NG;
	}
	for( i=0 ; i<4 ; i++ ) {
		bzero(elems+i,sizeof(snd_mixer_element_t));
		strcpy(elems[i].eid.name,mixer_elements[i].name);
		elems[i].eid.index=mixer_elements[i].index;
		elems[i].eid.type=SND_MIXER_ETYPE_VOLUME1;
		snd_mixer_element_build(mixer_handle,elems+i);
		bzero(e_info+i,sizeof(snd_mixer_element_info_t));
		strcpy(e_info[i].eid.name,mixer_elements[i].name);
		e_info[i].eid.index=mixer_elements[i].index;
		e_info[i].eid.type=SND_MIXER_ETYPE_VOLUME1;
		snd_mixer_element_info_build(mixer_handle,e_info+i);
		snd_mixer_element_info(mixer_handle,e_info+i);
	}
	snd_mixer_close(mixer_handle);
	return OK;
}

#else
static void *mixer_handle;

static int get_mixer_id(int device) {
	switch(device) {
	case MIX_MASTER:
		return snd_mixer_channel(mixer_handle, SND_MIXER_ID_MASTER);
	case MIX_CD:
		return snd_mixer_channel(mixer_handle, SND_MIXER_ID_CD);
	case MIX_MIDI:
		return snd_mixer_channel(mixer_handle, SND_MIXER_ID_SYNTHESIZER);
	case MIX_PCM:
		return snd_mixer_channel(mixer_handle, SND_MIXER_ID_PCM);
	default:
		return snd_mixer_channel(mixer_handle, SND_MIXER_ID_MASTER);
	}
	return 0;
}

void mixer_set_level(int device, int level){
	snd_mixer_channel_t cdata = { 0 };
	
	if (snd_mixer_open( &mixer_handle, mixer_card, mixer_fd ) < 0) {
		fprintf(stderr, "mixer_initiliz(): Opening mixer device %s failed\n", mixer_devicename);
		return;
	}
	if (snd_mixer_channel_read(mixer_handle, get_mixer_id(device), &cdata)<0) {
		fprintf(stderr, "mixer_set_level(): mixser read failed\n");
		return;
	}
	cdata.left = cdata.right = level;
	if (snd_mixer_channel_write(mixer_handle, get_mixer_id(device), &cdata)<0) {
		fprintf(stderr, "mixer_set_level(): mixser write failed\n");
		return;
	}
	snd_mixer_close(mixer_handle);
}

int mixer_get_level(int device) { 
	snd_mixer_channel_t cdata = { 0 };
	
	if (snd_mixer_open( &mixer_handle, mixer_card, mixer_fd ) < 0) {
		fprintf(stderr, "mixer_initiliz(): Opening mixer device %s failed\n", mixer_devicename);
		return 0;
	}
	if (snd_mixer_channel_read(mixer_handle, get_mixer_id(device), &cdata)<0) {
		fprintf(stderr, "mixer_gett_level(): mixser read failed\n");
		return 0;
	}
	snd_mixer_close(mixer_handle);
	return cdata.left;
}

int mixer_initilize(){ 
	mixer_card=atoi(mixer_devicename);
	if (snd_mixer_open( &mixer_handle, mixer_card , mixer_fd ) < 0) {
		fprintf(stderr, "mixer_initiliz(): Opening mixer device %s failed\n", mixer_devicename);
		return NG;
	}
	snd_mixer_close(mixer_handle);
	return OK;
}
#endif

int mixer_remove() {
        /* if (mixer_handle != NULL) snd_mixer_close(mixer_handle); */
	return OK;
}

void mixer_setDeviceName(char *name) {
	mixer_devicename = name;
}
