/*-
 * @(#)gdkmm_font.h -- Gdk--'s Gdk_Font with TrueType font
 */

#ifndef _GDKMM_FONT_FREETYPE_H
#define _GDKMM_FONT_FREETYPE_H

#include <gdk--/font.h>

extern "C" {
    #include "ttfont.h"
}

class Gdk_Font_FreeType : public Gdk_Font {
protected:
    /* has FreeType engine loaded */
    gchar		 freetype_loaded;

    /*  FreeType relates */
    FontFaceHints	*hints;
    FontFaceInfo	*info;
    FreeTypeInfo	*ftinfo;

    /* size of '' */
    gint a_char_width;
    gint a_char_height;

public:
    /* constructors */
    Gdk_Font_FreeType() {}
    Gdk_Font_FreeType(gchar *, gdouble);

    /* destructor */
    ~Gdk_Font_FreeType();

    /* is usable freetype */
    char is_usable_freetype() const { return freetype_loaded; }

    /* get bitmap */
    gchar *get_bitmap(gint, gint &, gint &) const;

    /* measure charactor */
    gint char_width(gint) const;
    gint char_measure(gint) const;
    gint char_width(void) const { return a_char_width; }
    gint char_height(void) const { return a_char_height; }
};

#endif

/* gdkmm_font.h ends here */
