/*-
 * @(#)ttfont_test.c -- Code using ttfont functions
 */

#include <stdio.h>

#include "ttfont.h"

int
main(int argc, char **argv)
{
    FontFaceHints	*hints;
    FontFaceInfo	*info;
    char		*fontfile;
    unsigned int	 code;
    char		 name[256];
    char		*src, *dest;
    int			 w, h, x, y;

    /* AYU as 0xb0be in EUC */
    code = 0xb0be;

    /* Begin FreeType engine */
    if (!ttfont_init())
	goto abort;

    fontfile = argv[1] ? argv[1] : "default.ttc";
    if (!(hints = ttfont_load(fontfile, 24.5)))
	goto deinit;

    if (!(info = ttfont_open_face(hints)))
	goto unload;

    if (ttfont_is_usable_japanese(info))
        ttfont_read_name_string(info, name, 256);
    else
	strcpy(name, "(this font contains no KANJI)");
    printf("name: %s\n", name);
    
    /* Rendering font normal method */
    dest = ttfont_render_font(info, &w, &h, code, 0);
    printf("width: %d, height: %d\n", w, h);
    for (y = 0; y < h; y++) {
	src = dest + y * w;
	for (x = 0; x < w; x++)
	    putchar(*src++ ? '#' : ' ');
	putchar('\n');
    }

    /* Rendering font smoothing method */
    dest = ttfont_render_font(info, &w, &h, code, 1);
    for (y = 0; y < h; y++) {
	src = dest + y * w;
	for (x = 0; x < w; x++)
	    putchar(' ' + *src++);
	putchar('\n');
    }

    /* End FreeType engine */
    ttfont_close_face(info);
unload:
    ttfont_unload(hints);
deinit:
    ttfont_deinit();
abort:
    return 0;
}

/* ttfont_test.c ends here */
