./" $Id: xmailwatcher.man,v 1.1 1997/08/29 13:43:11 gdmr Exp $
.TH XMAILWATCHER 1 "April 1996" GDMR
.SH NAME
xmailwatcher -- periodically check for mail
.SH SYNOPSIS
.B xmailwatcher
[-\fItoolkitoption\fP ...] [-\fIoption\fP ...]
.SH DESCRIPTION
.I xmailwatcher
checks the user's mailbox periodically.  If there is new mail, or
optionally if there is any mail at all, the user is notified.  Two methods
of display are used: if the application is in the iconic state the icon window
displays a \fInomail\fP or \fImail\fP
bitmap, with foreground and background values
inverted by default in the latter case; if the application is non-iconic a
list of senders and subjects is displayed, with a vertical
scrollbar if necessary.
.PP
.I xmailwatcher
will attempt to decode RFC 1522 Q-encoded headers, provided a suitable
ISO8859 font is being used.  Due to limitations of the Label widget used
to display the list of messages, each instance of
.I xmailwatcher
is able to decode only one class of
ISO8859-n encoding (the default is ISO8859-1).
.PP
.I xmailwatcher
understands both
.I sendmail
and
.I MMDF
formats of mailbox automatically.
.SH OPTIONS
.I xmailwatcher
accepts all of the standard toolkit command line options.  In addition, the
following are accepted:
.TP 8
.B \-allmail (\fPor\fB \-allMail)
Report whenever there is any mail in the mailbox.  By default only new mail
is reported.  Sets the \fI.newMail\fP application resource to \fIFalse\fP.
.TP 8
.B \-doMime (\fPand\fB \-noMime)
Controls whether RFC1522 should be decoded or not.  The default is to attempt
to decode.
.TP 8
.B \-icongeometry \fIgeometryspec\fB (\fRor\fB \-iconGeometry)
Specifies the geometry for the icon window.  Sets the \fI.iconShell.geometry\fP
resource.
.TP 8
.B \-mailbox \fImailboxname\fP
Specifies the name of the mailbox to be polled (defaults to \fI.mail\fP in the
user's current directory).  Sets the \fI.mailbox\fP application resource.
.TP 8
.B \-newmail (\fPor\fB \-newMail)
Report only new mail in the mailbox (the default).  Sets the \fI.newMail\fP
application resource to \fITrue\fP.
.TP 8
.B \-poll \fIpollinterval\fB
Specifies the interval in seconds between successive mailbox checks (defaults
to 67 seconds).  Sets the \fI.pollInterval\fP application resource.
.TP 8
.B \-silent
Don't ring the bell when new mail arrives.  Sets the \fI.silent\fP application
resource to \fITrue\fP.
.TP 8
.B \-soundfile \fIsoundFileName\fB (\fRor\fB \-soundFile)
If on a Sun-4, attempt to copy \fIsoundFileName\fP to /dev/audio instead of
ringing the bell.  \fBNOTE\fP that the audio device on the \fIclient\fP
host is used, not the server host, so you don't want to do this if
you're using an X-terminal.  Sets the \fI.soundFile\fP application
resource.
.SH WIDGET HIERARCHY
.I xmailwatcher
has the following widget hierarchy:
.sp
.nf
.ta .5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i 6.5i 7.0i
	MailWatcher xmailwatcher
		Viewport viewport
			Label messages
		TransientShell iconShell
			Label icon
.fi
.SH X DEFAULTS
In addition to the usual resources and classes used by the widgets in its
hierarchy,
.I xmailwatcher
understands the following application resources:
.TP 8
.B bellVolume (\fPclass\fB BellVolume)
Specifies the volume with which the bell should be rung when mail arrives
(default zero).  See the \fIXlib\fP documentation for details.
.TP 8
.B bufferSize (\fPclass\fB BufferSize)
Defines the size of the buffer used to hold the sender/subject details
(default 8K).
.TP
.B doMime (\fPclass\fB DoMime)
If \fITrue\fP (the default) attempt to decode RFC1522 Q-encoding.
.TP 8
.B fullNames (\fPclass\fB FullNames)
If \fITrue\fP, display the full text of the "From:" header.  If \fIFalse\fP
(the default), attempt to extract the sender's real name from the "From:"
header.
.TP 8
.B iconBackground (\fPclass\fB Background)
Specifies the background colour of the \fInomail\fP icon and the default
foreground colour of the \fImail\fP icon.
.TP 8
.B iconForeground (\fPclass\fB Foreground)
Specifies the foreground colour of the \fInomail\fP icon and the default
background colour of the \fImail\fP icon.
.TP 8
.B iconMailBackground (\fPdefault\fB iconForeground)
Specifies the background colour of the \fImail\fP icon.
.TP 8
.B iconMailForeground (\fPdefault\fB iconBackground)
Specifies the foreground colour of the \fImail\fP icon.
.TP 8
.B mailBitmap (\fPclass\fBMailBitmap)
Specifies the name of a bitmap to display in the icon window when mail has
arrived (defaults to \fIletters\fP).  The \fIXmu\fP string-to-bitmap
converter is registered to handle this resource.
.TP 8
.B mailbox (\fPclass\fB Mailbox)
Specifies the name of the mailbox to be polled (defaults to \fI.mail\fP in
the user's current directory).
.TP 8
.B newMail (\fPclass\fB NewMail)
If \fITrue\fP (the default) the user is only informed of new mail.  If
\fIFalse\fP the user is informed whenever there is any mail in the mailbox.
In the latter case if the application is iconic then a complete
parse of the mailbox is unnecessary; if it is of non-zero
size, the parse is deferred until the application is de-iconified.
.TP 8
.B nomailBitmap (\fPclass\fB NomailBitmap)
Specifies the name of a bitmap to display in the icon window when no mail has
arrived (defaults to \fInoletters\fP).  The \fIXmu\fP string-to-bitmap
converter is registered to handle this resource.
.TP 8
.B pollInterval (\fPclass\fB PollInterval)
Specifies the interval in seconds between successive mailbox checks (defaults
to 67 seconds).
.TP 8
.B setTitle (\fPclass\fB SetTitle)
If \fITrue\fP (the default), sets the main window's title, as displayed by the
window manager, to indicate when the mailbox was last altered.  If \fIFalse\fP,
leaves the title unchanged.
.TP 8
.B silent (\fPclass\fB Silent)
If \fITrue\fP don't ring the bell when new mail arrives.
.TP 8
.B soundFile (\fPclass\fB SoundFile)
If on a Sun-4, the name of a file to copy to /dev/audio when new mail arrives.
\fBNOTE\fP that this takes place on the \fIclient\fP host, not the server host.
.SH "SEE ALSO"
mailbox(1),
xbiff(1)
.SH AUTHOR
George Ross, gdmr@dcs.ed.ac.uk
