/*
   
   xpuyopuyo - psound.h       Copyright(c) 2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   xpp sound driver
   

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __psound_h_included
#define __psound_h_included


#include <xpuyopuyo.h>
#ifndef USE_SOUND
   #error USE_SOUND must be defined
#endif /* Sanity check */


#if USE_SOUND
#include <mikmod.h>

#define P_SOUND_BUFFER     0x1000
#define P_SOUND_REVERB     0
#define P_SOUND_EFFECT_VOL 192


typedef enum _p_sound_music {
   P_MUSIC_PRELUDE,
   P_MUSIC_GAME,
   P_MUSIC_ENDGAME
} p_sound_music;



typedef enum _p_sound_effect {
   P_SOUND_PLOP      = -8,
   P_SOUND_CLICKY    = -7,
   P_SOUND_BWOAP     = -6,
   P_SOUND_AGONY_1   = -5,
   P_SOUND_AGONY_2   = -4,
   P_SOUND_PHARTY    = -3,
   P_SOUND_BELCHY    = -2,
   P_SOUND_DEATH     = -1
} p_sound_effect;
#define  P_SFX_VOICE    8



typedef struct _p_sound {
   MODULE *module;
   p_sound_music selection;
   int playing;
   int hqmixer;
   int effects;
   int chan;
} p_sound;



void p_sound_init(void);
p_sound *p_sound_new(int enable, int hqmixer, int effects);
void p_sound_config(p_sound **s, int enable, int hqmixer, int effects);
void p_sound_free(p_sound **s);

void p_sound_start(p_sound *s, p_sound_music id);
void p_sound_update(p_sound *s);
void p_sound_stop(p_sound *s);
void p_sound_pause(p_sound *s);
void p_sound_unpause(p_sound *s);
void p_sound_play_effect(p_sound *s, p_sound_effect id, int player);

#endif /* USE_SOUND? */


#endif /* __psound_h_included */
