/*
 * Copyright (c) 1997, Mark Buser.
 * Copyright (c) 2001, 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/about.c,v 1.6 2003/11/19 19:35:09 danny Exp $
 */
#include <stdio.h>

#include <Xm/XmAll.h>

#include "optupdate.h"
#include "pixmap.h"
#include "xutil.h"

static Widget text;

void aboutText( char *news )
{
  XmTextSetString( text, news ); 
}

/* ARGSUSED */
void procAbout( Widget w, int which, XtPointer call_data )
{
  XtPopdown( GetTopShell(w) );
}

/* ARGSUSED */
void aboutCB( Widget w, XtPointer client_data, XtPointer call_data ) 
{
  static Widget About_dialog;
  Widget pane, frame, form, button;
  Dimension height, width, border;
  Arg args[12];
  int n;

  if (About_dialog == NULL) {
    About_dialog = XtVaCreatePopupShell( "About", 
                                        xmDialogShellWidgetClass,
                                        GetTopShell(w),
                                        NULL );

    /*
    ** This allows the frame to work and the buttons to not cause
    ** the dialog to auto unmanage.  Where is this documented?
    */
    pane = XtVaCreateWidget ( "AboutPane", xmPanedWindowWidgetClass,
                              About_dialog,
                              XmNsashWidth, 1,
                              XmNsashHeight, 1,
                              NULL );

    form = XtVaCreateWidget ( "Aboutform", 
                            xmFormWidgetClass, pane, 
                            NULL );


    frame =   XtVaCreateManagedWidget( "Aboutframe",
                            xmFrameWidgetClass, form,
			    XmNtopAttachment, XmATTACH_FORM,
			    XmNleftAttachment, XmATTACH_FORM,
                            NULL);
    XtVaCreateManagedWidget ( "label_0",
                        xmLabelWidgetClass, frame,
                        XmNlabelType, XmPIXMAP,
                        XmNlabelPixmap, GetPixmap(PICON, NORMAL, XtDisplay(frame)),
                        XmNlabelInsensitivePixmap, GetPixmap(PICON, NORMAL, XtDisplay(frame)),
                        NULL );

    XtVaCreateManagedWidget ( "label_1",
                        xmLabelWidgetClass, form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, frame,
			XmNrightAttachment, XmATTACH_FORM,
                        NULL );

    frame = XtVaCreateManagedWidget( "newsFrame",
                        xmFrameWidgetClass, form,
                        XmNtopAttachment, XmATTACH_WIDGET,
                        XmNtopWidget, frame,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNrightAttachment, XmATTACH_FORM,
                        NULL);
    XtVaCreateManagedWidget ( "newsLabel",
                        xmLabelWidgetClass, frame,
                        XmNchildType, XmFRAME_TITLE_CHILD,
                        NULL );
    /* Scrolled text holding news */
    n = 0;
    XtSetArg(args[n], XmNscrollVertical,        True); n++;
    XtSetArg(args[n], XmNscrollHorizontal,      False); n++;
    XtSetArg(args[n], XmNeditMode,              XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n], XmNeditable,              False); n++;
    XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
    XtSetArg(args[n], XmNautoShowCursorPosition,  False); n++;
    XtSetArg(args[n], XmNwordWrap,  True); n++;
    text = XmCreateScrolledText( frame, "newsText", args, n);
    XtManageChild (text);

    XtManageChild (form);

    /* Button to add ok */
    form = XtVaCreateWidget ( "ButForm", xmFormWidgetClass, pane, NULL );
    button = XtVaCreateManagedWidget ( "button_0",
                              xmPushButtonWidgetClass, form,
                              XmNtopAttachment, XmATTACH_FORM,
                              XmNbottomAttachment, XmATTACH_FORM,
                              XmNleftAttachment, XmATTACH_POSITION,
                              XmNrightAttachment, XmATTACH_POSITION,
                              XmNshowAsDefault, True,
                              XmNdefaultButtonShadowThickness, 1,
                              NULL );
    XtAddCallback ( button, XmNactivateCallback,
                    (XtCallbackProc) procAbout, (XtPointer) 0 );
    XtManageChild (form);
    XtManageChild (pane);

    /* Prevent pane from changing size */
    XtVaGetValues ( About_dialog, 
                    XmNwidth, &width,
                    XmNheight, &height,
                    XmNborderWidth, &border,
                    NULL );

    XtVaSetValues ( About_dialog,
                    XmNminWidth,  width +  border,
                    XmNmaxWidth,  width +  border,
                    XmNminHeight, height + border,
                    XmNmaxHeight, height + border,
                    NULL );
  }

  XtManageChild (About_dialog);
  XtPopup (About_dialog, XtGrabNone);
  triggerUpdate (TRIGGER_NEWS, (XtIntervalId) NULL);
}
