/*
 * Copyright (c) 1996, 1997, 1998, 2000, Mark Buser.
 * Copyright (c) 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/sessionXi.c,v 2.36 2004/12/24 12:59:16 danny Exp $
 */
static const char id[] = "$Header: /pack/anoncvs/xinvest/src/sessionXi.c,v 2.36 2004/12/24 12:59:16 danny Exp $";

#ifndef	XQUOTE
#ifndef	QUOTE_FILTER
#define	XINVEST
#endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/param.h>

#include <Xm/XmAll.h>

#ifdef	XINVEST
#include "account.h"
#include "fileXi.h"
#include "nav.h"
#include "portfolio.h"
#include "xinvest.h"
#include "pref.h"
#endif

#ifdef	XQUOTE
#include "optdetail.h"
#include "optnet.h"
#include "opttick.h"
#include "optupdate.h"
#include "server.h"
#include "tape.h"
#include "view.h"
#include "xutil.h"
#include "xquote.h"
#endif

#include "session.h"
#include "status.h"
#include "util.h"

#ifdef	XQUOTE
#define	XQ_MAJOR	2
#define	XQ_MINOR	1
#else
#define	XI_MAJOR	1
#define	XI_MINOR	2
#endif

#ifdef	QUOTE_FILTER
#include "QuoteFilter.h"
#include "pref.h"
#endif

/* Application defined options that we don't want to save in state file */
XrmOptionDescRec kill_options[] = {
  {
     "-restore", "restore", XrmoptionSepArg, NULL
  }
};

#ifdef	XQUOTE
  int	autonet = 0;
  int	view = 0;
  int	ticks = 0;
#endif
#ifdef	XINVEST
  int updatePort = False;
#endif

void ProcessOneLine(char *);

#ifdef XINVEST
static void SaveFilter(int accno, char *fn, char *template, char *ticker);
static void SaveTemplateLine(char *line);
static void PrintTemplateLines(FILE *savefile);
#endif

int restoreState( char *from )
{
  FILE *savefile;
  char line[QF_LINE_LEN];
  int major, minor;	/* Xinvest/Xquote state file rev */
  int xrev;		/* X11Rx revision */

#ifdef	XQUOTE
  /* Open session file */
  ticks = view = autonet = 0;
#endif
  savefile = fopen ( from, "r");

  if (savefile == NULL) {
    sprintf ( errmsg, 
              "Could not open state file '%s',\nstate not restored.",
              from );
    write_status ( errmsg, ERR);
    return (False);
  }

  /* Read save area version number */
  if ( fgets ( line, QF_LINE_LEN, savefile) ) {
	  /* Skip comment lines */
	  while (line[0] == '#')
		  fgets(line, QF_LINE_LEN, savefile);
	  sscanf ( line, "VERSION %d.%d (X11R%d)\n", &major, &minor, &xrev);
  } else {
    sprintf ( errmsg, 
              "Could not read state file '%s',\nstate not restored.",
              from );
    write_status ( errmsg, ERR);
    return (False);
  }
#ifdef	XQUOTE
  if (major != XQ_MAJOR)
#else
  if (major != XI_MAJOR)
#endif
  {
    sprintf ( errmsg, 
              "Expected version 1.1, not '%d.%d'\n"
              "from state file '%s',\nstate not restored.",
              major, minor, from );
    write_status ( errmsg, ERR);
    return (False);
  }

#ifdef	XQUOTE
  if (minor != XQ_MINOR)
#else
  if (minor != XI_MINOR)
#endif
  {
	  sprintf(errmsg,
			  "Expected state version %d.%d, not '%hd.%hd'\n"
			  "from file '%s',\n"
			  "only restoring compatible state data.",
#ifdef	XQUOTE
			  XQ_MAJOR, XQ_MINOR,
#else
			  XI_MAJOR, XI_MINOR,
#endif
			  major, minor, from);
	  write_status(errmsg, WARN);
  }

  /* Odds are we have a good state file, take note */
  sprintf ( errmsg, "Restoring state saved under X11R%d protocol.", xrev);
  write_status ( errmsg, LOG);

#ifdef	XQUOTE
  /* Lock window manager's concept of app size */
  AllowShellResize(per->Toplevel, LOCK | DISALLOW);
#endif

  while ( fgets(line, QF_LINE_LEN, savefile) ) {
	  ProcessOneLine(line);
  }

#ifdef	XINVEST
  ProcessAccountsForCticker();
  if (updatePort)         /* If any PORTADD, draw in the portfolio display */
    portUpdateDisplay();
#endif
#ifdef	XQUOTE
  if (ticks)
    tickAddMainWindow();

  triggerUpdate ((autonet)?TRIGGER_START:TRIGGER_STOP, (XtIntervalId) NULL);

  if (view)
    viewSet (view);

  AllowShellResize (per->Toplevel, UNLOCK|ALLOW);
#endif

  fclose (savefile);
  return (True);
}

void
ProcessOneLine(char *line)
{
  char *param;
  int account;

    param = strrchr (line, '\n');  /* strip newline */
    if (param)
      *param = '\0';
#ifdef	XQUOTE
    param = strchr(line, ' ');   /* param is after first space */
#else
    param = strrchr(line, ' ');   /* param is after last space */
#endif

    switch (line[0]) {
	    case '#':	/* Comment */
		    break;

	    case 'T':
#ifdef	XQUOTE
			/* "TICK symbol" */
                      if (param) {
                        tickAddItem (++param);
			ticks++;
		      }
                      break;

#endif
#ifdef	QUOTE_FILTER
		      /* TEMPLATE line */
		      ProcessTemplateLine(line);
#endif
#ifdef	XINVEST
			SaveTemplateLine(line);
#endif
		      break;
            case 'C': 
#ifdef	XQUOTE
		      /* CURSERVER which */
		      if (param) {
			int server;
			sscanf ( ++param, "%d", &server);
                        if (server <= numServer()-1)
			  setCurServer (server);
                        else {
                          sprintf (errmsg, 
                                   "Saved quote server does not\n" 
                                   "exist, state not restored.");
                          write_status (errmsg, ERR);
                          return;
                        }
		      }
#else
                      if (strncmp (line, "CWD", 3) == 0) {
                        /* "CWD path" */
#ifdef	XINVEST
                        if (param)
                          loadfile(++param);
#endif
                      } else if (strncmp (line, "CURROPT", 7) == 0) {
                        /* "CURROPT menu_num" */
                        if (param) {
                          sscanf ( param, "%d", &account );
                          prefSetCurr (account);
                        }
                      
                      } else if (strncmp (line, "CURRCHAR", 8) == 0) {
                        /* "CURRCHAR string" */
			/* Don't use param as embedded white space is possible*/
			char *currChar = strtok (line, "\"");
                        if ( (currChar = strtok(NULL, "\"")) ) {
                          prefSetCurrChar (currChar);
			}

                      } else if (strncmp (line, "CURRUSE", 8) == 0) {
                        /* "CURRUSE 0/1" */
                        if (param) {
                          sscanf ( param, "%d", &account );
                          prefSetUseCurr (account);
			}
                      }
#endif
                      break;

            case 'D': 
#ifdef	XINVEST
                      if (strncmp (line, "DISPLAY", 7) == 0) {
                        /* "DISPLAY account" */
                        if (param) {
                          /* "DISPLAY account" */
                          sscanf ( param, "%d", &account );
                          displayAccount ( account );
                        }

                      } else if (strncmp (line, "DATEOPT", 7) == 0) {
                        /* "DATEOPT menu_num" */
                        if (param) {
                          sscanf ( param, "%d", &account );
                          prefSetDate (account);
                        }
                      }
#endif
#ifdef	XQUOTE
		      	/* "DETAIL which" */
		      if (param) {
			      	int state = 0;
				sscanf(++param, "%d", &state);
				detailSetState(state);
				detailAddMainWindow();
		      }
#endif
                      break;

            case 'F': /* "FILEBACK 0/1 extension" */
#ifdef	XINVEST
                      {
                        int on;
                        char ext[10];
                        sscanf (line, "FILEBACK %d %9s", &on, ext);
                        prefSetBack (on?1:0, ext);
                      }
#endif
                      break;

            case 'L': /* "LOAD account path" */
		      {
			      char	fn[MAXPATHLEN], template[64], ticker[64];
			      int	accno, num, r;

			      fn[0] = template[0] = ticker[0] = '\0';
			      num = 0;
			      r = sscanf(line, "LOAD %d %s %s %n", &accno, fn, template, &num);
			      /*
			       * Figure out when num didn't get a value because the input
			       * string isn't reaching far enough.
			       */
			      if (r == 3)
				      strncpy(ticker, line+num, 64);
			      else
				      ticker[0] = '\0';
			      ticker[63] = '\0';
#ifdef	XINVEST
			      account = loadfile(fn);
			      if (account)
				processAccount (account);
			      SaveFilter(accno, fn, template, ticker);
#endif
#ifdef	QUOTE_FILTER
			      AddFilter(fn, template, ticker);
#endif
		      }
                      break;

            case 'N': /* "NAV account mm/dd/yyyy n.n" */
#ifdef	XINVEST
                      {
                        NAV *navp;
                        char date[11];
                        double value;

                        sscanf ( line, "NAV %d %s %lf", &account, date, &value);
                        getAccount ( account, ACCOUNT_NAV, &navp );
                        setNav ( navp, NAV_DATE, date);
                        setNav ( navp, NAV_VALUE, &value);
                      }
#endif
                      break;

            case 'P': 
#ifdef	XINVEST
                      if (strncmp (line, "PORTADD", 7) == 0) {
                        /* "PORTADD account" */
                        if (param) {
                          sscanf ( param, "%d", &account );
                          portAccount ( account, PORT_ADD );
                          updatePort = True;
                        }
                      } else if (strncmp (line, "PREC", 4) == 0) {
                        /* "PREC digits" */
                        if (param) {
                          sscanf (param, "%d", &account);
                          prefSetPrec (account);
                        }
                      }
#endif
#ifdef	XQUOTE
		      /* "PROXY host port" */
                      if (param) {
			char *host, *port; 
			host = XtCalloc ( 1, strlen(++param)+1 * sizeof(char));
			port = XtCalloc ( 1, strlen(param)+1 * sizeof(char));

			if (host && port) {
			  sscanf ( param, "%s %s", host, port );
                          setProxy (host, port);
			}
			XtFree (host);
			XtFree (port);
                      }
#endif
                      break;

#ifdef	XQUOTE
            case 'A': /* "AUTO on minutes" */
                      if (param) {
			int min;
			sscanf (++param, "%d %d", &autonet, &min);
			updateSetAuto (autonet, min);
                      }
                      break;
            case 'R': /* "RANGE day start_hour end_hour" */
		      if (param) {
			int d, s, e;
			sscanf (++param, "%d %d %d", &d, &s, &e);
			updateSetTime (d, s, e);
                      }
                      break;

	    case 'S': /* SCROLL smooth delay */
		      if (param) {
			int	smooth, delay;
			sscanf(++param, "%d %d", &smooth, &delay);
			tapeSetScroll(smooth, delay);
	              }
		      break;

	    case 'V': /* VIEW which */
		      if (param)
			sscanf ( ++param, "%d", &view);
		      break;
#endif
	    case 'U':
#ifdef	XINVEST
		      /* Live Update */
		      {
			      int	v;
			      sscanf(line, "UPDATE %d", &v);
			      prefSetLiveUpdateInterval(v);
		      }
#endif
		      break;
#ifdef	XQUOTE
	    case 'M':
		      if (strncmp(line, "MAIL ", 5) == 0)
			      prefSetMailCommand(line+5);
		      break;
#endif
            default:  break;
    }
}


#ifndef	QUOTE_FILTER
int saveState (char *to)
{
	FILE	*savefile;
	char	*oldfile, *mailcmd, *item, *host, *fileExt, *currChar;
	int	l, num, port, autonet, min, d, s, e, smooth, delay, tape;
#ifndef	XQUOTE
	char	*cwdpath;
	int	pathlen = path_length();
	int	account;
#endif
	static int log = True;

	if (log) {
		sprintf(errmsg, "Saving state under X11R%d protocol.", XtSpecificationRelease);
		write_status(errmsg, LOG);
		log = False;
	}

	/*
	* Fallback : move the old file to a different name
	*/
	l = strlen(to);
	oldfile = XtMalloc(l + 10);
	sprintf(oldfile, "%s.bck", to);
	rename(to, oldfile);
	XtFree(oldfile);

	/* 
	** Create session file 
	*/
	if ((savefile = fopen(to, "w")) == NULL) {
		sprintf(errmsg, "Could not open state file '%s',\nstate not saved.", to);
		write_status(errmsg, ERR);
		return False;
	}

	/* 
	** Save save area version number 
	**	1.1 was file format before liveupdate-save function.
	**	1.2 introduced January 2004
	*/
	fprintf ( savefile, "VERSION %d.%d (X11R%d)\n",
#if defined(XQUOTE)
		XQ_MAJOR, XQ_MINOR,
#else
		XI_MAJOR, XI_MINOR,
#endif
		XtSpecificationRelease);

#ifdef	XQUOTE
	/* Save which server used FIRST */
	fprintf(savefile, "CURSERVER %d\n", getCurServer());

	/* Save Ticker Symbols */
	for (num=0; num < tickGetNum(); num++)
		if ((item = tickGetItem(num))) {
			fprintf(savefile, "TICK %s\n", item);
			XtFree(item);
		}

	/* Save detail setting */
	fprintf(savefile, "DETAIL %d\n", detailGetState(-1));

	/* Save proxy info */
	getProxy(&host, &port);
	if (host)
		fprintf(savefile, "PROXY %s %d\n", host, port);

	/* Save auto update. Must be saved _after_ proxy save */
	updateGetAuto(&autonet, &min);
	fprintf(savefile, "AUTO %d %d\n", autonet, min);

	/* Save time range. */
	updateGetTime(&d, &s, &e);
	fprintf(savefile, "RANGE %d %d %d\n", d, s, e);

	/* Save tape scroll. */
	tapeGetScroll(&smooth, &delay);
	fprintf(savefile, "SCROLL %d %d\n", smooth, delay);

	/* Save tape or table view */
	tape = viewGet();
	fprintf(savefile, "VIEW %d\n", tape);

	/* Save mail command */
	mailcmd = prefGetMailCommand();
	fprintf(savefile, "MAIL %s\n", mailcmd);
#endif

#ifdef	XINVEST
	/* 
	** Save CWD 
	*/
	cwdpath = XtCalloc(pathlen, sizeof(char));
	if (cwdpath == NULL) {
		write_status("Memory allocate error, save\nstate file is not complete.", ERR);
		fclose(savefile);
		return False;
	}

	/* Get full path */
	if (getcwd(cwdpath, pathlen)) 
		fprintf(savefile, "CWD %s\n", cwdpath);
	else {
		write_status("CWD length greater than maximum,\nsave state file is not complete.",
			ERR);
		fclose(savefile);
		return False;
	}
	XtFree(cwdpath);

	PrintTemplateLines(savefile);

	for (account = 1; account <= numAccounts(); account++) {
		/* 
		** Save account info 
		*/
		saveAccount ( savefile, account );

		/* 
		** Save what's in the portfolio 
		*/
		if (accountStatus(account, ACCOUNT_IN_PORTFOLIO))
			fprintf(savefile, "PORTADD %d\n", account);
	}

	if (numAccounts())
		fprintf (savefile, "DISPLAY %d\n", activeAccount() );


	/* Save Preferences */
	if (prefGetBack(&fileExt))
		fprintf(savefile, "FILEBACK 1 %s\n", fileExt);
	else
		fprintf(savefile, "FILEBACK 0 %s\n", fileExt);

	fprintf(savefile, "DATEOPT %d\n", prefGetDate());
	fprintf(savefile, "CURROPT %d\n", prefGetCurr());

	currChar = prefGetCurrChar();
	if (currChar)
		fprintf(savefile, "CURRCHAR \"%s\"\n", currChar);

	fprintf(savefile, "CURRUSE %d\n", prefGetUseCurr());
	fprintf(savefile, "PREC %d\n", prefGetPrec());

	fprintf(savefile, "UPDATE %d\n", prefGetLiveUpdateInterval());
	/* 
	* Things we don't save:
	* 1. Menu settings - zoom, et al
	* 2. Tool settings - graph selections, et al
	*/
#endif

	fclose(savefile);
	return True;
}
#endif

#ifdef	XINVEST
/*
 * Three functions to save QuoteFilter-specific stuff in Xinvest
 * so Xinvest can rewrite its configuration file without losing
 * information.
 */
static int	an = 0;
typedef struct save_filter {
	char *fn, *template, *ticker;
} save_filter;
static struct save_filter *saved_filters = NULL;

static void SaveFilter(int accno, char *fn, char *template, char *ticker)
{
	if (an <= accno) {
		int	i, oan;
		oan = an;
		an = accno + 5;	/* if the lines are out of order, this may increase a LOT */
		saved_filters = (save_filter *)XtRealloc((void *)saved_filters,
				sizeof(save_filter) * an);
		for (i=oan; i<an; i++)
			saved_filters[i].fn =
				saved_filters[i].template =
				saved_filters[i].ticker = NULL;
	}
	saved_filters[accno].fn = strdup(fn);
	saved_filters[accno].template = strdup(template);
	saved_filters[accno].ticker = strdup(ticker);
}

void SaveAccountAndTemplate(FILE *savefile, int index, char *filename)
{
	if (saved_filters && saved_filters[index].fn) {
		fprintf(savefile, "LOAD %d %s %s %s\n", index, filename,
				saved_filters[index].template,
				saved_filters[index].ticker);
	} else
		fprintf(savefile, "LOAD %d %s\n", index, filename);
}

static int	nlines = 0, save_lineno = 0;
static char	**save_lines = NULL;

static void SaveTemplateLine(char *line)
{
	if (nlines <= save_lineno) {
		nlines += 10;
		save_lines = realloc(save_lines, nlines * sizeof(char *));
	}
	save_lines[save_lineno++] = strdup(line);
}

static void PrintTemplateLines(FILE *savefile)
{
	int	i;

	for (i=0; i<save_lineno; i++)
		fprintf(savefile, "%s\n", save_lines[i]);
}
#endif
