package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

class ConcatFunction implements Function {
  public ConvertibleExpr makeCallExpr(ConvertibleExpr[] args, Node exprNode) throws ParseException {
    final StringExpr[] se = new StringExpr[args.length];
    for (int i = 0; i < se.length; i++)
      se[i] = args[i].makeStringExpr();
    return new ConvertibleStringExpr() {
      public String eval(Node node, ExprContext context) throws XSLException {
	StringBuffer buf = new StringBuffer();
	for (int i = 0; i < se.length; i++)
	  buf.append(se[i].eval(node, context));
	return buf.toString();
      }
    };
  }
}
