package com.jclark.xsl.tr;

import com.jclark.xsl.om.*;
import java.io.IOException;
import java.net.URL;

public class EngineImpl extends NameTableImpl implements Engine, LoadContext {
  final private XMLProcessor parser;
  final private ExtensionHandler extensionHandler;
  final private Name XSL_TEXT;
 
  public EngineImpl(XMLProcessor parser, ExtensionHandler extensionHandler) {
    this.parser = parser;
    this.extensionHandler = extensionHandler;
    XSL_TEXT = createName("xsl:text", SheetImpl.XSL_NAMESPACE);
  }

  public Sheet createSheet(Node node) throws IOException, XSLException {
    return new SheetImpl(node, parser, extensionHandler, this, this);
  }

  public boolean getStripSource(Name elementTypeName) {
    return !XSL_TEXT.equals(elementTypeName);
  }

  public boolean getIncludeComments() {
    return false;
  }

  public boolean getIncludeProcessingInstructions() {
    return false;
  }

  public LoadContext getSheetLoadContext() {
    return this;
  }

  public NameTable getNameTable() {
    return this;
  }
}
