#ifndef tolle_uhr_h
#define tolle_uhr_h

/* Form des Ziffernblattes */
enum
{
    CF_OVAL = 1, CF_RECT
};

/* Welche Ziffern sollen erscheinen */
enum
{
CF_NONE = 0, CF_MINUTES = 1, CF_HOUR = 5, CF_QUARTER = 15, CF_TWELFE = 60};

/* Wie sehen die Zeiger aus */
enum
{
    HS_LINE = 1, HS_TRIANGLE, HS_RHOMBUS, HS_RECTANGLE
};
enum
{
    HS_VERY_THIN = 0, HS_THIN, HS_NORMAL, HS_THICK, HS_VERY_THICK
};

/* Uhrenrand */
enum
{
    CB_NONE = 1, CB_SINGLE, CB_DOUBLE
};

/* Piepsen */
enum
{
    CH_NONE = 1, CH_HOURS, CH_QUARTERS
};

/* Zifferblatt- "striche" */
enum
{
    CF_ORIGINAL = 1, CF_ROUND
};

/* Farben */

/*
 * take care, CO_MINAREA und CO_HOURAREA have to be the same as AR_MIN and
 * AR_HOUR. And CO_MINAREA and CO_HOURAREA must have an offset of 2 to
 * CO_MINOUTLINE and CO_HOUROUTLINE
 */
enum
{
    CO_SECONDS = 0, CO_MINAREA, CO_HOURAREA, CO_MINOUTLINE, CO_HOUROUTLINE,
    CO_SHADOW, CO_TWELFE, CO_QUARTER, CO_HOUR, CO_MINUTES,
    CO_RESIZE, CO_COMMON, CO_LAST
};

/* Flaechen */
enum
{
    AR_BG = 0, AR_MIN, AR_HOUR, AR_LAST
};

struct xpoints
{
    XPoint          p[5];
};

struct settings_struct
{
	char	*display;			/* Display									*/
	char	*configfile;		/* alternatives Konfigurationsfile			*/
	int		seconds;			/* Sekundenzeiger ja/nein					*/
	int		clockface_shape;	/* ovales oder rechtwinkliges Ziffernblatt	*/
	int		clockface_digits;	/* welche Ziffern sind zu zeichnen			*/
	int		hands_type;			/* Form der Zeiger							*/
	int		hands_width;		/* Dicke der Zeiger							*/
	int		shadow;				/* Schatten fuer Zeiger						*/
	int		border;				/* Rand der Uhr								*/
	int		chime;				/* Stundenpiepser							*/
	int		alarm;				/* Wecker									*/
	int		immovable;			/* Fenster laesst sich nicht bewegen		*/
	int		bw;					/* Randbreite								*/
	int		shapes;				/* Form der Ziffernblattstriche				*/
	char	*pixmaps[AR_LAST];	/* Name der Hintergrundpixmap				*/
	int		use_pm_size;		/* Benutze die Groesse der Pixmap			*/
	int		x, y, w, h;			/* Geometrie des Fensters					*/
	int		sleep;				/* Schlafzeit fuer Windowrefresh			*/
	char	*color[CO_LAST];	/* Zeichenfarben							*/
	int		wm;					/* Nutzen des Windowmanagers				*/
	char	*geometry;			/* initiale Groesse und Position			*/
	int		shext;				/* benutze ShapeExtension					*/
};

struct win_struct
{
	Display        *dsp;
	Window          rwin, win;
	Colormap        cmap;
	Visual         *visual;
	XCC             xcc;
	GC              gc[CO_LAST];
	Pixmap          pixmap, hidden_pm, shape_pm;
#ifdef USE_PIXMAPS
	Pixmap          pixmaps[AR_LAST];
	int             pmok[AR_LAST];
#endif
#ifdef USE_IMLIB
	ImlibData       *id;
	ImlibImage      *im;
#endif
	unsigned long   fg, bg;
	char           *display_name;
	char           *progname;
	int             done, screen, depth;
	unsigned int    width, height;
	int             winx, winy;
	unsigned long   pixel[CO_LAST];
	time_t          localTime, enterTime;
	Bool            resizing, moving;
	Bool            first_resizer;
	struct xpoints  oldpoints;
};

void            TimerHandler();
void            KillHandler();
void            HupHandler();
void            FreeColorsAndPixmaps();
void            MakeWindow();
void            DestroyWindow();
void            StartTimer();
void            Redraw();
void            DrawClockFace();
void            DrawHands(int angle, int lfactor, int offset, int what, int helper);
void            DrawBorder();
void            HandleKeypress(int i, char *text);
void            GetPixmap();
Pixmap          ReallyGetPixmap(char *filename);
void            UpdateBackground();
void            UpdatePixmapSize();
void            ResizePixmap(Pixmap *pm, int width, int height);
void            StartResizing();
void            ResizeTo(int x, int y);
void            EndResizing();
void            DrawResizerLines(struct xpoints p);
void            StartMoving();
void            MoveTo(int x, int y);
void            EndMoving();
void            GetWindowStack();
void            ResetWindowStack();
int             CreateBitmapFromPixmap();

#ifdef USE_PIXMAPS
void            ResizeToPmSize();
#endif

void            SetDefaults();
void            ParseXdefaults();
void            ParseRcFile();
void            ParseCmdLine(int argc, char **argv, int only_watch_for_display);
void            ParseOptions(char *opt, char *arg);
void            parseColors();
void            Usage();
int             Truecheck(const char *string);
void            SetColorsAndDC();
int             CheckDisplay(const char *string);
int             CheckConfigFile(const char *string);
int             CheckGeometry(const char *string);
int             ReallyCheckGeometry(const char *string);
int             CheckSeconds(const char *string);
int             CheckClockFace(const char *string);
int             CheckDigits(const char *string);
int             CheckHands(const char *string);
int             CheckHandsWidth(const char *string);
int             CheckShadow(const char *string);
int             CheckBorder(const char *string);
int             CheckBorderWidth(const char *string);
int             CheckChime(const char *string);
int             CheckImmovable(const char *string);
int             CheckForm(const char *string);
int             CheckBgPixmap(const char *string);
int             CheckSleepTime(const char *string);
int             CheckResizeToPmSize(const char *string);
int             CheckSecondsColor(const char *string);
int             CheckMinAreaColor(const char *string);
int             CheckMinAreaPixmap(const char *string);
int             CheckMinOutlineColor(const char *string);
int             CheckHourAreaColor(const char *string);
int             CheckHourAreaPixmap(const char *string);
int             CheckHourOutlineColor(const char *string);
int             CheckShadowColor(const char *string);
int             CheckTwelfeColor(const char *string);
int             CheckQuarterColor(const char *string);
int             CheckHourColor(const char *string);
int             CheckMinutesColor(const char *string);
int             CheckWm(const char *string);
int             CheckShext(const char *string);
int 
CheckCrossing(int x1, int x2, int y1, int y2,
	      unsigned int w1, unsigned int w2,
	      unsigned int h1, unsigned int h2);
int             HandleXError(Display * dsp, XErrorEvent * event);

#endif
