/*                                                                                                                                       
// YAP2LC - an LDAP migration tool                                                                                                        
//                                                                                                                                        
// yap2lc_log.c                                                                                                                              
// License: GPL                                                                                                                           
// Author: Radu Negut <radun@romsys.ro>                                                                                                   
// Version: 0.5.9 [23.12.2003]                                                                                                            
// Section: the log handler and builder,
//	    help screen                                                                                                        
*/

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include "yap2lc.h"

#define USAGE	\
"\nYAP2LC -- Yet another passwd 2 LDIF convertor\n\
2003 Radu Negut <radun@romsys.ro>\n\
Licensed under the terms of the GPL\n\n\
Usage:\n\t-p\tUse pipes; yap2lc will read the LDIF template from stdin\n\
\t\toptionally read yap2lc.conf and write the ldif to stdout\n\
\t-c\tapply configuration from ./yap2lc.conf in pipe mode\n\
\t-l\twrite log to logfile from ./yap2lc.conf while in pipe mode\n\
\t-d\tread passwd and shadow files from default locations\n\
\t\t(e.g. /etc/passwd) instead of current directory. This switch\n\
\t\tis useless on BSD-style systems\n\
\t-h\tprint this lovely help screen\n\
\nE.g.: cat ldif.template | ./yap2lc -pcl | some_program\n\n"

extern global_t global;

int
commit_log(char *uname, int uid, int code)
{
    char buf[MAX_NAME_LEN];
    if((global.pipelined < 4 && global.pipelined != 0) || global.pipelined == 9 || global.pipelined == 11)
	return 0;
    bzero(buf, MAX_NAME_LEN);
    strncpy(buf, uname, strlen(uname));
    if(strlen(uname) > 8)
    	strcat(buf, "\t:");
    else
	strcat(buf, "\t\t:");
    sprintf(&buf[strlen(buf)], "%d", uid);
    strcat(buf, "\t:");
    switch(code)
	{
	 case NOCN:
	     if(global.lognocn != 1)
	         return 0;
	     strcat(buf, "missing real name\n");
	     break;
	 case NOPWD:
	     if(global.lognopwd != 1)
	         return 0;
	     strcat(buf, "account unpassworded\n");
	     break;
	 case NOGRP:
	     if(global.igngrperr == 1)
	         return 0;
	     strcat(buf, "invalid group association\n");
	     break;
	 case DUPLICATE:
	     if(global.logduplicates != 1)
	         return 0;
	     strcat(buf, "duplicate real name entry\n");
	     break;
	 case WRONGCN:
	     if(global.lognocn != 1)
	         return 0;
	     strcat(buf, "invalid real name entry\n");
	     break;
	 case LOCKEDOUT:
	     if(global.lognopwd != 1)
	         return 0;
	     strcat(buf, "account locked out\n");
	     break;
	 case RGXFAIL:
	     if(global.logregexp != 1)
	        return 0;
	     strcat(buf, "account matches regex\n");
	     break;
	 case UGIDFAIL:
	     if(global.logugids != 1)
	         return 0;
	     strcat(buf, "UID range or GID exclusion\n");
	     break;
	 default:
	     strcat(buf, "entry removed for unknown reason\n");
	     break;
	}
    if((fwrite(buf, sizeof(char), strlen(buf), global.logfp)) < strlen(buf))
	printf("Unable write log entry...\n");
    return 0;
}

void
vanity_table(u_long time, int code)
{
   printf("\n\n+============================================================+\n");
   printf("|                  YAP2LC v.0.5.9 STATISTICS                 |\n");
   printf("|============================================================|\n");
   printf("| Committed entries:     %10lu | Time: ", global.counter);
   if(code == MSECS)
	printf("%10lu msecs |\n", time);
   else
	printf("%10lu secs  |\n", time);
   print_line(MIDLINE);
   printf("| Locked out accounts:   %10lu | Logged: ", global.lockedout);
   if(global.lognopwd == 1)
	printf("yes            |\n");
   else
	printf("no             |\n");
   print_line(MIDLINE);
   printf("| Missing real name:     %10lu | Logged: ", global.nocn);
   if(global.lognocn == 1)
	printf("yes            |\n");
   else
	printf("no             |\n");
   print_line(MIDLINE);
   printf("| Unpassworded accounts: %10lu | Logged: ", global.unpassworded);
   if(global.lognopwd == 1)
	printf("yes            |\n");
   else
	printf("no             |\n");
   print_line(MIDLINE);
   printf("| GID exclusions:        %10lu | Logged: ", global.gidexcluded);
   if(global.logugids == 1)
	printf("yes            |\n");
   else
	printf("no             |\n");
   print_line(MIDLINE);
   printf("| Duplicate entries:     %10lu | Logged: ", global.duplicates);
   if(global.logduplicates == 1)
	printf("yes            |\n");
   else
	printf("no             |\n");
   print_line(MIDLINE);
   printf("| Regexp filtered:       %10lu | Logged: ", global.regexpfiltered);
   if(global.logregexp == 1)
	printf("yes            |\n");
   else
	printf("no             |\n");
   printf("|============================================================|\n");
   if(global.sanitize == 1)
	printf("| Sanitize: yes                | Remove duplicates: ");
   else
	printf("| Sanitize: no                 | Remove duplicates: ");
   if(global.remduplicates == 1)
	printf("yes      |\n");
   else
	printf("no       |\n");
   print_line(LOWLINE);
   if(global.allownopwd == 1)
	printf("| Allow unpassworded: yes      | Allow locked out: ");
   else
	printf("| Allow unpassworded: no       | Allow locked out: ");
   if(global.allowlockedout == 1)
	printf("yes       |\n");
   else
	printf("no        |\n");
   print_line(LOWLINE);
   printf("| Min. allowed UID: %10lu | Max. allowed UID:%10lu |\n", global.min_uid, global.max_uid);
   print_line(LOWLINE);
   if(global.idacstat == 1)
	printf("| Id account status: yes       | Filter by regexp: ");
   else
	printf("| Id account status: no        | Filter by regexp: ");
   if(global.regexpfilter == 1)
	printf("yes       |\n");
   else
	printf("no        |\n");
   print_line(LOWLINE);
   printf("| Total processed:  %10lu | Total sanitized: %10lu |\n", global.baddies + global.counter, global.baddies);
   printf("+============================================================+\n\n");
   printf("LDIF file: %s\nLog file: %s\n\n", global.outfile, global.logfile);
}

void
print_line(int code)
{
    if(code == MIDLINE) 
    	printf("|-----------------------------------|------------------------|\n");
    else
	printf("|------------------------------------------------------------|\n");
}

void
usage(void)
{
    printf(USAGE);
}


