/*
// YAP2LC - an LDAP migration tool
//
// yap2lc_mals.c
// License: GPL
// Author: Radu Negut <radun@romsys.ro>
// Version: 0.5.9 [23.12.2003]
// Section: mail alias processing,
//	    database extraction, database upgrading
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <limits.h>
#include <errno.h>
#ifdef NDBM
#include <ndbm.h>
#endif
#ifdef BDB
#include <db.h>
#include <unistd.h>
#endif
#ifdef CDB
#include "yap2lc_cdb.h"
#endif
#include "yap2lc.h"

extern global_t global;

void
mals_assembly(char *uname, char *apdx, char *assembly)
{
    char domain[MAX_INDEX_SIZ];
    char mals[MAX_MALS_SIZ];
    char shifter[MAX_NAME_LEN];
    int x;
#ifdef BDB
    DBT key, data;
    int bdbret;
    char buf[MAX_MALS_SIZ];
#endif
#ifdef NDBM
    datum nkey, ndata;
#endif
    global.havemals = 0;
    memset((void *)mals, '\0', MAX_MALS_SIZ);
    for(x = 0; x < MAX_INDEX_SIZ; x++)
	{
	 if(apdx[x] == '\n')
	     {
	      domain[x] = '\0';
	      break;
	     }
	 domain[x] = apdx[x];
	}
    x = strlen(domain) + 1; 
/* the 1 is to get rid of the newline; while this is irrelevant to LDAP, esthetically the impact is great :) */
#ifdef BDB
    if(global.malsdbtype == YAP2LC_DB_BDB)
	{
	 if((bdbret = global.db_handle->cursor(global.db_handle, NULL, &global.cursor, 0)) != 0)
	      db_fatal(bdbret, "unable to get database cursor");
	 while((bdbret = global.cursor->c_get(global.cursor, &key, &data, DB_NEXT)) == 0)
	     {
	      memmove(buf, (char *)data.data, (int)data.size);
	      buf[(int)data.size] = '\0';
	      if(strstr(data.data, uname) != NULL)
	          {
		   strcat(mals, global.malstring);
		   strncat(mals, (char *)key.data, (int)key.size);
		   strcat(mals, domain);
		   strcat(mals, "\n");
		   memcpy(shifter, (char *)key.data, (int)key.size);
		   shifter[(int)key.size] = '\0';
		   /* nested alias processing */
		   unnest(0, mals, shifter, domain);
		  }
	     }
	 if((bdbret = global.cursor->c_close(global.cursor)) != 0)
	     db_fatal(bdbret, "unable to close database cursor");
	}
#endif
#ifdef NDBM
    if(global.malsdbtype == YAP2LC_DB_NDBM)
	{
	 for(nkey = dbm_firstkey(global.ndbm_handle); nkey.dptr != NULL; \
	 nkey = dbm_nextkey(global.ndbm_handle))
	     {
	      ndata = dbm_fetch(global.ndbm_handle, nkey);
	      if(strstr(ndata.dptr, uname) != NULL)
	          {
		   flag++;
		   strcat(mals, global.malstring);
		   strncat(mals, nkey.dptr, nkey.dsize);
		   strcat(mals, domain);
		   strcat(mals, "\n");
		  }
	     }
	}
#endif
#ifdef CDB
    if(global.malsdbtype == YAP2LC_DB_CDB)
	{
	 printf("No CDB code yet available; maybe later on. Sorry.\n");
	}
#endif
/* this cruft is here so there's no exception code necessary for the template
    parsing loop, to get rid of the @domain.xxx non-token in $MLS@domain.xxx */
    mals[strlen(mals) - (strlen(domain) + 1)] = '\0';
    strcat(assembly, mals);
    if(strlen(mals) == 0)
	global.havemals = x;
}

void
yap2lc_dbopen()
{
#ifdef BDB
    int bdbret;
#endif
    if((global.malsdbtype == YAP2LC_DB_NDBM && global.dbsupport == 2) || \
       (global.malsdbtype == YAP2LC_DB_BDB && global.dbsupport < 2) || \
        global.malsdbtype == YAP2LC_DB_UNDEF)
	{
	 printf("Yap2lc hasn't been compiled with support for the requested database type.\n");
	 printf("Either drop alias processing or add necessary database support to yap2lc.\n");
	 exit(-1);
	}
#ifdef BDB
    if(global.malsdbtype == YAP2LC_DB_BDB)
	{
	 if((db_create(&global.db_handle, NULL, 0)) != 0)
	     db_fatal(0, "unable to create database handle");
	 bdbret = yap2lc_cond_dbopen();
	 switch(bdbret)
	     {
	      case 0: /* things went smoothly... */
	          break;
	      case DB_OLD_VERSION: /* let's try an upgrade and give it another shot */
	          if(yap2lc_dbupgrade() != 0)
		      db_fatal(bdbret, "unable to continue due to failed database upgrade");
		  if(yap2lc_cond_dbopen() != 0)
		      db_fatal(bdbret, "unable to reopen databse after upgrade");
		  printf(" Succeeded!\n\n");
		  break;
	      default:
	          db_fatal(bdbret, "all attempts at opening the database have failed");
	     }
	 if((db_create(&global.preproc_dbhandle, NULL, 0)) != 0)
	    db_fatal(0, "unable to get preprocessing handle in processing stage");
#if YAP2LC_DBAPI_SHORT_OPEN == 0
	 if((bdbret = global.preproc_dbhandle->open(global.preproc_dbhandle, NULL, global.localiases, NULL, DB_UNKNOWN, DB_RDONLY, 0660)) != 0)
#else
	 if((bdbret = global.preproc_dbhandle->open(global.preproc_dbhandle, global.localiases, NULL, DB_UNKNOWN, DB_RDONLY, 0660)) != 0)
#endif
	    db_fatal(0, "unable to open preprocessing DB in processing stage");
	}
#endif
#ifdef NDBM
    if(global.malsdbtype == YAP2LC_DB_NDBM)
	if((global.ndbm_handle = dbm_open(global.localiases, O_RDONLY, 0660)) == 0)
	    db_fatal(0, "unable to get NDBM handle");
#endif
#ifdef CDB
    if(global.malsdbtype == YAP2LC_DB_CDB)
	{
	 if((global.cdb_fd = open(global.localiases, O_RDONLY)) < 0)
	    db_fatal(0, "unable to get CDB descriptor"); 
	 cdb_init(global.cdb_handle, global.cdb_fd);
	}
#endif
}

#ifdef BDB
int
yap2lc_cond_dbopen()
{
    int bdbret;
    DBTYPE *type;
#if YAP2LC_DBAPI_SHORT_OPEN == 0
    bdbret = global.db_handle->open(global.db_handle, NULL, global.localiases, NULL, DB_UNKNOWN, DB_RDONLY, 0660);
#else
    bdbret = global.db_handle->open(global.db_handle, global.localiases, NULL, DB_UNKNOWN, DB_RDONLY, 0660);
#endif
    return bdbret;
}
#endif

void
db_fatal(int errcode, const char *errstr)
{
    if(errcode > 0)
	{
#ifdef BDB
	 fprintf(stderr, "Error: %s\n", db_strerror(errcode));
#endif
	 yap2lc_dbclose();
	 printf("Yap2lc has encountered fatal errors in database processing:\n-> %s\n", errstr);
	 exit(-1);
	}
    printf("Error: %s\n", errstr);
    printf("Unable to open specified database file or wrong database type. Exiting.\n");
    exit(-1);
}

void
yap2lc_dbclose()
{
#ifdef BDB
    if(global.malsdbtype == YAP2LC_DB_BDB)
	{
	 global.db_handle->close(global.db_handle, 0);
	 global.preproc_dbhandle->close(global.preproc_dbhandle, 0);
	}
#endif
#ifdef NDBM
    if(global.malsdbtype == YAP2LC_DB_NDBM)
	dbm_close(global.ndbm_handle);
#endif
#ifdef CDB
    if(global.malsdbtype == YAP2LC_DB_CDB)
	cdb_free(global.cdb_handle);
#endif
}

#ifdef BDB
#define UPG_WARNING	\
"Specified database must be upgraded before it can be used. Upgrading a database when you\n\
are running out of disk space or memory will CORRUPT the database. Use BACKUPS!!!\n\
Byte order is very important; if the database was created on a big endian machine and an upgrade\n\
is attempted on a little endian machine, this will corrupt the database.\n\n\
Do you want to attempt upgrading the database? [y/n]: "

int
yap2lc_dbupgrade()
{
    char c;
    int ret;
/* NEVER upgrade in pipeline mode!!!*/
    if(global.pipelined > 0)
	{
	 printf("Database upgrading is not available in pipeline mode, since it is DANGEROUS. Aborting!\n");
	 exit(-1);
	}
    printf(UPG_WARNING);
    scanf(" %c", &c);
    if(c != 'y')
	{
	 printf("\nYap2lc cannot process the specified database in its current format. Sorry.\n");
	 exit(-1);
	}
    ret = global.db_handle->upgrade(global.db_handle, global.localiases, DB_DUPSORT);
    switch(ret)
	{
	 case DB_OLD_VERSION:
	     printf("\nSorry, the database cannot be upgraded by this version of the Berkeley DB API.\n");
	     return -1;
	 case EINVAL:
	     printf("\nThe database is in a different byte order than the host, there is a sorted\n");
	     printf("duplicate mismatch or an invalid parameter was passed on. Upgrade failed!\n");
	     return -1;
	 default:
	     printf("\nUpgrade successful! Reattempting to get a handle on the database...");
	     break;
	}
    return 0;
}

int
unnest(int flag, char *mals, char *shifter, char *domain)
{
    DBC *locursor;
    DBT key, data;
    int intim_flag = 0;
    char buf[MAX_NAME_LEN];
    memset(&key, 0, sizeof(key));
    memset(&data, 0, sizeof(data));
    global.preproc_dbhandle->cursor(global.preproc_dbhandle, NULL, &locursor, 0);
    while(locursor->c_get(locursor, &key, &data, DB_NEXT) == 0)
	{
	 if(strstr(data.data, shifter) != NULL)
	    {
	     if(strstr(mals, key.data) != NULL)
	        continue;
	     strcat(mals, global.malstring);
	     strncat(mals, (char *)key.data, (int)key.size);
	     strcat(mals, domain);
	     strcat(mals, "\n");
	     flag++;
	     memcpy(buf, (char *)key.data, (int)key.size);
	     buf[(int)key.size] = '\0';
	     while(unnest(intim_flag, mals, buf, domain) != 0)
	        unnest(intim_flag, mals, buf, domain);
	    }
	}
    locursor->c_close(locursor);
    return flag;
}
#endif



