/*
// YAP2LC - an LDAP migration tool
//
// yap2lc_regexp.c
// License: GPL
// Author: Radu Negut <radun@romsys.ro>
// Version: 0.5.9 [23.12.2003]
// Section: regular expression handling
*/

#include <sys/types.h>
#include <regex.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "yap2lc.h"

regex_t *
regex_compiler(const char *string)
{
    int reg_err;
    regex_t *expression;
    char buf[MAX_NAME_LEN];
    strncpy(buf, string, strlen(string) - 1);
    buf[strlen(buf) - 1] = '\0';
    expression = (regex_t *) malloc(sizeof(regex_t));
    memset(expression, 0, sizeof(regex_t));
    if((reg_err = regcomp(expression, buf, 0)) != 0)
	{
	 regfree(expression);
	 printf("Unable to compile supplied regex; check your conf.\n");
	 exit(-1);
	}
    return expression;
}

int
regex_filter(regex_t *pattern, const char *text)
{
    regmatch_t res;
    size_t no_s = pattern->re_nsub + 1;
    if((regexec(pattern, text, no_s, &res, 0)) == 0)
	return 1;
    return 0;
}

