/*
 *  OpenAndSaveFile()   -   open the file and saves rolodex
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   29-Jan-95   first cut
 */


#include "xhead.h"
#include "xymrolo.h"
#include "defines.h"
#include "errcds.h"

int OpenAndSaveFile (fname)
char
    *fname;
{
    char
        filename[MaxTextLength];
    int
        rc;
    int
        read = 0;   /* we r writing */

    char
        message[MaxTextLength];

    unsigned int
        status;

    *message = '\0';

    /*
    ** expand file..it may has a ~ as first character
    */

    (void) strcpy(filename, fname);
    status = ExpandTilde (filename);

    if (status == False)
    {
        Warning  ("Unabel to save cards to file:", filename);
        rc = UNABLE_TO_SAVE;
        goto ExitProcessing;
    }

    rc = CheckFile (filename, read);


    switch (rc)
    {
        case FILE_IS_A_DIRECTORY:
        {
            WriteStatus (1, rolomessageTextW,
                "File is a Directory! Cards not saved!");
            goto ExitProcessing;
            break;
        }
        
        case FILE_EXISTS:
        {
            sprintf (message, "File \"%s\" exists! Want to Overwrite?",
                filename);

            rc = AskUser(w_special[TOPLEVEL_W], message);

            switch (rc)
            {
                case YES:
                {
                    WriteList (filename);
                    rc = 0;
                    break;
                }

                case NO:
                {
                    rc = 0;
                    break;
                }
            }
            break;
        }

        case FILE_IS_NOT_REGULAR:
        {
            WriteStatus (1, rolomessageTextW,
                "File is not a regular file! Roldex not saved!");
            break;
        }

        case FILE_IS_NOT_WRITABLE:
        {
            WriteStatus (1, rolomessageTextW,
                "File is not writable! Cards NOT saved!");
            break;
        }

        default:    /* file does not exist */
        {
#ifdef DEBUG
        (void) fprintf(stderr,
            "file %s does not exist..save!\n", filename);   
#endif
            WriteList (filename);
            break;
        }
    }

ExitProcessing:
    return rc;
}
