/*
 *  SetBusyCursorState ()   -   changes cursor to a visible watch
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      This function changes the arrow cursor to watch, until the work
 *      is done. It also undefines the cursor state to normal.
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  6/2/93      mm      first cut
 *  4/2/94      mm      added states, so same function can be used to undefine
 */
#include "xhead.h"
#include "xymrolo.h"


void SetBusyCursorState(w,state)
Widget
    w;
unsigned
    int state;

    /*
    * Sets the cursor to be a "watch" symbol in the Widget w
    */
  {
      static Cursor cursor;

    if (state == True)
    {
      if (w != NULL)
      {
          if (!cursor)
          cursor = XCreateFontCursor(XtDisplay(w), XC_watch);
          XDefineCursor(XtDisplay(w), XtWindow(w), cursor);
          XFlush(XtDisplay(w));
      }
    }
    else
    {
        if (w != NULL)
        XUndefineCursor (XtDisplay(w), XtWindow(w));
    }

}

