/*
 *  SetCautionCursorState() -   define/undefine caution cursor to a 
 *                              specific window
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   29-Mar-95   first cut
 */


#include "xhead.h"
#include "xymrolo.h"

void SetCautionCursorState (widget, state)
Widget
    widget;
unsigned int
    state;
{
    if (GcautionCursor != (Cursor) NULL)
    {
        switch (state)
        {
            case True:
            {
                XDefineCursor (XtDisplay(widget), XtWindow(widget),
                    GcautionCursor);
                break;
            }

            case False:
            {
                XUndefineCursor (XtDisplay(widget), XtWindow(widget));
                break;
            }
        }
    }
}
