.\" man page for Yrolo 1.1
.\" Muhammad A Muquit
.\" Email: muquit@semcor.com
.ad l
.nh
.TH Yrolo 1 "Release 1.1"
.SH NAME
yrolo \- a Rolodex(TM) like program in Motif
.SH SYNOPSIS
.B yrolo
.or
.br
.B yrolo
[\fIoptions ...\fP] or
.br
.B yrolo
[\fIoptions ...\fP] filename
.br

Where \fIoptions\fP include:
.br
.nf
  \fI-fg\fP foreground_color       sets the foreground color
  \fI-bg background_color\fP       sets the background color
  \fI-i\fP                         starts in iconic form
  \fI-iconic\fP                    starts in iconic form
  \fI-d\fP display_name             X server to contact
  \fI-display\fP display_name       X server to contact
  \fI-xrm\fP resourcestring        specifies a resource string
  \fI-h\fP                         shows short help
  \fI-V\fP                         shows Version
  \fI-nopixmaps\fP                 do not use pixmaps for cards

  \fIfilename\fP \fBis the name of a valid \fIYrolo\fP database file.\fP
.fi
.SH DESCRIPTION
Yrolo is a \fIX/Motif\fP program for maintaining, manipulating and
displaying databases of people's name, address etc. 

If the Yrolo program is started without any argument, it will try to open
a file called \fI.yrolo.yr\fP at your home directory. You may start adding
card to the database right away.  This is the default card file
Yrolo will open every time it is invoked without any argument. But you
can change the default card file by setting the environment variable
\fBYROLODEX\fP. As for Example, if your shell is \fIcsh\fP or it's variant, 
at the shell
prompt, type:

    setenv \fBYROLODEX\fP path_of_your_database

If your shell is \fIsh\fP or it's variant, at the shell prompt, type:

    \fBYROLODEX\fP=path_of_your_database
    export \fBYROLODEX\fP
.P
Any valid Yrolo database also can be opened from command line as, \fByrolo\fP
\fIfile.yr\fP. After staring the program, any valid database file also
can be opened from the \fBFile\fP menu.
.P
If you add cards to the databe, they will be saved automatically to this
file.  However if any unusual condition arises and Yrolo can not save your
cards, it will try to detect it and prompt for a filename when you
select \fBQuit\fP from the \fBFile\fP menu.

Yrolo accepts all standard X toolkit command line options. In addition it
takes a filename. As for Example:
   yrolo -bg lightblue \fIrolodex.yr\fP

The class of Yrolo is \fBYRolo\fP.  Appropriate fallback resources are
hardcoded, however if you insist to change resources, please look the file
\fBX RESOURCES\fP section.

To get \fIContextual Help\fP, select the \fIContextual Help\fP item from
the \fBHelp\fP menu.  When the pointer turns into a question, click on any
visible item on the window to get help about that item.  If no help is
available, the pointer will change back to normal..nothing will happen.

.SH "MENU ITEMS"
.nf
.B     File
         Open rolodex
         Print the displayed Card ...
         Print the entire Database ...
         Save As ...
         Quit
.B      Options
         Search Preferences ...
         Card Info ...
.B      Help
         About ...
         Hints ...
         Contextual Help
.fi
.SH "Open rolodex"
When this item is selected, a File selection dialog box will pop-up.
Enter the name of a valid Yrolo file at the Text widget labeled
\fBInput File\fP.  After entering the filename, press on the OK
button.  The dialog can be traversed using the Tab key.
.SH "Print the displayed Card"
This menu item can be selected after a card is being displayed by clicking on
the name item at the list widget.  If no card is being displayed and this
item is selected, it will write a message at the status area telling that
no card is currently being viewed.  When a card is being displayed and this
item is selected, a window will pop-up with various choices. The printing
destination can be set by clicking on the appropriate toggle button, e,g.
Printer or File. Currently \fIYrolo\fP supports only text mode.
\fIPostScript\fP support will be added at the next release.The default
print command is \fIlpr\fP. However, you can set o your favorite print command
by setting the environment variable \fBPRINT_COMMAND\fP.  If your shell is
\fIcsh\fP or it's variant, at the shell prompt, type:
.br

    setenv \fBPRINT_COMMAND\fP "lpr -Ptxt"

.br
The print command can be a pipe as well. As for example I use the \fIASCII\fP
to \fIPostScript\fP converter \fIpform\fP to print the card/s to a
\fIPostScript\fP printer. I set my \fBPRINT_COMMAND\fP like this:
.br

    export \fBPRINT_COMMAND\fP="pform -q -s 8 -f Times-Roman -l 6 -Pps"

.br
I use \fIbash\fP as my shell. By default, the fields
.B Name, 
.B Company,
and
.B Address
are selected for printing. Toggle the \fIPrint Fields\fP buttons to any
combinations you like.  When satisfied, click on the \fBPrint\fP button for
printing or click on the \fBCancel\fP button if you changed your mind. If the
menu item \fIPrint the displayed Card ...\fP is selected from the \fIFile\fP
menu, the title of the print dialog will be \fIPrint Displayed Card\fP
otherwise the title will be \fIPrint All Cards\fP.
.SH "Print the entire Database ..."
This item can be selected if there is atleast one card is loaded. Otherwise,
when this item is selected, a message will be written to the status area
telling that there is nothing to print.  If the item is successfully selected,
the same pop-up print dialog will appear as mentioned earlier.
.SH "Save As"
When this item is selected, a prompt dialog will request a filename
for saving the loaded database. Enter the filename and click on OK. No space
is allowed at the filename. '~' will be expanded if it is the first character
of the filename. As for example, if the file name is ~/file, it will be
expanded as your_home_directory/file.  If the filename is ~someone/file, it
will be expanded to the user "someone's" home directory. ~file will be saved as
it is.
.SH "Quit"
Exit the application.
.SH "Search Preferences"
When this item is selected, a dialog will pop-up with many toggle
options.  By default, Yrolo searches the whole database during search
operation. However, the search can be restricted by toggling the
options in this dialog. Click on OK button when you are done. Search can be
performed keeping this dialog up as well.
.SH "Card Info"
When this item is selected, a dialog will pop-up with information
about the loaded Yrolo database. If this dialog is up, the information
will be updated with any changes in the database or with loading a new
database.
.SH "About"
When this help item is selected. A pop-up dialog will display the version
number, author's email, URL etc.
.SH "Hints"
When this help item is selected, a pop-up window will display concise hints
about Yrolo and getting started.
.SH "Contextual Help"
When this item is selected, the pointer will turn in to question, click on
any visible item on the window to get help about that item.  If no help is
available, the pointer change back to normal..nothing will happen.
.SH "SEARCHING THE DATABASE"
The loaded database can be searched by entering a string or a bunch of strings
at the text widget located at the bottom left corner of the main window. After
entering the string, hit the \fBReturn\fP key. If there is a match, a dialog
will pop-up with the card name/s that matched the search. Click on the item at
the list to display the card at the main viewing area. 

By default, the whole database is searched. However, the search can be
restricted to one or many fields by selecting the \fISearch Preferences\fP
sub menu item from the \fIFile\fP menu.
.SH "ADDING CARD"
To add card to the database, click on the \fBAdd Card\fP push button at the
bottom of the window. When this button is licked, a window will pop-up. When
the mouse is moved on that window, the very top text widget labeled \fIName\fP
will get the focus (provided you have the keyboard focus policy set to pointer
for your window manger).  Start entering data..you can go to the next item by
hitting \fBReturn\fP key or by clicking the left mouse button. You can fill up
all or any item. When you are done, click on the \fBAccept\fP push button. A
prompt dialog will request for the confirmation.

The \fBAccept\fP button also can be activated from the \fIRemarks\fP text
window by pressing the \fBCTRL-D\fP (Control+D) key combination.
.SH "EDITING CARD"
The \fBEdit Card\fP push button gets sensitive after a card is being displayed
by clicking on the name at the list widget. When this button is clicked, the
pop-up window mentioned above will appear. All the steps are same as mentioned
in the section \fBADDING CARD\fP.
.SH "DELETE CARD"
The \fBDelete Card\fP push button becomes sensitive after a rolodex card is
being displayed by clicking on the name at the list widget. If this button is
clicked, a warning dialog will ask for the confirmation. 
.P
\fB WARNING: There is NO UNDELETE option at the time. DELETION WILL BE
PERMANENT.\fP
.SH "SENDING MAIL"
The \fBSend Mail\fP push button becomes sensitive after a rolodex card is
being displayed clicking on a name at the name list widget. When this button is
clicked, a dialog will pop-up. The \fITo:\fP field get the focus by default.
If the displayed card has a email address, the address will appear at the
\fITo:\fP text widget.  The address can be edited or many comma separated
addressees can be added.  Hit \fBReturn\fP key to go to the next item. 
.P
The body of the mail is typed at the top scrolled window. Any text or binary
file can be included by clicking on \fBInclude File\fP push button.  When the
\fBInclude File\fP push button is pressed, a file selection dialog box will
request for the filename.
.P
If the file is binary, it will be detected and automatically \fIuuencoded\fP
before including.
.P
If you have a \fI.signature\fP file at your home directory, you can sign the
letter by clicking the \fBSign\fP push button.
.P
To send mail, click on the \fBSend Mail\fP push button or \fBCTRL-D\fP key
combination while at the message editing window. A information message will be
displayed at the bottom scrolled window after the mail is sent.
.SH "X RESOURCES"
The appearance of \fIYrolo\fP can be changed using the \fIX Resource\fP file.
The default look and feel is chosen carefully using appropriate fallback
resources. However if you insist to change the resources, please make sure
that you do it right. The class of Yrolo is \fBYRolo\fP. So, the \fIX
Resources\fP can be defined in a file called \fBYRolo\fP. The usual place to
keep this file is \fI/usr/lib/X11/app-defaults\fP. If this file is kept there,
resources will be loaded at the invocation. The resource file also can
be kept at your home directory. It also can be added at the end of your
.I .Xdefaults
file.  Again the environment variable \fBXAPPLRESDIR\fP can
be  set to define the location of the \fIYRolo\fP file. Note that X
resources file takes precedence over hard coded resources, but the command line
resource specification has the \fBhighest\fP priority.
Please look at the file \fIYRolo.ad\fP for available resources.

.SH "ENVIRONEMNT VARIABLES"
.nf
    \fBYROLODEX\fP - name of the default database file.
    \fBPRINT_COMMAND\fP - name of the default print command.
.fi
.SH BUGS
No known bugs. Please report bugs to \fImuquit@semcor.com\fP. 
.SH COPYRIGHT
Copyright 1995 by Muhammad A Muquit.

Permission to use, copy, modify, distribute this software is hereby granted,
provided this copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and the name of my employer SEMCOR, Inc. and Company not be  
used in in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

The software is provided "as is" without express or implied warranty.

I disclaim all warranties with regard to this software, including all implied
warranties of merchantability and fitness, in no event shell me or my employer
SEMCOR, Inc. be liable for any special, indirect or consequential damages or
any damages whatsoever resulting from loss of use, data or profits, whether
in an action of contract, negligence or other tortious action, arising out of or
in connection with the use or performance of this software.

.SH AUTHORS
Muhammad A Muquit
.nf
.B "SEMCOR, Inc."
Warminster Engineering Center
65 West Street Road, Suite C-100
Warminster, PA 18974
Voice: (215) 674-0200
Fax:   (215) 443-0474
E-mail: \fImuquit@semcor.com\fP
.fi
