@echo off
:: 
:: yup -- print multiple PS/text images on one page.
:: Copyright (C) 1995  Malcolm Herbert
:: 
:: This program is free software; you can redistribute it and/or modify
:: it under the terms of the GNU General Public License as published by
:: the Free Software Foundation; either version 2 of the License, or
:: (at your option) any later version.
:: 
:: This program is distributed in the hope that it will be useful,
:: but WITHOUT ANY WARRANTY; without even the implied warranty of
:: MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
:: GNU General Public License for more details.
:: 
:: You should have received a copy of the GNU General Public License
:: along with this program; if not, write to the Free Software
:: Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
:: 
:: Author: Malcolm Herbert (drol@rmit.edu.au)
:: 
:: cmd-batch.bat -- Malcolm Herbert (drol@rmit.edu.au), (c) 1995
::
:: $Id: cmd-batch.bat,v 1.6 1995/02/15 02:19:45 drol Exp $

:: Set up a few flags and so on

set YUPSHH=FALSE
set YUP=%0

:: set these if the environment has them unset (to allow users to set them.)

if .%YUPDIR% == . set YUPDIR=C:\YUP
if .%YUPARG% == . set YUPARG=%YUPDIR%\YUP-DFLT.ARG
if .%YUPOUT% == . set YUPOUT=YUP.PS

:: now read first argument to see if it is -q or not

if not .%1 == .-q goto QUIETEND
  set YUPSHH=TRUE
  shift
:QUIETEND

:: if we arent being quiet, print out the banner message

if %YUPSHH% == TRUE goto BANNEREND
  echo %YUP%, by Malcolm Herbert (drol@rmit.edu.au), (c) 1995 $Revision: 1.6 $
 echo %YUP% comes with ABSOLUTELY NO WARRANTY; see the file COPYING for details.
  echo This is free software, and you are welcome to redistribute it under 
  echo certain conditions; again, see the file COPYING for details.
  echo.
:BANNEREND

:: read argument list for -h option

if not .%1 == .-h goto HELPEND
  goto USAGE
:HELPEND

:: read argument list for -d option

if not .%1 == .-d goto YUPDIREND
  shift
  if not .%1 == . goto YUPDIROK
    echo %YUP%: option -d requires an argument.
    goto USAGE
  :YUPDIROK
  set YUPDIR=%1
  if %YUPSHH% == TRUE goto DIRMSGEND
    echo YUPDIR now set to %YUPDIR%.
  :DIRMSGEND
  shift
:YUPDIREND

:: read argument list for -o option

if not .%1 == .-o goto OUTFILEEND
  shift
  if not .%1 == . goto OUTFILEOK
    echo %YUP%: option -o requires an argument.
    goto USAGE
  :OUTFILEOK
  set YUPOUT=%1
  if %YUPSHH% == TRUE goto OUTFMSGEND
    echo YUPOUT now set to %YUPOUT%.
  :OUTFMSGEND
  shift
:OUTFILEEND

:: read argument list for -a option

if not .%1 == .-a goto ARGFILEEND
  shift
  if not .%1 == . goto ARGFILEOK
    echo %YUP%: option -a requires an argument.
    goto USAGE
  :ARGFILEOK
  set YUPARG=%1
  if %YUPSHH% == TRUE goto ARGMSGEND
    echo YUPARG now set to %YUPARG%.
  :ARGMSGEND
  shift
:ARGFILEEND

:: if there are no arguments ...

if not .%1 == . goto YUP
  echo %YUP%: no files specified for input.
  goto USAGE
:YUP

:: check that header, args, body and trailer files exist ...

if not exist %YUPDIR%\YUP-HEAD.PS goto FILEMISS
if not exist %YUPDIR%\YUP-BODY.PS goto FILEMISS
if not exist %YUPDIR%\YUP-TRL.PS goto FILEMISS
if not exist %YUPARG% goto FILEMISS

goto FILEOK

:FILEMISS

echo %YUP%: fatal error: one of 
echo %YUPDIR%\YUP-HEAD.PS, %YUPDIR%\YUP-BODY.PS,
echo %YUPDIR%\YUP-TRL.PS or %YUPARG% is missing.  
echo Please make sure that settings in %YUP% are correct or specify 
echo correct filenames for options -d and -a.
echo.

goto done

:FILEOK

if %YUPSHH% == TRUE goto OUTMSGEND
  echo %YUP% is outputting to %YUPOUT% with argument file %YUPARG%.
:OUTMSGEND

type %YUPDIR%\YUP-HEAD.PS > %YUPOUT%
type %YUPARG% >> %YUPOUT%
type %YUPDIR%\YUP-BODY.PS >> %YUPOUT%

:LOOP

if .%1 == . goto BREAK

  :: what if the file does not exist?

  if exist %1 goto FILETHERE
    echo warning: file %1 skipped -- does not exist.
    goto FILESKIP
  :FILETHERE

  :: what if the file is the same as our output file?

  if not %1 == %YUPOUT% goto NOLOOP
    echo warning: file %1 skipped -- same as output file.
    goto FILESKIP
  :NOLOOP

  echo mark ps_text >> %YUPOUT%
  echo %%%%YupFile: %1 >> %YUPOUT%
  type /b %1 >> %YUPOUT%
  echo %%%%YupEOF >> %YUPOUT%
  if %YUPSHH% == TRUE goto FINFILEEND
    echo (%1)
  :FINFILEEND

  :FILESKIP
  shift
  goto LOOP

:BREAK

type %YUPDIR%\YUP-TRL.PS >> %YUPOUT%
if %YUPSHH% == TRUE goto FINMSGEND
  echo Done.
:FINMSGEND
goto DONE

:USAGE

echo usage: %YUP% [-q] [-h] [-d yupdir] [-o outfile] [-a argfile] file [file..]
echo.

if not .%1 == .-h goto DONE 

echo Options are case sensitive and must appear in the order above if you want
echo to specify more than one.  Option -q suppresses output of status messages,
echo while option -h gives this help.  Option -d specifies the directory in
echo which yup can find its files.  Options -o and -a take filenames as 
echo arguments and specify files to dump output to and take arguments from 
echo respectively.  There is no wild-card matching of filenames.
echo.
echo If you would like to change any of the standard options for yup, make a 
echo copy of %YUPDIR%\YUP-ARGS.PS and modify to taste using any text editor.
echo You can then use it by specifying it as an argument to the -a option.
echo Other argument files are listed in distribution documentation.
echo.
echo Note:  This is the simple batch version of yup, and is not as easy to
echo change as the DOS perl version, which should also have come with this
echo distribution.  For more information consult the documentation files.
echo.

:DONE 
