/*
 * Decompiled with CFR 0.152.
 */
package cycinf.infstats;

import cycinf.constraints.Constraint;
import cycinf.constraints.ConstraintParser;
import cycinf.constraints.CvarRef;
import cycinf.cvars.Cvar;
import cycinf.cvars.Decision;
import cycinf.cvars.DecisionToCvarKeyer;
import cycinf.cvars.ptrbnd.PointerKindDecisionParser;
import cycinf.infstats.DirTracker;
import cycinf.infstats.LoadInfstatsJob;
import cycinf.reasoning.RConstraint;
import cycinf.reasoning.RConstraintKeyer;
import cycinf.reasoning.RConstraintTop;
import cycinf.reasoning.RCvarRef;
import cycinf.reasoning.RLocationNode;
import cycinf.reasoning.RNode;
import general.util.Collections2;
import general.util.GenericNonsense;
import general.util.HashKeyedSet;
import general.util.KeyedSet;
import general.util.Keyer;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DirInfstats {
    private DirTracker dir;
    private boolean loaded = false;
    private Date loadDate;
    long stamp;
    private int numParseErrors;
    private final KeyedSet<Cvar, Decision> decisions = new HashKeyedSet((Keyer)new DecisionToCvarKeyer());
    private final HashKeyedSet<Constraint, RConstraintTop> constraints = new HashKeyedSet((Keyer)new RConstraintKeyer());
    private final Map<Cvar, Set<RNode<?>>> cvarsToReferences = new HashMap();
    private final Set<RLocationNode> constraintLocations = new HashSet();
    private final Map<Cvar, Set<RConstraint<?>>> cvarsToDeterminingConstraints = new HashMap();
    LoadInfstatsJob job;

    public DirTracker getDir() {
        return this.dir;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private void checkLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException();
        }
    }

    public Date getLoadDate() {
        this.checkLoaded();
        return this.loadDate;
    }

    public long getStamp() {
        this.checkLoaded();
        return this.stamp;
    }

    public int getNumParseErrors() {
        return this.numParseErrors;
    }

    public void logParseError() {
        if (this.loaded) {
            throw new IllegalStateException();
        }
        ++this.numParseErrors;
    }

    DirInfstats(DirTracker dir) {
        this.dir = dir;
        this.numParseErrors = 0;
    }

    public KeyedSet<Cvar, Decision> getDecisions() {
        return Collections2.unmodifiableKeyedSet((KeyedSet)this.decisions);
    }

    public Decision getDecisionOnCvar(Cvar cvar) {
        return (Decision)this.decisions.lookup((Object)cvar);
    }

    public KeyedSet<Constraint, RConstraintTop> getConstraints() {
        return Collections2.unmodifiableKeyedSet((KeyedSet)this.constraints);
    }

    public Set<RNode<?>> getReferencesTo(Cvar cvar) {
        Set s1 = (Set)this.cvarsToReferences.get(cvar);
        if (s1 == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(s1);
    }

    private Set<RNode<?>> getReferencesTo2(Cvar cvar) {
        HashSet s1 = (HashSet)this.cvarsToReferences.get(cvar);
        if (s1 == null) {
            s1 = new HashSet();
            this.cvarsToReferences.put(cvar, s1);
        }
        return s1;
    }

    public Set<RLocationNode> getConstraintLocations() {
        return Collections.unmodifiableSet(this.constraintLocations);
    }

    public Set<RConstraint<?>> getConstraintsDetermining(Cvar cvar) {
        Set s1 = (Set)this.cvarsToDeterminingConstraints.get(cvar);
        if (s1 == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(s1);
    }

    private Set<RConstraint<?>> getConstraintsDetermining2(Cvar cvar) {
        HashSet s1 = (HashSet)this.cvarsToDeterminingConstraints.get(cvar);
        if (s1 == null) {
            s1 = new HashSet();
            this.cvarsToDeterminingConstraints.put(cvar, s1);
        }
        return s1;
    }

    private void scanConstraint(RNode<?> n) {
        RNode[] children;
        Cvar cvar;
        RCvarRef n2;
        if (n instanceof RCvarRef) {
            n2 = (RCvarRef)GenericNonsense.workaroundCast(RCvarRef.class, n);
            Set s = this.getReferencesTo2(((CvarRef)n2.getBack()).getCvar());
            s.add(n);
        }
        if (n instanceof RLocationNode) {
            n2 = (RLocationNode)GenericNonsense.workaroundCast(RLocationNode.class, n);
            this.constraintLocations.add(n2);
        }
        if (n instanceof RConstraint && (cvar = (n2 = (RConstraint)GenericNonsense.workaroundCast(RConstraint.class, n)).getConstrainedVar()) != null && n2.isEffective()) {
            this.getConstraintsDetermining2(cvar).add(n2);
        }
        RNode[] rNodeArray = children = n.getTreeChildren();
        int n3 = 0;
        int n4 = rNodeArray.length;
        while (n3 < n4) {
            RNode n22 = rNodeArray[n3];
            this.scanConstraint(n22);
            ++n3;
        }
    }

    void scheduleLoading(boolean automatic) {
        this.job = new LoadInfstatsJob(this, automatic);
        this.job.schedule();
    }

    void waitUntilLoaded() {
        try {
            this.job.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void loadDecisions(BufferedReader in, int nd1, IProgressMonitor pm) throws IOException {
        pm.beginTask("Reading inference decisions from the Cyclone compiler", nd1);
        pm.subTask("Preparing");
        int i = 0;
        while (i < nd1) {
            pm.subTask("Reading inference decision #" + i);
            String line = in.readLine();
            if (line == null) {
                System.err.println("Unexpected EOF");
                this.logParseError();
                break;
            }
            Decision id = PointerKindDecisionParser.parse((DirInfstats)this, (String)line);
            if (id != null) {
                this.decisions.add((Object)id);
            }
            ++i;
            pm.worked(1);
        }
        pm.subTask("Finishing");
    }

    void loadConstraints(BufferedReader in, int nd1, IProgressMonitor pm) throws IOException {
        pm.beginTask("Loading constraints from the \"cvars\" file", nd1);
        pm.subTask("Preparing");
        int i = 0;
        while (i < nd1) {
            pm.subTask("Reading cvars line #" + i);
            String line = in.readLine();
            if (line == null) {
                System.err.println("Unexpected EOF");
                this.logParseError();
                break;
            }
            ConstraintParser.parse((DirInfstats)this, (String)line);
            ++i;
            pm.worked(1);
        }
        pm.subTask("Finishing");
    }

    public void logConstraint(Constraint c) {
        if (this.constraints.lookup((Object)c) == null) {
            RConstraintTop rc = new RConstraintTop(this, c);
            this.constraints.add((Object)rc);
            this.scanConstraint(rc.getNode());
        }
    }

    void markLoaded() {
        this.loadDate = new Date();
        this.loaded = true;
    }
}

