/*
 * Decompiled with CFR 0.152.
 */
package cycinf.ui;

import cycinf.cvars.Decision;
import cycinf.reasoning.RConstraintTop;
import cycinf.reasoning.RCvarRef;
import cycinf.reasoning.RLocationNode;
import cycinf.reasoning.RNode;
import cycinf.ui.ConstraintView;
import cycinf.ui.GlobalSelectionListener;
import cycinf.ui.UIUtils;
import general.util.GenericNonsense;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.part.ViewPart;

public class ConstraintView
extends ViewPart {
    public static final String PART_ID = "cycinf.ConstraintView";
    RConstraintTop constraint;
    Composite viewArea;
    private Layout viewAreaLayout;
    private Label label;
    TreeViewer ceStructureViewer;
    Action goToDecisionAction;
    private Observer infstatsObserver = new /* Unavailable Anonymous Inner Class!! */;
    GlobalSelectionListener<RNode<?>> globalSelectionListener;

    void doRevealSomething() {
        ISelection selection = this.ceStructureViewer.getSelection();
        if (!selection.isEmpty()) {
            RNode n = (RNode)((IStructuredSelection)selection).getFirstElement();
            if (n instanceof RLocationNode) {
                UIUtils.revealRLocationNode((RLocationNode)((RLocationNode)GenericNonsense.workaroundCast(RLocationNode.class, (Object)n)));
            } else if (n instanceof RCvarRef) {
                Decision d = ((RCvarRef)GenericNonsense.workaroundCast(RCvarRef.class, (Object)n)).getDecisionOnTheCvar();
                UIUtils.revealDecision((Decision)d);
                UIUtils.notifyReasoningView((Decision)d);
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.viewArea = parent;
        this.viewAreaLayout = new FormLayout();
        this.viewArea.setLayout(this.viewAreaLayout);
        this.ceStructureViewer = new TreeViewer(parent, 770);
        this.ceStructureViewer.setContentProvider((IContentProvider)new ViewContentProvider(this));
        this.ceStructureViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(this));
        this.ceStructureViewer.setAutoExpandLevel(-1);
        this.label = new Label(this.viewArea, 16448);
        this.setConstraint(null);
        FormData lbd = new FormData();
        lbd.top = new FormAttachment(0, 2);
        lbd.left = new FormAttachment(0, 2);
        lbd.right = new FormAttachment(100, -2);
        this.label.setLayoutData((Object)lbd);
        FormData ifd = new FormData();
        ifd.top = new FormAttachment((Control)this.label, 2);
        ifd.bottom = new FormAttachment(100, -2);
        ifd.left = new FormAttachment(0, 2);
        ifd.right = new FormAttachment(100, -2);
        this.ceStructureViewer.getControl().setLayoutData((Object)ifd);
        this.goToDecisionAction = new /* Unavailable Anonymous Inner Class!! */;
        this.ceStructureViewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.globalSelectionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.getSite().setSelectionProvider((ISelectionProvider)this.ceStructureViewer);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this.globalSelectionListener);
    }

    void setConstraint(RConstraintTop c) {
        if (this.constraint != null) {
            this.constraint.getOwningInfstats().getDir().deleteObserver(this.infstatsObserver);
        }
        this.ceStructureViewer.setInput((Object)(c == null ? null : new ConstraintWrapper(this, c)));
        if (c == null) {
            this.label.setText("Empty.  Select a constraint.");
        } else {
            this.label.setText("Constraint structure:");
        }
        this.viewArea.layout();
        if (this.constraint != null) {
            this.constraint.getOwningInfstats().getDir().addObserver(this.infstatsObserver);
        }
    }

    void refresh() {
        this.setConstraint(null);
    }

    public void setFocus() {
        this.ceStructureViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.globalSelectionListener.unregister();
    }
}

