/*
 * Decompiled with CFR 0.152.
 */
package cycinf.ui;

import cycinf.cvars.Cvar;
import cycinf.cvars.Decision;
import cycinf.infstats.DirInfstats;
import cycinf.ui.DecisionView;
import cycinf.ui.GlobalSelectionListener;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.part.ViewPart;

public class DecisionView
extends ViewPart {
    public static final String PART_ID = "cycinf.DecisionView";
    Decision decision;
    Composite viewArea;
    private Layout viewAreaLayout;
    private Label label;
    TableViewer referringConstraintsViewer;
    private static final int CONSTRAINT_STRING_COLUMN = 0;
    private Observer infstatsObserver = new /* Unavailable Anonymous Inner Class!! */;
    GlobalSelectionListener<Decision> globalSelectionListener;

    public void createPartControl(Composite parent) {
        this.viewArea = parent;
        this.viewAreaLayout = new FormLayout();
        this.viewArea.setLayout(this.viewAreaLayout);
        this.referringConstraintsViewer = new TableViewer(parent, 770);
        this.referringConstraintsViewer.setContentProvider((IContentProvider)new ViewContentProvider(this));
        this.referringConstraintsViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(this));
        this.label = new Label(this.viewArea, 16448);
        this.setDecision(null);
        FormData lbd = new FormData();
        lbd.top = new FormAttachment(0, 2);
        lbd.left = new FormAttachment(0, 2);
        lbd.right = new FormAttachment(100, -2);
        this.label.setLayoutData((Object)lbd);
        FormData ifd = new FormData();
        ifd.top = new FormAttachment((Control)this.label, 2);
        ifd.bottom = new FormAttachment(100, -2);
        ifd.left = new FormAttachment(0, 2);
        ifd.right = new FormAttachment(100, -2);
        this.referringConstraintsViewer.getControl().setLayoutData((Object)ifd);
        this.globalSelectionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.getSite().setSelectionProvider((ISelectionProvider)this.referringConstraintsViewer);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this.globalSelectionListener);
    }

    void setDecision(Decision d) {
        if (this.decision != null) {
            this.decision.getOwningInfstats().getDir().deleteObserver(this.infstatsObserver);
        }
        this.referringConstraintsViewer.setInput((Object)d);
        if (d == null) {
            this.label.setText("Empty.  Select a decision.");
        } else {
            this.label.setText("Constraints referring to " + d.getCvar().prettyString());
        }
        this.viewArea.layout();
        if (this.decision != null) {
            this.decision.getOwningInfstats().getDir().addObserver(this.infstatsObserver);
        }
    }

    void refresh() {
        Cvar cvar = this.decision.getCvar();
        DirInfstats newInfstats = this.decision.getOwningInfstats().getDir().getCurInfstats();
        if (newInfstats == null) {
            this.setDecision(null);
        } else {
            Decision newDecision = newInfstats.getDecisionOnCvar(cvar);
            this.setDecision(newDecision);
        }
    }

    public void setFocus() {
        this.referringConstraintsViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.globalSelectionListener.unregister();
    }
}

